/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.net.Socket;
import javax.net.ssl.SSLSession;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.SSLSupport;
import org.apache.tomcat.util.net.SSLUtil;
import org.apache.tomcat.util.net.ServerSocketFactory;
import org.apache.tomcat.util.net.jsse.JSSEImplementation;

public abstract class SSLImplementation {
    private static final Log logger = LogFactory.getLog(SSLImplementation.class);
    private static final String JSSEImplementationClass = "org.apache.tomcat.util.net.jsse.JSSEImplementation";
    private static final String[] implementations = new String[]{"org.apache.tomcat.util.net.jsse.JSSEImplementation"};

    public static SSLImplementation getInstance() throws ClassNotFoundException {
        for (int i = 0; i < implementations.length; ++i) {
            try {
                SSLImplementation sSLImplementation = SSLImplementation.getInstance(implementations[i]);
                return sSLImplementation;
            }
            catch (Exception exception) {
                if (!logger.isTraceEnabled()) continue;
                logger.trace((Object)("Error creating " + implementations[i]), (Throwable)exception);
                continue;
            }
        }
        throw new ClassNotFoundException("Can't find any SSL implementation");
    }

    public static SSLImplementation getInstance(String string) throws ClassNotFoundException {
        if (string == null) {
            return SSLImplementation.getInstance();
        }
        try {
            if (JSSEImplementationClass.equals(string)) {
                return new JSSEImplementation();
            }
            Class<?> clazz = Class.forName(string);
            return (SSLImplementation)clazz.newInstance();
        }
        catch (Exception exception) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Error loading SSL Implementation " + string), (Throwable)exception);
            }
            throw new ClassNotFoundException("Error loading SSL Implementation " + string + " :" + exception.toString());
        }
    }

    public abstract String getImplementationName();

    public abstract ServerSocketFactory getServerSocketFactory(AbstractEndpoint<?> var1);

    public abstract SSLSupport getSSLSupport(Socket var1);

    public abstract SSLSupport getSSLSupport(SSLSession var1);

    public abstract SSLUtil getSSLUtil(AbstractEndpoint<?> var1);
}

