/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AbstractVar;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeIterators;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Reference;
import com.google.javascript.jscomp.ReferenceCollectingCallback;
import com.google.javascript.jscomp.ReferenceCollection;
import com.google.javascript.jscomp.ReferenceMap;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.SyntacticScopeCreator;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class InlineVariables
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final Mode mode;
    private final boolean inlineAllStrings;

    InlineVariables(AbstractCompiler compiler, Mode mode, boolean inlineAllStrings) {
        this.compiler = compiler;
        this.mode = mode;
        this.inlineAllStrings = inlineAllStrings;
    }

    @Override
    public void process(Node externs, Node root) {
        ReferenceCollectingCallback callback = new ReferenceCollectingCallback(this.compiler, new InliningBehavior(), new SyntacticScopeCreator(this.compiler), this.mode.varPredicate);
        callback.process(externs, root);
    }

    private static boolean hasNoInlineAnnotation(Var var) {
        JSDocInfo jsDocInfo = var.getJSDocInfo();
        return jsDocInfo != null && jsDocInfo.isNoInline();
    }

    private class InliningBehavior
    implements ReferenceCollectingCallback.Behavior {
        private final Set<Var> staleVars = new HashSet<Var>();
        final Map<Node, AliasCandidate> aliasCandidates = new HashMap<Node, AliasCandidate>();

        private InliningBehavior() {
        }

        @Override
        public void afterExitScope(NodeTraversal t, ReferenceMap referenceMap) {
            this.collectAliasCandidates(t, referenceMap);
            this.doInlinesForScope(t, referenceMap);
        }

        private void collectAliasCandidates(NodeTraversal t, ReferenceMap referenceMap) {
            if (InlineVariables.this.mode != Mode.CONSTANTS_ONLY) {
                for (Var v : t.getScope().getVarIterable()) {
                    Reference init;
                    Node value;
                    ReferenceCollection referenceInfo = referenceMap.getReferences(v);
                    if (referenceInfo == null || referenceInfo.references.size() < 2 || !referenceInfo.isWellDefined() || !referenceInfo.isAssignedOnceInLifetime() || (value = (init = referenceInfo.getInitializingReference()).getAssignedValue()) == null || !value.isName() || value.getString().equals(v.getName())) continue;
                    this.aliasCandidates.put(value, new AliasCandidate(v, referenceInfo));
                }
            }
        }

        private void doInlinesForScope(NodeTraversal t, ReferenceMap referenceMap) {
            boolean maybeModifiedArguments = this.maybeEscapedOrModifiedArguments(t.getScope(), referenceMap);
            for (Var v : t.getScope().getVarIterable()) {
                ReferenceCollection referenceInfo = referenceMap.getReferences(v);
                if (referenceInfo == null || this.isVarInlineForbidden(v)) continue;
                if (this.isInlineableDeclaredConstant(v, referenceInfo)) {
                    Reference init = referenceInfo.getInitializingReferenceForConstants();
                    Node value = init.getAssignedValue();
                    this.inlineDeclaredConstant(v, value, referenceInfo.references);
                    this.staleVars.add(v);
                    continue;
                }
                if (InlineVariables.this.mode == Mode.CONSTANTS_ONLY) continue;
                this.inlineNonConstants(v, referenceInfo, maybeModifiedArguments);
            }
        }

        private boolean maybeEscapedOrModifiedArguments(Scope scope, ReferenceMap referenceMap) {
            Var arguments;
            ReferenceCollection refs;
            if (scope.isFunctionScope() && !scope.getRootNode().isArrowFunction() && (refs = referenceMap.getReferences(arguments = (Var)scope.getArgumentsVar())) != null && !refs.references.isEmpty()) {
                for (Reference ref : refs.references) {
                    Node refNode = ref.getNode();
                    Node refParent = ref.getParent();
                    if (NodeUtil.isNormalGet(refParent) && refNode == ref.getParent().getFirstChild() && !NodeUtil.isLValue(refParent)) continue;
                    return true;
                }
            }
            return false;
        }

        private void inlineNonConstants(Var v, ReferenceCollection referenceInfo, boolean maybeModifiedArguments) {
            Node value;
            Reference init;
            int firstRefAfterInit;
            int refCount = referenceInfo.references.size();
            Reference declaration = referenceInfo.references.get(0);
            int n = firstRefAfterInit = declaration == (init = referenceInfo.getInitializingReference()) ? 2 : 3;
            if (refCount > 1 && this.isImmutableAndWellDefinedVariable(v, referenceInfo)) {
                if (init != null) {
                    value = init.getAssignedValue();
                } else {
                    Node srcLocation = declaration.getNode();
                    value = NodeUtil.newUndefinedNode(srcLocation);
                }
                Preconditions.checkNotNull(value);
                this.inlineWellDefinedVariable(v, value, referenceInfo.references);
                this.staleVars.add(v);
            } else if (refCount == firstRefAfterInit) {
                Reference reference = referenceInfo.references.get(firstRefAfterInit - 1);
                if (this.canInline(declaration, init, reference)) {
                    this.inline(v, declaration, init, reference);
                    this.staleVars.add(v);
                }
            } else if (declaration != init && refCount == 2 && this.isValidDeclaration(declaration) && this.isValidInitialization(init)) {
                value = init.getAssignedValue();
                Preconditions.checkNotNull(value);
                this.inlineWellDefinedVariable(v, value, referenceInfo.references);
                this.staleVars.add(v);
            }
            if (!maybeModifiedArguments && !this.staleVars.contains(v) && referenceInfo.isWellDefined() && referenceInfo.isAssignedOnceInLifetime()) {
                List<Reference> refs = referenceInfo.references;
                for (int i = 1; i < refs.size(); ++i) {
                    AliasCandidate candidate;
                    Node nameNode = refs.get(i).getNode();
                    if (!this.aliasCandidates.containsKey(nameNode) || this.staleVars.contains((candidate = this.aliasCandidates.get(nameNode)).alias) || this.isVarInlineForbidden(candidate.alias)) continue;
                    Reference aliasInit = candidate.refInfo.getInitializingReference();
                    Node value2 = aliasInit.getAssignedValue();
                    Preconditions.checkNotNull(value2);
                    this.inlineWellDefinedVariable(candidate.alias, value2, ((AliasCandidate)candidate).refInfo.references);
                    this.staleVars.add(candidate.alias);
                }
            }
        }

        private void recordStaleVarReferencesInTree(Node root, Scope scope) {
            for (Node c = root.getFirstChild(); c != null; c = c.getNext()) {
                this.recordStaleVarReferencesInTree(c, scope);
            }
            if (root.isName()) {
                this.staleVars.add((Var)scope.getVar(root.getString()));
            }
        }

        private boolean isVarInlineForbidden(Var var) {
            return var.isExtern() || InlineVariables.this.compiler.getCodingConvention().isExported(var.getName(), var.isLocal()) || InlineVariables.this.compiler.getCodingConvention().isPropertyRenameFunction(var.getNameNode().getOriginalQualifiedName()) || this.staleVars.contains(var) || InlineVariables.hasNoInlineAnnotation(var);
        }

        private void inline(Var v, Reference decl, Reference init, Reference ref) {
            Node value = init.getAssignedValue();
            Preconditions.checkState(value != null);
            boolean isFunctionDeclaration = NodeUtil.isFunctionDeclaration(value);
            if (isFunctionDeclaration) {
                InlineVariables.this.compiler.reportChangeToChangeScope(value);
                InlineVariables.this.compiler.reportChangeToEnclosingScope(value.getParent());
            }
            this.inlineValue(v, ref, value.detach());
            if (decl != init) {
                Node expressRoot = init.getGrandparent();
                Preconditions.checkState(expressRoot.isExprResult());
                NodeUtil.removeChild(expressRoot.getParent(), expressRoot);
            }
            if (!isFunctionDeclaration) {
                this.removeDeclaration(decl);
            }
        }

        private void inlineWellDefinedVariable(Var v, Node value, List<Reference> refSet) {
            Reference decl = refSet.get(0);
            for (int i = 1; i < refSet.size(); ++i) {
                Node clonedValue = value.cloneTree();
                NodeUtil.markNewScopesChanged(clonedValue, InlineVariables.this.compiler);
                this.inlineValue(v, refSet.get(i), clonedValue);
            }
            this.removeDeclaration(decl);
        }

        private void inlineDeclaredConstant(Var v, Node value, List<Reference> refSet) {
            Reference decl = null;
            for (Reference r : refSet) {
                if (r.getNode() == v.getNameNode()) {
                    decl = r;
                    continue;
                }
                Node clonedValue = value.cloneTree();
                NodeUtil.markNewScopesChanged(clonedValue, InlineVariables.this.compiler);
                this.inlineValue(v, r, clonedValue);
            }
            this.removeDeclaration(decl);
        }

        private void removeDeclaration(Reference decl) {
            Node varNode = decl.getParent();
            Preconditions.checkState(NodeUtil.isNameDeclaration(varNode), varNode);
            Node grandparent = decl.getGrandparent();
            InlineVariables.this.compiler.reportChangeToEnclosingScope(decl.getNode());
            varNode.removeChild(decl.getNode());
            if (!varNode.hasChildren()) {
                NodeUtil.removeChild(grandparent, varNode);
            }
        }

        private void inlineValue(Var v, Reference ref, Node value) {
            InlineVariables.this.compiler.reportChangeToEnclosingScope(ref.getNode());
            if (ref.isSimpleAssignmentToName()) {
                this.replaceChildPreserveCast(ref.getGrandparent(), ref.getParent(), value);
            } else {
                this.replaceChildPreserveCast(ref.getParent(), ref.getNode(), value);
            }
            this.recordStaleVarReferencesInTree(value, (Scope)v.getScope());
        }

        private void replaceChildPreserveCast(Node parent, Node child, Node replacement) {
            JSType typeBeforeCast = child.getJSTypeBeforeCast();
            if (typeBeforeCast != null) {
                replacement.setJSTypeBeforeCast(typeBeforeCast);
                replacement.setJSType(child.getJSType());
            }
            parent.replaceChild(child, replacement);
            NodeUtil.markFunctionsDeleted(child, InlineVariables.this.compiler);
        }

        private boolean isInlineableDeclaredConstant(Var var, ReferenceCollection refInfo) {
            if (!Mode.CONSTANTS_ONLY.varPredicate.apply(var)) {
                return false;
            }
            if (!refInfo.isAssignedOnceInLifetime()) {
                return false;
            }
            Reference init = refInfo.getInitializingReferenceForConstants();
            if (init == null) {
                return false;
            }
            Node value = init.getAssignedValue();
            if (value == null) {
                return false;
            }
            if (!NodeUtil.isImmutableValue(value)) {
                return false;
            }
            return !value.isString() || this.isStringWorthInlining(var, refInfo.references);
        }

        private boolean isStringWorthInlining(Var var, List<Reference> refs) {
            if (!InlineVariables.this.inlineAllStrings && !var.isDefine()) {
                int inlineBytes;
                int len = var.getInitialValue().getString().length() + "''".length();
                int noInlineBytes = "var xx=;".length() + len + 4 * (refs.size() - 1);
                return noInlineBytes >= (inlineBytes = (len - 1) * (refs.size() - 1));
            }
            return true;
        }

        private boolean canInline(Reference declaration, Reference initialization, Reference reference) {
            if (!(this.isValidDeclaration(declaration) && this.isValidInitialization(initialization) && this.isValidReference(reference))) {
                return false;
            }
            if (declaration != initialization && !initialization.getGrandparent().isExprResult()) {
                return false;
            }
            if (declaration.getBasicBlock() != initialization.getBasicBlock() || declaration.getBasicBlock() != reference.getBasicBlock()) {
                return false;
            }
            Node value = initialization.getAssignedValue();
            Preconditions.checkState(value != null);
            if (value.isGetProp() && reference.getParent().isCall() && reference.getParent().getFirstChild() == reference.getNode()) {
                return false;
            }
            if (value.isFunction()) {
                Node callNode = reference.getParent();
                if (reference.getParent().isCall()) {
                    CodingConvention convention = InlineVariables.this.compiler.getCodingConvention();
                    CodingConvention.SubclassRelationship relationship = convention.getClassesDefinedByCall(callNode);
                    if (relationship != null) {
                        return false;
                    }
                    if (convention.getSingletonGetterClassName(callNode) != null) {
                        return false;
                    }
                }
            }
            if (initialization.getScope() != declaration.getScope() || !initialization.getScope().contains(reference.getScope())) {
                return false;
            }
            return this.canMoveAggressively(value) || this.canMoveModerately(initialization, reference);
        }

        private boolean canMoveAggressively(Node value) {
            return NodeUtil.isLiteralValue(value, true) || value.isFunction();
        }

        private boolean canMoveModerately(Reference initialization, Reference reference) {
            NodeIterators.LocalVarMotion it;
            if (NodeUtil.isNameDeclaration(initialization.getParent())) {
                it = NodeIterators.LocalVarMotion.forVar(InlineVariables.this.compiler, initialization.getNode(), initialization.getParent(), initialization.getGrandparent());
            } else if (initialization.getParent().isAssign()) {
                Preconditions.checkState(initialization.getGrandparent().isExprResult());
                it = NodeIterators.LocalVarMotion.forAssign(InlineVariables.this.compiler, initialization.getNode(), initialization.getParent(), initialization.getGrandparent(), initialization.getGrandparent().getParent());
            } else {
                throw new IllegalStateException("Unexpected initialization parent\n" + initialization.getParent().toStringTree());
            }
            Node targetName = reference.getNode();
            while (it.hasNext()) {
                Node curNode = (Node)it.next();
                if (curNode != targetName) continue;
                return true;
            }
            return false;
        }

        private boolean isValidDeclaration(Reference declaration) {
            return NodeUtil.isNameDeclaration(declaration.getParent()) && !NodeUtil.isLoopStructure(declaration.getGrandparent()) || NodeUtil.isFunctionDeclaration(declaration.getParent());
        }

        private boolean isValidInitialization(Reference initialization) {
            Node n;
            if (initialization == null) {
                return false;
            }
            if (initialization.isDeclaration()) {
                if (!NodeUtil.isFunctionDeclaration(initialization.getParent()) && !initialization.getNode().hasChildren()) {
                    return false;
                }
            } else {
                Node parent = initialization.getParent();
                Preconditions.checkState(parent.isAssign() && parent.getFirstChild() == initialization.getNode());
            }
            if ((n = initialization.getAssignedValue()).isFunction()) {
                return InlineVariables.this.compiler.getCodingConvention().isInlinableFunction(n);
            }
            return true;
        }

        private boolean isValidReference(Reference reference) {
            return !reference.isDeclaration() && !reference.isLvalue();
        }

        private boolean isImmutableAndWellDefinedVariable(Var v, ReferenceCollection refInfo) {
            List<Reference> refSet = refInfo.references;
            int startingReadRef = 1;
            Reference refDecl = refSet.get(0);
            if (!this.isValidDeclaration(refDecl)) {
                return false;
            }
            boolean isNeverAssigned = refInfo.isNeverAssigned();
            if (!isNeverAssigned) {
                boolean isInlinableThisAlias;
                Reference refInit = refInfo.getInitializingReference();
                if (!this.isValidInitialization(refInit)) {
                    return false;
                }
                if (refDecl != refInit) {
                    Preconditions.checkState(refInit == refSet.get(1));
                    startingReadRef = 2;
                }
                if (!refInfo.isWellDefined()) {
                    return false;
                }
                Node value = refInit.getAssignedValue();
                Preconditions.checkNotNull(value);
                boolean isImmutableValueWorthInlining = NodeUtil.isImmutableValue(value) && (!value.isString() || this.isStringWorthInlining(v, refInfo.references));
                boolean bl = isInlinableThisAlias = value.isThis() && !refInfo.isEscaped();
                if (!isImmutableValueWorthInlining && !isInlinableThisAlias) {
                    return false;
                }
            }
            for (int i = startingReadRef; i < refSet.size(); ++i) {
                Reference ref = refSet.get(i);
                if (this.isValidReference(ref)) continue;
                return false;
            }
            return true;
        }
    }

    private static class AliasCandidate {
        private final Var alias;
        private final ReferenceCollection refInfo;

        AliasCandidate(Var alias, ReferenceCollection refInfo) {
            this.alias = alias;
            this.refInfo = refInfo;
        }
    }

    static enum Mode {
        CONSTANTS_ONLY(AbstractVar::isDeclaredOrInferredConst),
        LOCALS_ONLY(AbstractVar::isLocal),
        ALL(Predicates.alwaysTrue());

        private final Predicate<Var> varPredicate;

        private Mode(Predicate<Var> varPredicate) {
            this.varPredicate = varPredicate;
        }
    }
}

