#!/usr/bin/python
# -*- coding: utf-8 -*-
# Copyright 2019 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the resource
#   module builder playbook.
#
# Do not edit this file manually.
#
# Changes to this file will be over written
#   by the resource module builder.
#
# Changes should be made in the model used to
#   generate this file or in the resource module
#   builder template.
#
#############################################

"""
The module file for nxos_vlans
"""

from __future__ import absolute_import, division, print_function

__metaclass__ = type


DOCUMENTATION = """
module: nxos_vlans
short_description: VLANs resource module
description: This module creates and manages VLAN configurations on Cisco NX-OS.
version_added: 1.0.0
author: Trishna Guha (@trishnaguha)
notes:
- Tested against NXOS 7.3.(0)D1(1) on VIRL
options:
  running_config:
    description:
    - This option is used only with state I(parsed).
    - The value of this option should be the output received from the NX-OS device
      by executing the commands B(show vlans | json-pretty) and B(show running-config
      | section ^vlan) in order and delimited by a line.
    - The state I(parsed) reads the configuration from C(running_config) option and
      transforms it into Ansible structured data as per the resource module's argspec
      and the value is then returned in the I(parsed) key within the result.
    type: str
  config:
    description: A dictionary of Vlan options
    type: list
    elements: dict
    suboptions:
      vlan_id:
        description:
        - Vlan ID.
        type: int
        required: true
      name:
        description:
        - Name of VLAN.
        type: str
      state:
        description:
        - Manage operational state of the vlan.
        type: str
        choices:
        - active
        - suspend
      enabled:
        description:
        - Manage administrative state of the vlan.
        type: bool
      mode:
        description:
        - Set vlan mode to classical ethernet or fabricpath. This is a valid option
          for Nexus 5000, 6000 and 7000 series.
        type: str
        choices:
        - ce
        - fabricpath
      mapped_vni:
        description:
        - The Virtual Network Identifier (VNI) ID that is mapped to the VLAN.
        type: int
  state:
    description:
    - The state of the configuration after module completion.
    - The state I(overridden) would override the configuration of all the
      VLANs on the device (including VLAN 1) with the provided configuration in
      the task. Use caution with this state.
    type: str
    choices:
    - merged
    - replaced
    - overridden
    - deleted
    - gathered
    - rendered
    - parsed
    default: merged

"""
EXAMPLES = """
# Using merged

# Before state:
# -------------
# vlan 1

- name: Merge provided configuration with device configuration.
  cisco.nxos.nxos_vlans:
    config:
    - vlan_id: 5
      name: test-vlan5
    - vlan_id: 10
      enabled: false
    state: merged

# After state:
# ------------
# vlan 5
#   name test-vlan5
#   state active
#   no shutdown
# vlan 10
#   state active
#   shutdown


# Using replaced

# Before state:
# -------------
# vlan 1
# vlan 5
#   name test-vlan5
# vlan 10
#   shutdown

- name: Replace device configuration of specified vlan with provided configuration.
  cisco.nxos.nxos_vlans:
    config:
    - vlan_id: 5
      name: test-vlan
      enabled: false
    - vlan_id: 10
      enabled: false
    state: replaced

# After state:
# ------------
# vlan 1
# vlan 5
#   name test-vlan
#   state active
#   shutdown
# vlan 10
#   state active
#   shutdown


# Using overridden

# Before state:
# -------------
# vlan 1
# vlan 3
#   name testing
# vlan 5
#   name test-vlan5
#   shutdown
# vlan 10
#   shutdown

- name: Override device configuration of all vlans with provided configuration.
  cisco.nxos.nxos_vlans:
    config:
    - vlan_id: 5
      name: test-vlan
    - vlan_id: 10
      state: active
    state: overridden

# After state:
# ------------
# vlan 5
#   name test-vlan
#   state active
#   no shutdown
# vlan 10
#   state active
#   no shutdown


# Using deleted

# Before state:
# -------------
# vlan 1
# vlan 5
# vlan 10

- name: Delete vlans.
  cisco.nxos.nxos_vlans:
    config:
    - vlan_id: 5
    - vlan_id: 10
    state: deleted

# After state:
# ------------
#

# Using rendered

- name: Use rendered state to convert task input to device specific commands
  cisco.nxos.nxos_vlans:
    config:
    - vlan_id: 5
      name: vlan5
      mapped_vni: 100

    - vlan_id: 6
      name: vlan6
      state: suspend
    state: rendered

# Task Output (redacted)
# -----------------------

# rendered:
#   - vlan 5
#   - name vlan5
#   - vn-segment 100
#   - vlan 6
#   - name vlan6
#   - state suspend

# Using parsed

# parsed.cfg
# ------------
# {
#     "TABLE_vlanbrief": {
#        "ROW_vlanbrief": [
#            {
#                "vlanshowbr-vlanid": "1",
#                "vlanshowbr-vlanid-utf": "1",
#                "vlanshowbr-vlanname": "default",
#                "vlanshowbr-vlanstate": "active",
#                "vlanshowbr-shutstate": "noshutdown"
#            },
#            {
#                "vlanshowbr-vlanid": "5",
#                "vlanshowbr-vlanid-utf": "5",
#                "vlanshowbr-vlanname": "vlan5",
#                "vlanshowbr-vlanstate": "suspend",
#                "vlanshowbr-shutstate": "noshutdown"
#            },
#            {
#                "vlanshowbr-vlanid": "6",
#                "vlanshowbr-vlanid-utf": "6",
#                "vlanshowbr-vlanname": "VLAN0006",
#                "vlanshowbr-vlanstate": "active",
#                "vlanshowbr-shutstate": "noshutdown"
#            },
#            {
#                "vlanshowbr-vlanid": "7",
#                "vlanshowbr-vlanid-utf": "7",
#                "vlanshowbr-vlanname": "vlan7",
#                "vlanshowbr-vlanstate": "active",
#                "vlanshowbr-shutstate": "noshutdown"
#            }
#        ]
#    },
#    "TABLE_mtuinfo": {
#        "ROW_mtuinfo": [
#            {
#                "vlanshowinfo-vlanid": "1",
#                "vlanshowinfo-media-type": "enet",
#                "vlanshowinfo-vlanmode": "ce-vlan"
#            },
#            {
#                "vlanshowinfo-vlanid": "5",
#                "vlanshowinfo-media-type": "enet",
#                "vlanshowinfo-vlanmode": "ce-vlan"
#            },
#            {
#                "vlanshowinfo-vlanid": "6",
#                "vlanshowinfo-media-type": "enet",
#                "vlanshowinfo-vlanmode": "ce-vlan"
#            },
#            {
#                "vlanshowinfo-vlanid": "7",
#                "vlanshowinfo-media-type": "enet",
#                "vlanshowinfo-vlanmode": "ce-vlan"
#             }
#        ]
#    }
# }
#
# vlan 1,5-7
# vlan 5
#   state suspend
#   name vlan5
# vlan 7
#   name vlan7
#   vn-segment 100

- name: Use parsed state to convert externally supplied config to structured format
  cisco.nxos.nxos_vlans:
    running_config: "{{ lookup('file', 'parsed.cfg') }}"
    state: parsed

# Task output (redacted)
# -----------------------

# parsed:
#   - vlan_id: 5
#     enabled: True
#     mode: "ce"
#     name: "vlan5"
#     state: suspend
#
#   - vlan_id: 6
#     enabled: True
#     mode: "ce"
#     state: active
#
#   - vlan_id: 7
#     enabled: True
#     mode: "ce"
#     name: "vlan7"
#     state: active
#     mapped_vni: 100

# Using gathered

# Existing device config state
# -------------------------------
# nxos-9k# show vlan | json
# {"TABLE_vlanbrief": {"ROW_vlanbrief": [{"vlanshowbr-vlanid": "1", "vlanshowbr-vlanid-utf": "1", "vlanshowbr-vlanname": "default", "vlanshowbr-vlanstate
# ": "active", "vlanshowbr-shutstate": "noshutdown"}, {"vlanshowbr-vlanid": "5", "vlanshowbr-vlanid-utf": "5", "vlanshowbr-vlanname": "vlan5", "vlanshowb
# r-vlanstate": "suspend", "vlanshowbr-shutstate": "noshutdown"}, {"vlanshowbr-vlanid": "6", "vlanshowbr-vlanid-utf": "6", "vlanshowbr-vlanname": "VLAN00
# 06", "vlanshowbr-vlanstate": "active", "vlanshowbr-shutstate": "noshutdown"}, {"vlanshowbr-vlanid": "7", "vlanshowbr-vlanid-utf": "7", "vlanshowbr-vlan
# name": "vlan7", "vlanshowbr-vlanstate": "active", "vlanshowbr-shutstate": "shutdown"}]}, "TABLE_mtuinfo": {"ROW_mtuinfo": [{"vlanshowinfo-vlanid": "1",
# "vlanshowinfo-media-type": "enet", "vlanshowinfo-vlanmode": "ce-vlan"}, {"vlanshowinfo-vlanid": "5", "vlanshowinfo-media-type": "enet", "vlanshowinfo-
# vlanmode": "ce-vlan"}, {"vlanshowinfo-vlanid": "6", "vlanshowinfo-media-type": "enet", "vlanshowinfo-vlanmode": "ce-vlan"}, {"vlanshowinfo-vlanid": "7"
# , "vlanshowinfo-media-type": "enet", "vlanshowinfo-vlanmode": "ce-vlan"}]}}
#
# nxos-9k#  show running-config | section ^vlan
# vlan 1,5-7
# vlan 5
#   state suspend
#   name vlan5
# vlan 7
#   shutdown
#   name vlan7
#   vn-segment 190

- name: Gather vlans facts from the device using nxos_vlans
  cisco.nxos.nxos_vlans:
    state: gathered

# Task output (redacted)
# -----------------------
# gathered:
#   - vlan_id: 5
#     enabled: True
#     mode: "ce"
#     name: "vlan5"
#     state: suspend
#
#   - vlan_id: 6
#     enabled: True
#     mode: "ce"
#     state: active
#
#   - vlan_id: 7
#     enabled: False
#     mode: "ce"
#     name: "vlan7"
#     state: active
#     mapped_vni: 190
"""
RETURN = """
before:
  description: The configuration as structured data prior to module invocation.
  returned: always
  type: list
  sample: >
    The configuration returned will always be in the same format
     of the parameters above.
after:
  description: The configuration as structured data after module completion.
  returned: when changed
  type: list
  sample: >
    The configuration returned will always be in the same format
     of the parameters above.
commands:
  description: The set of commands pushed to the remote device.
  returned: always
  type: list
  sample: ['vlan 5', 'name test-vlan5', 'state suspend']
"""


from ansible.module_utils.basic import AnsibleModule
from ansible_collections.cisco.nxos.plugins.module_utils.network.nxos.argspec.vlans.vlans import (
    VlansArgs,
)
from ansible_collections.cisco.nxos.plugins.module_utils.network.nxos.config.vlans.vlans import (
    Vlans,
)


def main():
    """
    Main entry point for module execution

    :returns: the result form module invocation
    """
    module = AnsibleModule(
        argument_spec=VlansArgs.argument_spec, supports_check_mode=True
    )

    result = Vlans(module).execute_module()
    module.exit_json(**result)


if __name__ == "__main__":
    main()
