/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.layouts;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;

public class FlowLayoutCorrectMinimumSize
extends FlowLayout {
    public FlowLayoutCorrectMinimumSize(int align) {
        this(align, 5, 5);
    }

    public FlowLayoutCorrectMinimumSize(int align, int hgap, int vgap) {
        super(align, hgap, vgap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            int hgap = this.getHgap();
            int vgap = this.getVgap();
            Insets insets = target.getInsets();
            int maxwidth = target.getWidth() - (insets.left + insets.right + hgap * 2);
            int nmembers = target.getComponentCount();
            boolean firstVisibleComponent = true;
            int rowWidth = 0;
            int maxRowWidth = 0;
            int height = 0;
            for (int i = 0; i < nmembers; ++i) {
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                Dimension d = m.getPreferredSize();
                if (firstVisibleComponent) {
                    height = d.height;
                    firstVisibleComponent = false;
                }
                if (rowWidth + hgap + d.width > maxwidth) {
                    maxRowWidth = Math.max(rowWidth, maxRowWidth);
                    height += vgap + d.height;
                    rowWidth = d.width;
                    continue;
                }
                rowWidth += hgap + d.width;
            }
            Dimension dim = new Dimension(maxRowWidth, height);
            dim.width += insets.left + insets.right + hgap * 2;
            dim.height += insets.top + insets.bottom + vgap * 2;
            return dim;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension minimumLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            int hgap = this.getHgap();
            int vgap = this.getVgap();
            Insets insets = target.getInsets();
            int maxwidth = target.getWidth() - (insets.left + insets.right + hgap * 2);
            int nmembers = target.getComponentCount();
            boolean firstVisibleComponent = true;
            int rowWidth = 0;
            int maxRowWidth = 0;
            int height = 0;
            for (int i = 0; i < nmembers; ++i) {
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                Dimension d = m.getMinimumSize();
                if (firstVisibleComponent) {
                    height = d.height;
                    firstVisibleComponent = false;
                }
                if (rowWidth + hgap + d.width > maxwidth) {
                    maxRowWidth = Math.max(rowWidth, maxRowWidth);
                    height += vgap + d.height;
                    rowWidth = d.width;
                    continue;
                }
                rowWidth += hgap + d.width;
            }
            Dimension dim = new Dimension(maxRowWidth, height);
            dim.width += insets.left + insets.right + hgap * 2;
            dim.height += insets.top + insets.bottom + vgap * 2;
            return dim;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            int hgap = this.getHgap();
            int vgap = this.getVgap();
            Insets insets = target.getInsets();
            int maxwidth = target.getWidth() - (insets.left + insets.right + hgap * 2);
            int nmembers = target.getComponentCount();
            int x = 0;
            int y = insets.top + vgap;
            int rowh = 0;
            int start = 0;
            boolean ltr = target.getComponentOrientation().isLeftToRight();
            for (int i = 0; i < nmembers; ++i) {
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                Dimension d = m.getPreferredSize();
                m.setSize(d.width, d.height);
                if (x == 0 || x + d.width <= maxwidth) {
                    if (x > 0) {
                        x += hgap;
                    }
                    x += d.width;
                    rowh = Math.max(rowh, d.height);
                    continue;
                }
                this.moveComponents(target, insets.left + hgap, y, maxwidth - x, rowh, start, i, ltr);
                x = d.width;
                y += vgap + rowh;
                rowh = d.height;
                start = i;
            }
            this.moveComponents(target, insets.left + hgap, y, maxwidth - x, rowh, start, nmembers, ltr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveComponents(Container target, int x, int y, int width, int height, int rowStart, int rowEnd, boolean ltr) {
        Object object = target.getTreeLock();
        synchronized (object) {
            int xMod = x;
            int hgap = this.getHgap();
            switch (this.getAlignment()) {
                case 0: {
                    xMod += ltr ? 0 : width;
                    break;
                }
                case 1: {
                    xMod += width / 2;
                    break;
                }
                case 2: {
                    xMod += ltr ? width : 0;
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    xMod += width;
                    break;
                }
            }
            for (int i = rowStart; i < rowEnd; ++i) {
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                if (ltr) {
                    m.setLocation(xMod, y + (height - m.getHeight()) / 2);
                } else {
                    m.setLocation(target.getWidth() - xMod - m.getWidth(), y + (height - m.getHeight()) / 2);
                }
                xMod += m.getWidth() + hgap;
            }
        }
    }
}

