/*
 * Decompiled with CFR 0.152.
 */
package gps.tracks;

import bt747.sys.Generic;
import bt747.sys.JavaLibBridge;
import bt747.sys.interfaces.BT747Hashtable;
import bt747.sys.interfaces.BT747Vector;
import gps.tracks.Track;
import gps.tracks.Trackpoint;

public final class PolylineEncoder {
    private final float[] zoomLevelBreaks = new float[18];

    public PolylineEncoder() {
        for (int i = 0; i < 18; ++i) {
            this.zoomLevelBreaks[i] = (float)((double)1.0E-5f * Generic.pow(2.0, 18 - i - 1));
        }
    }

    public final BT747Hashtable dpEncode(Track object) {
        Object object2;
        Object object3;
        int n;
        int n2;
        int n3;
        BT747Vector bT747Vector = JavaLibBridge.getVectorInstance();
        float[] fArray = new float[((Track)object).getTrackpoints().size()];
        BT747Vector bT747Vector2 = ((Track)object).getTrackpoints();
        if (bT747Vector2.size() > 2) {
            int[] nArray = new int[]{0, bT747Vector2.size() - 1};
            bT747Vector.mypush(nArray);
            while (bT747Vector.size() > 0) {
                nArray = (int[])bT747Vector.pop();
                n3 = nArray[0];
                int n4 = nArray[1];
                float f = 0.0f;
                n2 = 0;
                for (n = n3 + 1; n < n4; ++n) {
                    float f2;
                    double d;
                    object3 = (Trackpoint)((Track)object).getTrackpoints().elementAt(n4);
                    object2 = (Trackpoint)bT747Vector2.elementAt(n3);
                    Trackpoint trackpoint = (Trackpoint)bT747Vector2.elementAt(n);
                    if (((Trackpoint)object2).getLatDouble() == ((Trackpoint)object3).getLatDouble() && ((Trackpoint)object2).getLonDouble() == ((Trackpoint)object3).getLonDouble()) {
                        d = Math.sqrt(Generic.pow(((Trackpoint)object3).getLatDouble() - trackpoint.getLatDouble(), 2.0) + Generic.pow(((Trackpoint)object3).getLonDouble() - trackpoint.getLonDouble(), 2.0));
                    } else {
                        double d2;
                        double d3 = ((trackpoint.getLatDouble() - ((Trackpoint)object2).getLatDouble()) * (((Trackpoint)object3).getLatDouble() - ((Trackpoint)object2).getLatDouble()) + (trackpoint.getLonDouble() - ((Trackpoint)object2).getLonDouble()) * (((Trackpoint)object3).getLonDouble() - ((Trackpoint)object2).getLonDouble())) / (Generic.pow(((Trackpoint)object3).getLatDouble() - ((Trackpoint)object2).getLatDouble(), 2.0) + Generic.pow(((Trackpoint)object3).getLonDouble() - ((Trackpoint)object2).getLonDouble(), 2.0));
                        d = d2 <= 0.0 ? Math.sqrt(Generic.pow(trackpoint.getLatDouble() - ((Trackpoint)object2).getLatDouble(), 2.0) + Generic.pow(trackpoint.getLonDouble() - ((Trackpoint)object2).getLonDouble(), 2.0)) : (d3 < 1.0 ? Math.sqrt(Generic.pow(trackpoint.getLatDouble() - ((Trackpoint)object2).getLatDouble() - d3 * (((Trackpoint)object3).getLatDouble() - ((Trackpoint)object2).getLatDouble()), 2.0) + Generic.pow(trackpoint.getLonDouble() - ((Trackpoint)object2).getLonDouble() - d3 * (((Trackpoint)object3).getLonDouble() - ((Trackpoint)object2).getLonDouble()), 2.0)) : Math.sqrt(Generic.pow(trackpoint.getLatDouble() - ((Trackpoint)object3).getLatDouble(), 2.0) + Generic.pow(trackpoint.getLonDouble() - ((Trackpoint)object3).getLonDouble(), 2.0)));
                    }
                    float f3 = (float)d;
                    if (!(f2 > f)) continue;
                    f = f3;
                    n2 = n;
                }
                if (!(f > 1.0E-5f)) continue;
                fArray[n2] = f;
                int[] nArray2 = new int[]{n3, n2};
                bT747Vector.mypush(nArray2);
                int[] nArray3 = new int[]{n2, n4};
                bT747Vector.mypush(nArray3);
            }
        }
        object3 = fArray;
        object2 = object;
        StringBuffer stringBuffer = new StringBuffer();
        double d = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        int n5 = 0;
        int n6 = 0;
        for (int i = 0; i < ((Track)object2).size(); ++i) {
            if (i == 0) {
                d = d4 = ((Track)object2).get(i).getLatDouble();
                d5 = d6 = ((Track)object2).get(i).getLonDouble();
            } else if (((Track)object2).get(i).getLatDouble() > d) {
                d = ((Track)object2).get(i).getLatDouble();
            } else if (((Track)object2).get(i).getLatDouble() < d4) {
                d4 = ((Track)object2).get(i).getLatDouble();
            } else if (((Track)object2).get(i).getLonDouble() > d5) {
                d5 = ((Track)object2).get(i).getLonDouble();
            } else if (((Track)object2).get(i).getLonDouble() < d6) {
                d6 = ((Track)object2).get(i).getLonDouble();
            }
            if (object3[i] == 0.0f && i != 0 && i != ((Track)object2).size() - 1) continue;
            Trackpoint trackpoint = ((Track)object2).get(i);
            int n7 = PolylineEncoder.floor1e5(trackpoint.getLatDouble());
            n3 = PolylineEncoder.floor1e5(trackpoint.getLonDouble());
            n2 = n7 - n5;
            n = n3 - n6;
            n5 = n7;
            n6 = n3;
            stringBuffer.append(PolylineEncoder.encodeSignedNumber(n2));
            stringBuffer.append(PolylineEncoder.encodeSignedNumber(n));
        }
        BT747Hashtable bT747Hashtable = JavaLibBridge.getHashtableInstance(0);
        bT747Hashtable.put("maxlat", JavaLibBridge.toString(d));
        bT747Hashtable.put("minlat", JavaLibBridge.toString(d4));
        bT747Hashtable.put("maxlon", JavaLibBridge.toString(d5));
        bT747Hashtable.put("minlon", JavaLibBridge.toString(d6));
        String string = PolylineEncoder.replace(stringBuffer.toString(), "\\", "\\\\");
        object = this.encodeLevels$1755a73a((Track)object, fArray);
        bT747Hashtable = JavaLibBridge.getHashtableInstance(0);
        bT747Hashtable.put("encodedPoints", string);
        bT747Hashtable.put("encodedLevels", object);
        return bT747Hashtable;
    }

    public static final String replace(String string, String string2, String string3) {
        if (string.equals("")) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.indexOf(string2, 0);
        int n2 = 0;
        while (n != -1) {
            stringBuffer.append(string.substring(n2, n));
            stringBuffer.append(string3);
            n2 = n + string2.length();
            n = string.indexOf(string2, n2);
        }
        stringBuffer.append(string.substring(n2));
        return stringBuffer.toString();
    }

    private static final int floor1e5(double d) {
        return (int)Math.floor(d * 100000.0);
    }

    private static final String encodeSignedNumber(int n) {
        int n2 = n << 1;
        if (n < 0) {
            n2 ^= 0xFFFFFFFF;
        }
        return PolylineEncoder.encodeNumber(n2);
    }

    private static final String encodeNumber(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        while (n >= 32) {
            int n2 = (0x20 | n & 0x1F) + 63;
            stringBuffer.append((char)n2);
            n >>= 5;
        }
        stringBuffer.append((char)(n += 63));
        return stringBuffer.toString();
    }

    private final String encodeLevels$1755a73a(Track track, float[] fArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(PolylineEncoder.encodeNumber(17));
        for (int i = 1; i < track.size() - 1; ++i) {
            if (fArray[i] == 0.0f) continue;
            stringBuffer.append(PolylineEncoder.encodeNumber(18 - this.computeLevel(fArray[i]) - 1));
        }
        if (track.size() > 1) {
            stringBuffer.append(PolylineEncoder.encodeNumber(17));
        }
        return stringBuffer.toString();
    }

    private int computeLevel(float f) {
        int n = 0;
        if (f > 1.0E-5f) {
            n = 0;
            while (f < this.zoomLevelBreaks[n]) {
                ++n;
            }
        }
        return n;
    }
}

