/*
 * Decompiled with CFR 0.152.
 */
package net.sf.bt747.gps.mtk.agps;

import bt747.model.EventPoster;
import bt747.model.ModelEvent;
import bt747.sys.ByteDataStream;
import bt747.sys.Generic;
import bt747.sys.I18N;
import bt747.sys.interfaces.BT747Exception;
import bt747.sys.interfaces.BT747InputStream;
import bt747.sys.interfaces.BT747Int;
import gps.connection.MtkBinWriter;
import gps.mvc.DeviceOperationHandlerIF;
import gps.mvc.GpsLinkHandler;
import net.sf.bt747.gps.mtk.MtkBinTransportMessageModel;

public class AgpsUploadHandler
implements DeviceOperationHandlerIF {
    private BT747InputStream agpsDataStream;
    private int nxtPacketIdx;
    private int nextPacketPercentOffset;
    private int percentBytes = 1075;
    private final EventPoster poster;
    private boolean sendNextOK;
    private int timesOutAt;
    private MtkBinTransportMessageModel cmd;
    private int errorCnt;
    private int percent;

    public AgpsUploadHandler(EventPoster eventPoster) {
        this.poster = eventPoster;
    }

    public AgpsUploadHandler() {
        this(null);
    }

    @Override
    public final boolean analyseResponse(Object object) {
        if (object instanceof MtkBinTransportMessageModel) {
            object = (MtkBinTransportMessageModel)object;
            Generic.debug("<<" + ((MtkBinTransportMessageModel)object).toString());
            if (this.nxtPacketIdx == 0) {
                this.sendNextOK = true;
            } else {
                switch (((MtkBinTransportMessageModel)object).getType()) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        this.errorCnt = 0;
                        byte[] byArray = ((MtkBinTransportMessageModel)object).getPayLoad();
                        object = byArray;
                        int n = (byArray[0] & 0xFF) + ((object[1] & 0xFF) << 8);
                        if (object[2] != true) {
                            this.errorCnt = 3;
                            Generic.debug("Error packet from device during AGPS upload.");
                        }
                        if (n < this.nxtPacketIdx - 1) break;
                        this.sendNextOK = true;
                    }
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public final boolean notifyRun(GpsLinkHandler object) throws BT747Exception {
        if (this.nxtPacketIdx < 0) {
            this.stopUploadMode((GpsLinkHandler)object);
            return false;
        }
        if (this.timesOutAt == 0) {
            this.resetTimeOut();
        } else if (this.cmd != null && Generic.getTimeStamp() > this.timesOutAt) {
            ++this.errorCnt;
            if (this.cmd != null && this.errorCnt < 3) {
                MtkBinWriter.sendCmd((GpsLinkHandler)object, this.cmd);
                this.resetTimeOut();
                return true;
            }
        }
        if (this.errorCnt >= 3) {
            this.stopUploadMode((GpsLinkHandler)object);
            throw new BT747Exception(I18N.i18n("Too many errors during AGPS upload"));
        }
        if (this.sendNextOK) {
            this.sendNextOK = false;
            AgpsUploadHandler agpsUploadHandler = this;
            byte[] byArray = new byte[182];
            if (agpsUploadHandler.agpsDataStream.readBytes(byArray, 2, 180) > 0) {
                byArray[0] = (byte)agpsUploadHandler.nxtPacketIdx;
                byArray[1] = (byte)(agpsUploadHandler.nxtPacketIdx >> 8);
                ++agpsUploadHandler.nxtPacketIdx;
            } else {
                byArray[0] = -1;
                byArray[1] = -1;
                agpsUploadHandler.nxtPacketIdx = -1;
            }
            this.cmd = new MtkBinTransportMessageModel(722, byArray);
            MtkBinWriter.sendCmd((GpsLinkHandler)object, this.cmd);
            if (this.nxtPacketIdx * 180 > this.nextPacketPercentOffset) {
                ++this.percent;
                this.nextPacketPercentOffset += this.percentBytes;
                int n = this.percent;
                agpsUploadHandler = this;
                if (agpsUploadHandler.poster != null) {
                    object = new ModelEvent(273, BT747Int.get(n));
                    agpsUploadHandler.poster.postEvent((ModelEvent)object);
                }
            }
            if (Generic.isDebug()) {
                Generic.debug("Sent AGPS data:" + this.cmd.toString());
            }
            this.resetTimeOut();
        }
        return true;
    }

    public final void setAgpsData(byte[] object) {
        this.percentBytes = ((byte[])object).length / 100;
        ByteDataStream byteDataStream = new ByteDataStream((byte[])object);
        object = this;
        this.agpsDataStream = byteDataStream;
        object.nxtPacketIdx = 0;
        object.sendNextOK = false;
        object.timesOutAt = 0;
        object.errorCnt = 0;
        object.percent = 0;
        object.nextPacketPercentOffset = object.percentBytes;
        object.cmd = null;
    }

    private final void resetTimeOut() {
        this.timesOutAt = Generic.getTimeStamp() + 6000;
    }

    private final void stopUploadMode(GpsLinkHandler object) {
        MtkBinWriter.doSetNmeaMode(((GpsLinkHandler)object).getGPSRxtx());
        Generic.debug("AGPS upload stopped/finished");
        object = this;
        if (((AgpsUploadHandler)object).poster != null) {
            ModelEvent modelEvent = new ModelEvent(272, null);
            ((AgpsUploadHandler)object).poster.postEvent(modelEvent);
        }
    }
}

