/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.OptionalChainRewriter;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.jscomp.UniqueIdSupplier;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.function.Function;

final class RewriteOptionalChainingOperator
implements HotSwapCompilerPass {
    private static final FeatureSet TRANSPILED_FEATURES = FeatureSet.BARE_MINIMUM.with(FeatureSet.Feature.OPTIONAL_CHAINING);
    private final AbstractCompiler compiler;
    private final Function<CompilerInput, OptionalChainRewriter.TmpVarNameCreator> getTmpVarNameCreatorForInput;

    RewriteOptionalChainingOperator(AbstractCompiler compiler) {
        this.compiler = compiler;
        UniqueIdSupplier uniqueIdSupplier = compiler.getUniqueIdSupplier();
        this.getTmpVarNameCreatorForInput = input -> () -> "$jscomp$optchain$tmp" + uniqueIdSupplier.getUniqueId((CompilerInput)input);
    }

    RewriteOptionalChainingOperator(AbstractCompiler compiler, OptionalChainRewriter.TmpVarNameCreator tmpVarNameCreator) {
        this.compiler = compiler;
        this.getTmpVarNameCreatorForInput = input -> tmpVarNameCreator;
    }

    @Override
    public void process(Node externs, Node root) {
        TranspilationPasses.processTranspile(this.compiler, externs, TRANSPILED_FEATURES, new TranspilationCallback());
        TranspilationPasses.processTranspile(this.compiler, root, TRANSPILED_FEATURES, new TranspilationCallback());
        TranspilationPasses.maybeMarkFeaturesAsTranspiledAway(this.compiler, TRANSPILED_FEATURES);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        TranspilationPasses.hotSwapTranspile(this.compiler, scriptRoot, TRANSPILED_FEATURES, new TranspilationCallback());
        TranspilationPasses.maybeMarkFeaturesAsTranspiledAway(this.compiler, TRANSPILED_FEATURES);
    }

    private class TranspilationCallback
    implements NodeTraversal.Callback {
        private final OptionalChainRewriter.Builder rewriterBuilder;
        private final ArrayList<OptionalChainRewriter> optionalChains;

        private TranspilationCallback() {
            this.rewriterBuilder = OptionalChainRewriter.builder(RewriteOptionalChainingOperator.this.compiler);
            this.optionalChains = new ArrayList();
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            if (n.isScript()) {
                this.rewriterBuilder.setTmpVarNameCreator((OptionalChainRewriter.TmpVarNameCreator)RewriteOptionalChainingOperator.this.getTmpVarNameCreatorForInput.apply(t.getInput()));
            }
            return true;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (NodeUtil.isEndOfFullOptChain(n)) {
                this.optionalChains.add(this.rewriterBuilder.build(n));
            } else if (n.isScript() && !this.optionalChains.isEmpty()) {
                for (OptionalChainRewriter optionalChain : this.optionalChains) {
                    optionalChain.rewrite();
                }
                this.optionalChains.clear();
            }
        }
    }
}

