/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api.painter;

import org.pushingpixels.substance.api.ColorSchemeSingleColorQuery;
import org.pushingpixels.substance.api.trait.SubstanceTrait;

public abstract class FractionBasedPainter
implements SubstanceTrait {
    private String displayName;
    protected float[] fractions;
    protected ColorSchemeSingleColorQuery[] colorQueries;

    public FractionBasedPainter(String displayName, float[] fractions, ColorSchemeSingleColorQuery[] colorQueries) {
        int i;
        this.displayName = displayName;
        if (fractions == null || colorQueries == null) {
            throw new IllegalArgumentException("Cannot pass null arguments");
        }
        if (fractions.length != colorQueries.length) {
            throw new IllegalArgumentException("Argument length does not match");
        }
        int length = fractions.length;
        if (fractions[0] != 0.0f || fractions[length - 1] != 1.0f) {
            throw new IllegalArgumentException("End fractions must be 0.0 and 1.0");
        }
        for (i = 0; i < length - 1; ++i) {
            if (!(fractions[i + 1] <= fractions[i])) continue;
            throw new IllegalArgumentException("Fractions must be strictly increasing");
        }
        for (i = 0; i < length; ++i) {
            if (colorQueries[i] != null) continue;
            throw new IllegalArgumentException("Cannot pass null query");
        }
        this.colorQueries = new ColorSchemeSingleColorQuery[length];
        System.arraycopy(colorQueries, 0, this.colorQueries, 0, length);
        this.fractions = new float[length];
        System.arraycopy(fractions, 0, this.fractions, 0, length);
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    public float[] getFractions() {
        float[] result = new float[this.fractions.length];
        System.arraycopy(this.fractions, 0, result, 0, this.fractions.length);
        return result;
    }

    public ColorSchemeSingleColorQuery[] getColorQueries() {
        ColorSchemeSingleColorQuery[] result = new ColorSchemeSingleColorQuery[this.colorQueries.length];
        System.arraycopy(this.colorQueries, 0, result, 0, this.colorQueries.length);
        return result;
    }
}

