/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow.table;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.fop.fo.flow.table.BorderResolver;
import org.apache.fop.fo.flow.table.BorderSpecification;
import org.apache.fop.fo.flow.table.ConditionalBorder;
import org.apache.fop.fo.flow.table.GridUnit;
import org.apache.fop.fo.flow.table.Table;
import org.apache.fop.fo.flow.table.TableCellContainer;
import org.apache.fop.fo.flow.table.TableColumn;
import org.apache.fop.fo.flow.table.TableFooter;
import org.apache.fop.fo.flow.table.TableHeader;
import org.apache.fop.fo.flow.table.TablePart;
import org.apache.fop.fo.flow.table.TableRow;
import org.apache.fop.layoutmgr.table.CollapsingBorderModel;

class CollapsingBorderResolver
implements BorderResolver {
    private Table table;
    private CollapsingBorderModel collapsingBorderModel;
    private List<GridUnit> previousRow;
    private boolean firstInTable;
    private List<GridUnit> footerFirstRow;
    private List<GridUnit> footerLastRow;
    private Resolver delegate;
    private Resolver resolverInBody = new ResolverInBody();
    private Resolver resolverInFooter;
    private List<ConditionalBorder> leadingBorders;
    private List<ConditionalBorder> trailingBorders;
    private List<GridUnit> headerLastRow;

    CollapsingBorderResolver(Table table) {
        TableColumn col;
        this.table = table;
        this.collapsingBorderModel = CollapsingBorderModel.getBorderModelFor(table.getBorderCollapse());
        this.firstInTable = true;
        int index = 0;
        do {
            col = table.getColumn(index);
            col.borderBefore.integrateSegment(table.borderBefore, true, false, true);
            col.borderBefore.leadingTrailing = col.borderBefore.rest;
            col.borderAfter.integrateSegment(table.borderAfter, true, false, true);
            col.borderAfter.leadingTrailing = col.borderAfter.rest;
        } while ((index += col.getNumberColumnsRepeated()) < table.getNumberOfColumns());
    }

    @Override
    public void endRow(List<GridUnit> row, TableCellContainer container) {
        this.delegate.endRow(row, container);
    }

    @Override
    public void startPart(TablePart part) {
        if (part instanceof TableHeader) {
            this.delegate = new ResolverInHeader();
        } else {
            ConditionalBorder border;
            if (this.leadingBorders == null || this.table.omitHeaderAtBreak()) {
                this.leadingBorders = new ArrayList<ConditionalBorder>(this.table.getNumberOfColumns());
                for (Object o : this.table.getColumns()) {
                    border = ((TableColumn)o).borderBefore;
                    this.leadingBorders.add(border);
                }
            }
            if (part instanceof TableFooter) {
                this.delegate = this.resolverInFooter = new ResolverInFooter();
            } else {
                if (this.trailingBorders == null || this.table.omitFooterAtBreak()) {
                    this.trailingBorders = new ArrayList<ConditionalBorder>(this.table.getNumberOfColumns());
                    for (Object o : this.table.getColumns()) {
                        border = ((TableColumn)o).borderAfter;
                        this.trailingBorders.add(border);
                    }
                }
                this.delegate = this.resolverInBody;
            }
        }
        this.delegate.startPart(part);
    }

    @Override
    public void endPart() {
        this.delegate.endPart();
    }

    @Override
    public void endTable() {
        GridUnit gu;
        Iterator<GridUnit> iterator;
        this.delegate.endTable();
        this.delegate = null;
        if (this.headerLastRow != null) {
            iterator = this.headerLastRow.iterator();
            while (iterator.hasNext()) {
                GridUnit aHeaderLastRow;
                gu = aHeaderLastRow = iterator.next();
                gu.borderAfter.leadingTrailing = gu.borderAfter.normal;
            }
        }
        if (this.footerLastRow != null) {
            iterator = this.footerLastRow.iterator();
            while (iterator.hasNext()) {
                GridUnit aFooterLastRow;
                gu = aFooterLastRow = iterator.next();
                gu.borderAfter.leadingTrailing = gu.borderAfter.normal;
            }
        }
    }

    private abstract class Resolver {
        protected TablePart tablePart;
        protected boolean firstInPart;
        private BorderSpecification borderStartTableAndBody;
        private BorderSpecification borderEndTableAndBody;

        private Resolver() {
        }

        void resolveBordersFirstRowInTable(List<GridUnit> row, boolean withNormal, boolean withLeadingTrailing, boolean withRest) {
            assert (CollapsingBorderResolver.this.firstInTable);
            for (int i = 0; i < row.size(); ++i) {
                TableColumn column = CollapsingBorderResolver.this.table.getColumn(i);
                row.get(i).integrateBorderSegment(0, column, withNormal, withLeadingTrailing, withRest);
            }
            CollapsingBorderResolver.this.firstInTable = false;
        }

        void resolveBordersBetweenRows(List<GridUnit> rowBefore, List<GridUnit> rowAfter) {
            assert (rowBefore != null && rowAfter != null);
            for (int i = 0; i < rowAfter.size(); ++i) {
                GridUnit gu = rowAfter.get(i);
                if (gu.getRowSpanIndex() != 0) continue;
                GridUnit beforeGU = rowBefore.get(i);
                gu.resolveBorder(beforeGU, 0);
            }
        }

        void resolveBordersLastRowInPart(List<GridUnit> row, boolean withNormal, boolean withLeadingTrailing, boolean withRest) {
            for (GridUnit aRow : row) {
                aRow.integrateBorderSegment(1, this.tablePart, withNormal, withLeadingTrailing, withRest);
            }
        }

        void resolveBordersLastRowInTable(List<GridUnit> row, boolean withNormal, boolean withLeadingTrailing, boolean withRest) {
            for (int i = 0; i < row.size(); ++i) {
                TableColumn column = CollapsingBorderResolver.this.table.getColumn(i);
                row.get(i).integrateBorderSegment(1, column, withNormal, withLeadingTrailing, withRest);
            }
        }

        void integrateLeadingBorders(List<GridUnit> row) {
            for (int i = 0; i < CollapsingBorderResolver.this.table.getNumberOfColumns(); ++i) {
                GridUnit gu = row.get(i);
                ConditionalBorder border = (ConditionalBorder)CollapsingBorderResolver.this.leadingBorders.get(i);
                gu.integrateCompetingBorder(0, border, false, true, true);
            }
        }

        void integrateTrailingBorders(List<GridUnit> row) {
            for (int i = 0; i < CollapsingBorderResolver.this.table.getNumberOfColumns(); ++i) {
                GridUnit gu = row.get(i);
                ConditionalBorder border = (ConditionalBorder)CollapsingBorderResolver.this.trailingBorders.get(i);
                gu.integrateCompetingBorder(1, border, false, true, true);
            }
        }

        void startPart(TablePart part) {
            this.tablePart = part;
            this.firstInPart = true;
            this.borderStartTableAndBody = CollapsingBorderResolver.this.collapsingBorderModel.determineWinner(((CollapsingBorderResolver)CollapsingBorderResolver.this).table.borderStart, this.tablePart.borderStart);
            this.borderEndTableAndBody = CollapsingBorderResolver.this.collapsingBorderModel.determineWinner(((CollapsingBorderResolver)CollapsingBorderResolver.this).table.borderEnd, this.tablePart.borderEnd);
        }

        /*
         * WARNING - void declaration
         */
        void endRow(List<GridUnit> row, TableCellContainer container) {
            void var6_10;
            BorderSpecification borderStart = this.borderStartTableAndBody;
            BorderSpecification borderEnd = this.borderEndTableAndBody;
            if (container instanceof TableRow) {
                TableRow tableRow = (TableRow)container;
                for (GridUnit aRow : row) {
                    GridUnit gu = aRow;
                    boolean first = gu.getRowSpanIndex() == 0;
                    boolean last = gu.isLastGridUnitRowSpan();
                    gu.integrateBorderSegment(0, tableRow, first, first, true);
                    gu.integrateBorderSegment(1, tableRow, last, last, true);
                }
                borderStart = CollapsingBorderResolver.this.collapsingBorderModel.determineWinner(borderStart, tableRow.borderStart);
                borderEnd = CollapsingBorderResolver.this.collapsingBorderModel.determineWinner(borderEnd, tableRow.borderEnd);
            }
            if (this.firstInPart) {
                for (Object e : row) {
                    ((GridUnit)e).integrateBorderSegment(0, this.tablePart, true, true, true);
                }
                this.firstInPart = false;
            }
            Iterator<GridUnit> guIter = row.iterator();
            GridUnit gridUnit = guIter.next();
            Iterator colIter = CollapsingBorderResolver.this.table.getColumns().iterator();
            TableColumn col = (TableColumn)colIter.next();
            gridUnit.integrateBorderSegment(2, col);
            gridUnit.integrateBorderSegment(2, borderStart);
            while (guIter.hasNext()) {
                GridUnit nextGU = guIter.next();
                TableColumn nextCol = (TableColumn)colIter.next();
                if (var6_10.isLastGridUnitColSpan()) {
                    var6_10.integrateBorderSegment(3, col);
                    nextGU.integrateBorderSegment(2, nextCol);
                    var6_10.resolveBorder(nextGU, 3);
                }
                GridUnit gridUnit2 = nextGU;
                col = nextCol;
            }
            var6_10.integrateBorderSegment(3, col);
            var6_10.integrateBorderSegment(3, borderEnd);
        }

        void endPart() {
            this.resolveBordersLastRowInPart(CollapsingBorderResolver.this.previousRow, true, true, true);
        }

        abstract void endTable();
    }

    private class ResolverInBody
    extends Resolver {
        private boolean firstInBody = true;

        private ResolverInBody() {
        }

        @Override
        void endRow(List<GridUnit> row, TableCellContainer container) {
            super.endRow(row, container);
            if (CollapsingBorderResolver.this.firstInTable) {
                this.resolveBordersFirstRowInTable(row, true, true, true);
            } else {
                this.resolveBordersBetweenRows(CollapsingBorderResolver.this.previousRow, row);
                this.integrateLeadingBorders(row);
            }
            this.integrateTrailingBorders(row);
            CollapsingBorderResolver.this.previousRow = row;
            if (this.firstInBody) {
                this.firstInBody = false;
                Iterator<GridUnit> iterator = row.iterator();
                while (iterator.hasNext()) {
                    GridUnit aRow;
                    GridUnit gu = aRow = iterator.next();
                    gu.borderBefore.leadingTrailing = gu.borderBefore.normal;
                }
            }
        }

        @Override
        void endTable() {
            if (CollapsingBorderResolver.this.resolverInFooter != null) {
                CollapsingBorderResolver.this.resolverInFooter.endTable();
            } else {
                this.resolveBordersLastRowInTable(CollapsingBorderResolver.this.previousRow, true, false, false);
            }
            for (Object aPreviousRow : CollapsingBorderResolver.this.previousRow) {
                GridUnit gu = (GridUnit)aPreviousRow;
                gu.borderAfter.leadingTrailing = gu.borderAfter.normal;
            }
        }
    }

    private class ResolverInHeader
    extends Resolver {
        private ResolverInHeader() {
        }

        @Override
        void endRow(List<GridUnit> row, TableCellContainer container) {
            super.endRow(row, container);
            if (CollapsingBorderResolver.this.previousRow != null) {
                this.resolveBordersBetweenRows(CollapsingBorderResolver.this.previousRow, row);
            } else {
                for (GridUnit aRow : row) {
                    ConditionalBorder borderBefore = aRow.borderBefore;
                    borderBefore.leadingTrailing = borderBefore.normal;
                    borderBefore.rest = borderBefore.normal;
                }
                this.resolveBordersFirstRowInTable(row, true, false, true);
            }
            CollapsingBorderResolver.this.previousRow = row;
        }

        @Override
        void endPart() {
            super.endPart();
            CollapsingBorderResolver.this.leadingBorders = new ArrayList(CollapsingBorderResolver.this.table.getNumberOfColumns());
            for (Object aPreviousRow : CollapsingBorderResolver.this.previousRow) {
                ConditionalBorder borderAfter = ((GridUnit)aPreviousRow).borderAfter;
                borderAfter.leadingTrailing = borderAfter.normal;
                borderAfter.rest = borderAfter.normal;
                CollapsingBorderResolver.this.leadingBorders.add(borderAfter);
            }
            CollapsingBorderResolver.this.headerLastRow = CollapsingBorderResolver.this.previousRow;
        }

        @Override
        void endTable() {
            throw new IllegalStateException();
        }
    }

    private class ResolverInFooter
    extends Resolver {
        private ResolverInFooter() {
        }

        @Override
        void endRow(List<GridUnit> row, TableCellContainer container) {
            super.endRow(row, container);
            if (CollapsingBorderResolver.this.footerFirstRow == null) {
                CollapsingBorderResolver.this.footerFirstRow = row;
            } else {
                this.resolveBordersBetweenRows(CollapsingBorderResolver.this.footerLastRow, row);
            }
            CollapsingBorderResolver.this.footerLastRow = row;
        }

        @Override
        void endPart() {
            this.resolveBordersLastRowInPart(CollapsingBorderResolver.this.footerLastRow, true, true, true);
            CollapsingBorderResolver.this.trailingBorders = new ArrayList(CollapsingBorderResolver.this.table.getNumberOfColumns());
            for (Object aFooterFirstRow : CollapsingBorderResolver.this.footerFirstRow) {
                ConditionalBorder borderBefore = ((GridUnit)aFooterFirstRow).borderBefore;
                borderBefore.leadingTrailing = borderBefore.normal;
                borderBefore.rest = borderBefore.normal;
                CollapsingBorderResolver.this.trailingBorders.add(borderBefore);
            }
        }

        @Override
        void endTable() {
            this.resolveBordersBetweenRows(CollapsingBorderResolver.this.previousRow, CollapsingBorderResolver.this.footerFirstRow);
            for (Object aFooterLastRow : CollapsingBorderResolver.this.footerLastRow) {
                ConditionalBorder borderAfter = ((GridUnit)aFooterLastRow).borderAfter;
                borderAfter.leadingTrailing = borderAfter.normal;
                borderAfter.rest = borderAfter.normal;
            }
            this.resolveBordersLastRowInTable(CollapsingBorderResolver.this.footerLastRow, true, false, true);
        }
    }
}

