/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.logging.Logger;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.panel.DefaultTransferHandler;
import net.sf.freecol.client.gui.panel.DragListener;
import net.sf.freecol.client.gui.panel.DropTarget;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.GoodsLabel;
import net.sf.freecol.client.gui.panel.MarketLabel;
import net.sf.freecol.client.gui.panel.UnitLabel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Unit;

public class CargoPanel
extends FreeColPanel
implements DropTarget,
PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(CargoPanel.class.getName());
    private Unit carrier = null;
    private DefaultTransferHandler defaultTransferHandler = new DefaultTransferHandler(this.getFreeColClient(), this);

    public CargoPanel(FreeColClient freeColClient, boolean withTitle) {
        super(freeColClient, new MigLayout("wrap 6, fill, insets 0"));
        if (withTitle) {
            this.setBorder(Utility.localizedBorder("cargoOnCarrier"));
        }
    }

    public void initialize() {
        this.addPropertyChangeListeners();
        this.update();
    }

    public void cleanup() {
        this.removePropertyChangeListeners();
    }

    protected void addPropertyChangeListeners() {
        if (this.carrier != null) {
            this.carrier.addPropertyChangeListener("CARGO_CHANGE", this);
            this.carrier.getGoodsContainer().addPropertyChangeListener(this);
        }
    }

    protected void removePropertyChangeListeners() {
        if (this.carrier != null) {
            this.carrier.removePropertyChangeListener("CARGO_CHANGE", this);
            this.carrier.getGoodsContainer().removePropertyChangeListener(this);
        }
    }

    public void update() {
        this.removeAll();
        if (this.carrier != null) {
            DragListener dl = new DragListener(this.getFreeColClient(), this);
            Iterator<Unit> unitIterator = this.carrier.getUnitIterator();
            while (unitIterator.hasNext()) {
                Unit unit = unitIterator.next();
                UnitLabel label = new UnitLabel(this.getFreeColClient(), unit);
                if (this.isEditable()) {
                    label.setTransferHandler(this.defaultTransferHandler);
                    label.addMouseListener(dl);
                }
                this.add(label);
            }
            Iterator<Goods> goodsIterator = this.carrier.getGoodsIterator();
            while (goodsIterator.hasNext()) {
                Goods g = goodsIterator.next();
                GoodsLabel label = new GoodsLabel(this.getGUI(), g);
                if (this.isEditable()) {
                    label.setTransferHandler(this.defaultTransferHandler);
                    label.addMouseListener(dl);
                }
                this.add(label);
            }
        }
        this.updateTitle();
        this.revalidate();
        this.repaint();
    }

    public boolean isActive() {
        return this.carrier != null;
    }

    public Unit getCarrier() {
        return this.carrier;
    }

    public void setCarrier(Unit newCarrier) {
        if (newCarrier != this.carrier) {
            this.cleanup();
            this.carrier = newCarrier;
            this.initialize();
        }
    }

    private void updateTitle() {
        Utility.localizeBorder(this, this.carrier == null ? StringTemplate.key("cargoOnCarrier") : StringTemplate.template("cargoPanel.cargoAndSpace").addStringTemplate("%name%", this.carrier.getLabel(Unit.UnitLabelType.NATIONAL)).addAmount("%space%", this.carrier.getSpaceLeft()));
    }

    @Override
    public boolean accepts(Unit unit) {
        return true;
    }

    @Override
    public boolean accepts(Goods goods) {
        return true;
    }

    @Override
    public Component add(Component comp, boolean editState) {
        if (this.carrier == null) {
            return null;
        }
        if (editState) {
            Unit unit;
            if (comp instanceof GoodsLabel) {
                Goods goods = ((GoodsLabel)comp).getGoods();
                int loadableAmount = this.carrier.getLoadableAmount(goods.getType());
                if (loadableAmount == 0) {
                    return null;
                }
                if (loadableAmount > goods.getAmount()) {
                    loadableAmount = goods.getAmount();
                }
                Goods toAdd = new Goods(goods.getGame(), goods.getLocation(), goods.getType(), loadableAmount);
                goods.setAmount(goods.getAmount() - loadableAmount);
                this.igc().loadCargo(toAdd, this.carrier);
                this.update();
                return comp;
            }
            if (comp instanceof MarketLabel) {
                MarketLabel label = (MarketLabel)comp;
                Player player = this.carrier.getOwner();
                if (!player.canTrade(label.getType())) {
                    this.igc().payArrears(label.getType());
                    return null;
                }
                this.igc().buyGoods(label.getType(), label.getAmount(), this.carrier);
                this.igc().nextModelMessage();
                this.update();
                return comp;
            }
            if (comp instanceof UnitLabel && this.carrier.canAdd(unit = ((UnitLabel)comp).getUnit())) {
                Container oldParent = comp.getParent();
                if (this.igc().boardShip(unit, this.carrier)) {
                    ((UnitLabel)comp).setSmall(false);
                    if (oldParent != null) {
                        oldParent.remove(comp);
                    }
                    this.update();
                    return comp;
                }
            }
        } else {
            super.add(comp);
        }
        return null;
    }

    @Override
    public int suggested(GoodsType type) {
        return this.carrier.getLoadableAmount(type);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        logger.finest("CargoPanel change " + event.getPropertyName() + ": " + event.getOldValue() + " -> " + event.getNewValue());
        this.update();
    }

    @Override
    public String getUIClassID() {
        return "CargoPanelUI";
    }

    @Override
    public void remove(Component comp) {
        if (comp instanceof UnitLabel) {
            Unit unit = ((UnitLabel)comp).getUnit();
            this.igc().leaveShip(unit);
            this.update();
        } else if (comp instanceof GoodsLabel) {
            Goods g = ((GoodsLabel)comp).getGoods();
            this.igc().unloadCargo(g, false);
            this.update();
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.removeAll();
        this.removePropertyChangeListeners();
        this.defaultTransferHandler = null;
    }
}

