/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.io.File;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.panel.OptionsDialog;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColDirectories;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.option.OptionGroup;

public final class DifficultyDialog
extends OptionsDialog
implements TreeSelectionListener {
    private static final Logger logger = Logger.getLogger(DifficultyDialog.class.getName());
    private static final FileFilter[] filters = new FileFilter[]{null};
    private OptionGroup selected;
    private final Specification specification;

    public DifficultyDialog(FreeColClient freeColClient, JFrame frame, Specification specification, OptionGroup level, boolean editable) {
        super(freeColClient, frame, editable, level, "difficultyDialog", "custom.xml", "model.difficulty.custom");
        this.specification = specification;
        this.selected = level;
        this.getOptionUI().getTree().addTreeSelectionListener(this);
        if (this.isEditable()) {
            this.loadDefaultOptions();
            JButton resetButton = Utility.localizedButton("reset");
            this.addResetAction(resetButton);
            JButton loadButton = Utility.localizedButton("load");
            this.addLoadAction(loadButton);
            JButton saveButton = Utility.localizedButton("save");
            this.addSaveAction(saveButton);
            this.panel.add((Component)resetButton, "span, split 3");
            this.panel.add(loadButton);
            this.panel.add(saveButton);
        }
        this.initialize(frame);
    }

    @Override
    public Specification getSpecification() {
        return this.specification;
    }

    private void addResetAction(JButton button) {
        button.addActionListener(ae -> this.getOptionUI().reset());
    }

    private void addLoadAction(JButton button) {
        this.initializeFilters();
        button.addActionListener(ae -> {
            File dir = FreeColDirectories.getOptionsDirectory();
            File file = this.getGUI().showLoadDialog(dir, filters);
            if (file != null && this.load(file)) {
                this.invalidate();
                this.validate();
                this.repaint();
            }
        });
    }

    private void addSaveAction(JButton button) {
        this.initializeFilters();
        button.addActionListener(ae -> {
            File dir = FreeColDirectories.getOptionsDirectory();
            File file = this.getGUI().showSaveDialog(dir, filters, this.getDefaultFileName());
            if (file != null) {
                this.getOptionUI().updateOption();
                this.save(file);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeFilters() {
        FileFilter[] fileFilterArray = filters;
        synchronized (filters) {
            if (filters[0] == null) {
                String desc = Messages.message("filter.xml");
                DifficultyDialog.filters[0] = new FileNameExtensionFilter(desc, "xml");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent event) {
        TreePath path = event.getPath();
        if (path.getPathCount() >= 2) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getPathComponent(1);
            this.selected = (OptionGroup)node.getUserObject();
        }
    }

    @Override
    public OptionGroup getResponse() {
        OptionGroup value = super.getResponse();
        if (value != null) {
            FreeCol.setDifficulty(value);
        }
        return value;
    }
}

