/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ComponentInputMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.ClientOptions;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.control.InGameController;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.panel.CargoPanel;
import net.sf.freecol.client.gui.panel.DefaultTransferHandler;
import net.sf.freecol.client.gui.panel.DragListener;
import net.sf.freecol.client.gui.panel.DropListener;
import net.sf.freecol.client.gui.panel.DropTarget;
import net.sf.freecol.client.gui.panel.GoodsLabel;
import net.sf.freecol.client.gui.panel.InPortPanel;
import net.sf.freecol.client.gui.panel.MarketLabel;
import net.sf.freecol.client.gui.panel.PortPanel;
import net.sf.freecol.client.gui.panel.UnitLabel;
import net.sf.freecol.client.gui.panel.UnitPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.HighSeas;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.MarketData;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.TransactionListener;
import net.sf.freecol.common.model.Unit;

public final class EuropePanel
extends PortPanel {
    private static final Logger logger = Logger.getLogger(EuropePanel.class.getName());
    private DestinationPanel toAmericaPanel;
    private DestinationPanel toEuropePanel;
    private DocksPanel docksPanel;
    private MarketPanel marketPanel;
    private TransactionLog log;
    private JButton exitButton = new EuropeButton(Messages.message("close"), 27, EuropeAction.EXIT.toString(), this);
    private JButton trainButton = new EuropeButton(Messages.message("train"), 84, EuropeAction.TRAIN.toString(), this);
    private JButton purchaseButton = new EuropeButton(Messages.message("purchase"), 80, EuropeAction.PURCHASE.toString(), this);
    private JButton recruitButton = new EuropeButton(Messages.message("recruit"), 82, EuropeAction.RECRUIT.toString(), this);
    private JButton unloadButton = new EuropeButton(Messages.message("unload"), 85, EuropeAction.UNLOAD.toString(), this);
    private JButton sailButton = new EuropeButton(Messages.message("setSail"), 83, EuropeAction.SAIL.toString(), this);
    private final Europe europe;

    public EuropePanel(FreeColClient freeColClient, boolean header) {
        super(freeColClient, new MigLayout("wrap 3, fill", "[30%:][30%:][15%:]"));
        this.toAmericaPanel = new DestinationPanel();
        this.toEuropePanel = new DestinationPanel();
        this.inPortPanel = new EuropeInPortPanel();
        this.cargoPanel = new CargoPanel(freeColClient, true);
        this.docksPanel = new DocksPanel();
        this.marketPanel = new MarketPanel(this);
        this.log = new TransactionLog();
        this.europe = freeColClient.getMyPlayer().getEurope();
        SimpleAttributeSet attributes = new SimpleAttributeSet();
        StyleConstants.setAlignment(attributes, 2);
        StyleConstants.setBold(attributes, true);
        this.log.setParagraphAttributes(attributes, true);
        this.defaultTransferHandler = new DefaultTransferHandler(freeColClient, this);
        this.toAmericaPanel.setTransferHandler(this.defaultTransferHandler);
        this.toEuropePanel.setTransferHandler(this.defaultTransferHandler);
        this.inPortPanel.setTransferHandler(this.defaultTransferHandler);
        this.cargoPanel.setTransferHandler(this.defaultTransferHandler);
        this.docksPanel.setTransferHandler(this.defaultTransferHandler);
        this.marketPanel.setTransferHandler(this.defaultTransferHandler);
        this.pressListener = new DragListener(freeColClient, this);
        DropListener releaseListener = new DropListener();
        this.toAmericaPanel.addMouseListener(releaseListener);
        this.toEuropePanel.addMouseListener(releaseListener);
        this.inPortPanel.addMouseListener(releaseListener);
        this.cargoPanel.addMouseListener(releaseListener);
        this.docksPanel.addMouseListener(releaseListener);
        this.marketPanel.addMouseListener(releaseListener);
        this.toAmericaPanel.setLayout(new GridLayout(1, 0));
        this.toEuropePanel.setLayout(new GridLayout(1, 0));
        this.inPortPanel.setLayout(new GridLayout(1, 0));
        this.cargoPanel.setLayout(new GridLayout(1, 0));
        this.docksPanel.setLayout(new GridLayout(0, 5));
        JScrollPane toAmericaScroll = new JScrollPane(this.toAmericaPanel, 21, 30);
        toAmericaScroll.getVerticalScrollBar().setUnitIncrement(16);
        JScrollPane toEuropeScroll = new JScrollPane(this.toEuropePanel, 21, 30);
        toEuropeScroll.getVerticalScrollBar().setUnitIncrement(16);
        JScrollPane inPortScroll = new JScrollPane(this.inPortPanel, 21, 30);
        inPortScroll.getVerticalScrollBar().setUnitIncrement(16);
        JScrollPane cargoScroll = new JScrollPane(this.cargoPanel, 21, 30);
        cargoScroll.getVerticalScrollBar().setUnitIncrement(16);
        JScrollPane docksScroll = new JScrollPane(this.docksPanel, 20, 31);
        docksScroll.getVerticalScrollBar().setUnitIncrement(16);
        JScrollPane marketScroll = new JScrollPane(this.marketPanel, 21, 30);
        JScrollPane logScroll = new JScrollPane(this.log, 20, 31);
        logScroll.getVerticalScrollBar().setUnitIncrement(16);
        this.toAmericaPanel.setBorder(Utility.localizedBorder("sailingToAmerica"));
        this.toEuropePanel.setBorder(Utility.localizedBorder("sailingToEurope"));
        this.docksPanel.setBorder(Utility.localizedBorder("docks"));
        this.inPortPanel.setBorder(Utility.localizedBorder("inPort"));
        this.marketPanel.setBorder(Utility.blankBorder(10, 10, 10, 10));
        this.log.setBorder(Utility.localizedBorder("sales"));
        toAmericaScroll.getViewport().setOpaque(false);
        this.toAmericaPanel.setOpaque(false);
        toEuropeScroll.getViewport().setOpaque(false);
        this.toEuropePanel.setOpaque(false);
        inPortScroll.getViewport().setOpaque(false);
        this.inPortPanel.setOpaque(false);
        cargoScroll.getViewport().setOpaque(false);
        this.cargoPanel.setOpaque(false);
        docksScroll.getViewport().setOpaque(false);
        this.docksPanel.setOpaque(false);
        marketScroll.getViewport().setOpaque(false);
        this.marketPanel.setOpaque(false);
        logScroll.getViewport().setOpaque(false);
        this.log.setOpaque(false);
        this.initialize(this.europe);
        if (header) {
            this.add((Component)Utility.localizedHeader(this.europe.getNameKey(), false), "span, top, center");
        }
        this.add((Component)toAmericaScroll, "sg, height 15%:, grow");
        this.add((Component)toEuropeScroll, "sg, height 15%:, grow");
        this.add((Component)logScroll, "spany 3, grow");
        this.add((Component)inPortScroll, "sg, height 15%:, grow");
        this.add((Component)docksScroll, "spany 2, grow");
        this.add((Component)cargoScroll, "height 10%:, grow");
        this.add((Component)marketScroll, "span, height 10%:, grow");
        this.add((Component)this.recruitButton, "span, split 6");
        this.add(this.purchaseButton);
        this.add(this.trainButton);
        this.add(this.unloadButton);
        this.add(this.sailButton);
        this.add((Component)this.exitButton, "tag ok");
        this.setSelectedUnitLabel(null);
        float scale = this.getImageLibrary().getScaleFactor();
        this.getGUI().restoreSavedSize(this, 200 + (int)(scale * 850.0f), 200 + (int)(scale * 525.0f));
    }

    private void initialize(Europe europe) {
        this.toAmericaPanel.initialize(europe.getGame().getMap());
        this.toEuropePanel.initialize(europe);
        this.cargoPanel.initialize();
        this.inPortPanel.initialize();
        this.marketPanel.initialize();
        this.docksPanel.initialize();
        this.log.initialize();
    }

    public void cleanup() {
        this.log.cleanup();
        this.docksPanel.cleanup();
        this.marketPanel.cleanup();
        this.inPortPanel.cleanup();
        this.cargoPanel.cleanup();
        this.toEuropePanel.cleanup();
        this.toAmericaPanel.cleanup();
    }

    @Override
    public void requestFocus() {
        this.exitButton.requestFocus();
    }

    public void refresh() {
        this.repaint(0, 0, this.getWidth(), this.getHeight());
    }

    @Override
    public void setSelectedUnitLabel(UnitLabel unitLabel) {
        if (this.selectedUnitLabel != unitLabel) {
            if (this.selectedUnitLabel != null) {
                this.selectedUnitLabel.setSelected(false);
            }
            this.selectedUnitLabel = unitLabel;
            if (unitLabel == null) {
                this.cargoPanel.setCarrier(null);
            } else {
                this.cargoPanel.setCarrier(unitLabel.getUnit());
                unitLabel.setSelected(true);
            }
        }
        this.inPortPanel.revalidate();
        this.inPortPanel.repaint();
    }

    private void exitAction() {
        this.cleanup();
        this.getGUI().removeFromCanvas(this);
        this.igc().nextModelMessage();
    }

    private void unloadAction() {
        Unit unit = this.getSelectedUnit();
        if (unit != null && unit.isCarrier()) {
            Iterator<Goods> goodsIterator = unit.getGoodsIterator();
            while (goodsIterator.hasNext()) {
                Goods goods = goodsIterator.next();
                if (this.getMyPlayer().canTrade(goods.getType())) {
                    this.igc().sellGoods(goods);
                    continue;
                }
                this.igc().payArrears(goods.getType());
            }
            Iterator<Unit> unitIterator = unit.getUnitIterator();
            while (unitIterator.hasNext()) {
                Unit newUnit = unitIterator.next();
                this.igc().leaveShip(newUnit);
            }
            this.cargoPanel.update();
            this.docksPanel.update();
        }
        this.requestFocus();
    }

    private void sailAction() {
        Unit unit = this.getSelectedUnit();
        if (unit != null && unit.isNaval()) {
            UnitLabel unitLabel = this.getSelectedUnitLabel();
            this.toAmericaPanel.add((Component)unitLabel, true);
        }
        this.requestFocus();
    }

    @Override
    public List<Unit> getUnitList() {
        return this.europe.getUnitList();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        EuropeAction act = EuropeAction.valueOf(command);
        switch (act) {
            case EXIT: {
                this.exitAction();
                break;
            }
            case PURCHASE: {
                this.getGUI().showPurchasePanel();
                break;
            }
            case RECRUIT: {
                this.getGUI().showRecruitPanel();
                break;
            }
            case SAIL: {
                this.sailAction();
                break;
            }
            case TRAIN: {
                this.getGUI().showTrainPanel();
                break;
            }
            case UNLOAD: {
                this.unloadAction();
                break;
            }
            default: {
                super.actionPerformed(ae);
            }
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.removeAll();
        this.toAmericaPanel = null;
        this.toEuropePanel = null;
        this.docksPanel = null;
        this.marketPanel = null;
        this.log = null;
        this.sailButton = null;
        this.unloadButton = null;
        this.recruitButton = null;
        this.purchaseButton = null;
        this.trainButton = null;
        this.exitButton = null;
    }

    public static enum EuropeAction {
        EXIT,
        RECRUIT,
        PURCHASE,
        TRAIN,
        UNLOAD,
        SAIL;

    }

    private final class TransactionLog
    extends JTextPane
    implements TransactionListener {
        public TransactionLog() {
            this.setEditable(false);
        }

        public void initialize() {
            EuropePanel.this.getMyPlayer().getMarket().addTransactionListener(this);
            this.setText("");
        }

        public void cleanup() {
            EuropePanel.this.getMyPlayer().getMarket().removeTransactionListener(this);
        }

        private void add(String text) {
            StyledDocument doc = this.getStyledDocument();
            try {
                if (doc.getLength() > 0) {
                    text = "\n\n" + text;
                }
                doc.insertString(doc.getLength(), text, null);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Transaction log update failure", e);
            }
        }

        @Override
        public void logPurchase(GoodsType goodsType, int amount, int price) {
            int total = amount * price;
            StringTemplate t1 = StringTemplate.template("europePanel.transaction.purchase").addNamed("%goods%", goodsType).addAmount("%amount%", amount).addAmount("%gold%", price);
            StringTemplate t2 = StringTemplate.template("europePanel.transaction.price").addAmount("%gold%", total);
            this.add(Messages.message(t1) + "\n" + Messages.message(t2));
        }

        @Override
        public void logSale(GoodsType goodsType, int amount, int price, int tax) {
            int totalBeforeTax = amount * price;
            int totalTax = totalBeforeTax * tax / 100;
            int totalAfterTax = totalBeforeTax - totalTax;
            StringTemplate t1 = StringTemplate.template("europePanel.transaction.sale").addNamed("%goods%", goodsType).addAmount("%amount%", amount).addAmount("%gold%", price);
            StringTemplate t2 = StringTemplate.template("europePanel.transaction.price").addAmount("%gold%", totalBeforeTax);
            StringTemplate t3 = StringTemplate.template("europePanel.transaction.tax").addAmount("%tax%", tax).addAmount("%gold%", totalTax);
            StringTemplate t4 = StringTemplate.template("europePanel.transaction.net").addAmount("%gold%", totalAfterTax);
            this.add(Messages.message(t1) + "\n" + Messages.message(t2) + "\n" + Messages.message(t3) + "\n" + Messages.message(t4));
        }
    }

    private final class MarketPanel
    extends JPanel
    implements DropTarget {
        public MarketPanel(EuropePanel europePanel2) {
            super(new GridLayout(2, 8));
        }

        public void initialize() {
            this.removeAll();
            Market market = EuropePanel.this.getMyPlayer().getMarket();
            ImageLibrary lib = EuropePanel.this.getImageLibrary();
            for (GoodsType goodsType : EuropePanel.this.getSpecification().getStorableGoodsTypeList()) {
                MarketLabel label = new MarketLabel(lib, goodsType, market);
                label.setTransferHandler(EuropePanel.this.defaultTransferHandler);
                label.addMouseListener(EuropePanel.this.pressListener);
                MarketData md = market.getMarketData(goodsType);
                if (md != null) {
                    md.addPropertyChangeListener(label);
                }
                this.add(label);
            }
        }

        public void cleanup() {
        }

        @Override
        public boolean accepts(Unit unit) {
            return false;
        }

        @Override
        public boolean accepts(Goods goods) {
            return true;
        }

        @Override
        public Component add(Component comp, boolean editState) {
            if (editState) {
                if (!(comp instanceof GoodsLabel)) {
                    logger.warning("Invalid component: " + comp);
                    return null;
                }
                Goods goods = ((GoodsLabel)comp).getGoods();
                if (EuropePanel.this.getMyPlayer().canTrade(goods.getType())) {
                    EuropePanel.this.igc().sellGoods(goods);
                } else {
                    InGameController.BoycottAction act = EuropePanel.this.getGUI().getBoycottChoice(goods, EuropePanel.this.europe);
                    if (act != null) {
                        switch (act) {
                            case PAY_ARREARS: {
                                EuropePanel.this.igc().payArrears(goods.getType());
                                break;
                            }
                            case DUMP_CARGO: {
                                EuropePanel.this.igc().unloadCargo(goods, true);
                                break;
                            }
                            default: {
                                logger.warning("showBoycottedGoodsDialog fail: " + (Object)((Object)act));
                            }
                        }
                    }
                }
                EuropePanel.this.cargoPanel.revalidate();
                this.revalidate();
                EuropePanel.this.igc().nextModelMessage();
            }
            EuropePanel.this.refresh();
            return comp;
        }

        @Override
        public int suggested(GoodsType type) {
            return -1;
        }

        @Override
        public void remove(Component comp) {
        }
    }

    private final class EuropeInPortPanel
    extends InPortPanel {
        public EuropeInPortPanel() {
            super(EuropePanel.this, "Europe - port", true);
        }

        @Override
        protected void addPropertyChangeListeners() {
            EuropePanel.this.europe.addPropertyChangeListener(this);
        }

        @Override
        protected void removePropertyChangeListeners() {
            EuropePanel.this.europe.removePropertyChangeListener(this);
        }

        @Override
        public boolean accepts(Unit unit) {
            if (!unit.isNaval()) {
                return false;
            }
            switch (unit.getState()) {
                case ACTIVE: 
                case FORTIFIED: 
                case FORTIFYING: 
                case SENTRY: 
                case SKIPPED: {
                    return true;
                }
            }
            return false;
        }
    }

    private static final class EuropeButton
    extends JButton {
        public EuropeButton(String text, int keyEvent, String command, ActionListener listener) {
            this.setOpaque(true);
            this.setText(text);
            this.setActionCommand(command);
            this.addActionListener(listener);
            ComponentInputMap closeInputMap = new ComponentInputMap(this);
            ((InputMap)closeInputMap).put(KeyStroke.getKeyStroke(keyEvent, 0, false), "pressed");
            ((InputMap)closeInputMap).put(KeyStroke.getKeyStroke(keyEvent, 0, true), "released");
            SwingUtilities.replaceUIInputMap(this, 2, closeInputMap);
        }
    }

    public final class DocksPanel
    extends UnitPanel
    implements DropTarget {
        public DocksPanel() {
            super(EuropePanel.this, "Europe - docks", true);
            this.setLayout(new MigLayout("wrap 6"));
        }

        @Override
        public void addPropertyChangeListeners() {
            EuropePanel.this.europe.addPropertyChangeListener(this);
        }

        @Override
        public void removePropertyChangeListeners() {
            EuropePanel.this.europe.removePropertyChangeListener(this);
        }

        @Override
        public boolean accepts(Unit unit) {
            return !unit.isNaval();
        }

        @Override
        public boolean accepts(Goods goods) {
            return false;
        }

        @Override
        public Component add(Component comp, boolean editState) {
            Component c = this.add(comp);
            this.update();
            return c;
        }

        @Override
        public int suggested(GoodsType type) {
            return -1;
        }

        @Override
        public void remove(Component comp) {
            this.update();
        }
    }

    private final class DestinationPanel
    extends JPanel
    implements DropTarget {
        private Location destination;

        private DestinationPanel() {
        }

        public void initialize(Location destination) {
            this.destination = destination;
            this.update();
        }

        public void cleanup() {
        }

        public void update() {
            this.removeAll();
            HighSeas highSeas = EuropePanel.this.getMyPlayer().getHighSeas();
            if (highSeas != null) {
                for (Unit unit : highSeas.getUnitList()) {
                    boolean belongs;
                    if (this.destination instanceof Europe) {
                        belongs = unit.getDestination() == this.destination;
                    } else if (this.destination instanceof Map) {
                        belongs = unit.getDestination() == this.destination || unit.getDestination() != null && unit.getDestination().getTile() != null && unit.getDestination().getTile().getMap() == this.destination;
                    } else {
                        logger.warning("Bogus DestinationPanel location: " + this.destination + " for unit: " + unit);
                        belongs = false;
                    }
                    if (!belongs) continue;
                    UnitLabel unitLabel = new UnitLabel(EuropePanel.this.getFreeColClient(), unit);
                    unitLabel.setTransferHandler(EuropePanel.this.defaultTransferHandler);
                    unitLabel.addMouseListener(EuropePanel.this.pressListener);
                    this.add(unitLabel);
                }
            }
            Utility.localizeBorder(this, Unit.getDestinationLabel("ship", this.destination, EuropePanel.this.getMyPlayer()));
            this.revalidate();
        }

        @Override
        public boolean accepts(Unit unit) {
            return unit.isNaval() && !unit.isDamaged();
        }

        @Override
        public boolean accepts(Goods goods) {
            return false;
        }

        @Override
        public Component add(Component comp, boolean editState) {
            if (editState) {
                if (!(comp instanceof UnitLabel)) {
                    logger.warning("Invalid component: " + comp);
                    return null;
                }
                Unit unit = ((UnitLabel)comp).getUnit();
                if (!(unit.getTradeRoute() == null || EuropePanel.this.getGUI().confirmClearTradeRoute(unit) && EuropePanel.this.igc().assignTradeRoute(unit, null))) {
                    return null;
                }
                Location dest = this.destination;
                if (unit.isInEurope() && (dest = EuropePanel.this.getGUI().showSelectDestinationDialog(unit)) == null) {
                    return null;
                }
                ClientOptions co = EuropePanel.this.getClientOptions();
                if (!co.getBoolean("model.option.autoloadEmigrants") && unit.isInEurope() && !(this.destination instanceof Europe) && EuropePanel.this.docksPanel.getComponentCount() > 0 && unit.hasSpaceLeft()) {
                    StringTemplate locName = this.destination.getLocationLabelFor(unit.getOwner());
                    if (!EuropePanel.this.getGUI().confirm(null, StringTemplate.template("europePanel.leaveColonists").addStringTemplate("%newWorld%", locName), unit, "ok", "cancel")) {
                        return null;
                    }
                }
                comp.getParent().remove(comp);
                EuropePanel.this.igc().moveTo(unit, dest);
                EuropePanel.this.inPortPanel.update();
                EuropePanel.this.docksPanel.update();
                EuropePanel.this.cargoPanel.update();
                if (unit == EuropePanel.this.cargoPanel.getCarrier()) {
                    EuropePanel.this.cargoPanel.setCarrier(null);
                }
            }
            Component c = this.add(comp);
            this.revalidate();
            EuropePanel.this.refresh();
            return c;
        }

        @Override
        public int suggested(GoodsType type) {
            return -1;
        }
    }
}

