/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.swing.JLabel;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Feature;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Nameable;
import net.sf.freecol.common.model.Named;
import net.sf.freecol.common.model.Turn;

public class ModifierFormat {
    private static final DecimalFormat modifierFormat = new DecimalFormat("0.00");

    public static final String getUnknownValue() {
        return Messages.message("modifierFormat.unknown");
    }

    public static final String format(double value) {
        return value == (double)1.4E-45f ? ModifierFormat.getUnknownValue() : modifierFormat.format(value);
    }

    public static final String[] getModifierStrings(Modifier modifier) {
        return ModifierFormat.getModifierStrings(modifier.getValue(), modifier.getType());
    }

    public static final String[] getModifierStrings(float value, Modifier.ModifierType type) {
        String[] stringArray;
        String bonus = modifierFormat.format(value);
        if (value == Float.MIN_VALUE) {
            return new String[]{" ", bonus, null};
        }
        if (value < 0.0f) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = "-";
            stringArray2[1] = bonus.substring(1);
            stringArray = stringArray2;
            stringArray2[2] = null;
        } else {
            String[] stringArray3 = new String[3];
            stringArray3[0] = "+";
            stringArray3[1] = bonus;
            stringArray = stringArray3;
            stringArray3[2] = null;
        }
        String[] result = stringArray;
        switch (type) {
            case MULTIPLICATIVE: {
                result[0] = "\u00d7";
                break;
            }
            case PERCENTAGE: {
                result[2] = "%";
                break;
            }
        }
        return result;
    }

    private static String getSourceName(FreeColObject source) {
        if (source == null) {
            return ModifierFormat.getUnknownValue();
        }
        String result = null;
        if (result == null && source instanceof Nameable && (result = ((Nameable)((Object)source)).getName()) != null && result.isEmpty()) {
            result = null;
        }
        if (result == null && source instanceof Named && (result = Messages.getName((Named)((Object)source))) != null && result.isEmpty()) {
            result = null;
        }
        if (result == null) {
            result = Messages.getName(source.getId());
        }
        return result;
    }

    public static JLabel[] getModifierLabels(Modifier modifier, FreeColGameObjectType fcgot, Turn turn) {
        String sourceName = ModifierFormat.getSourceName(modifier.getSource());
        if (fcgot != null && modifier.appliesTo(fcgot)) {
            sourceName = sourceName + " (" + Messages.getName(fcgot) + ")";
        }
        float value = modifier.getValue(turn);
        String[] bonus = ModifierFormat.getModifierStrings(value, modifier.getType());
        JLabel[] result = new JLabel[]{new JLabel(sourceName), new JLabel(bonus[0] + bonus[1]), bonus[2] == null ? null : new JLabel(bonus[2])};
        return result;
    }

    public static String getFeatureAsString(Feature feature) {
        return Messages.getName(feature) + ":" + (!feature.hasScope() ? "" : feature.getScopes().stream().map(scope -> {
            String k = scope.getKey();
            if (k == null) {
                k = "";
            } else {
                k = Messages.getName(k);
                if (scope.isMatchNegated()) {
                    k = "!" + k;
                }
            }
            return k;
        }).collect(Collectors.joining()));
    }

    public static String getModifierAsString(Modifier modifier) {
        return Arrays.stream(ModifierFormat.getModifierStrings(modifier)).filter(s -> s != null).collect(Collectors.joining());
    }
}

