/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.MigPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;

public class ReportPanel
extends FreeColPanel {
    protected static final Logger logger = Logger.getLogger(ReportPanel.class.getName());
    protected final JPanel reportPanel;
    protected final JLabel header;
    protected JScrollPane scrollPane;

    public ReportPanel(FreeColClient freeColClient, String key) {
        super(freeColClient, new MigLayout("wrap 1", "[fill]", "[]30[fill]30[]"));
        this.header = Utility.localizedHeader(Messages.nameKey(key), false);
        this.add((Component)this.header, "cell 0 0, align center");
        this.reportPanel = new MigPanel("ReportPanelUI");
        this.reportPanel.setOpaque(true);
        this.reportPanel.setBorder(this.createBorder());
        this.scrollPane = new JScrollPane(this.reportPanel, 20, 30);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(16);
        this.add((Component)this.scrollPane, "cell 0 1, height 100%, width 100%");
        this.add((Component)this.okButton, "cell 0 2, tag ok");
        float scale = this.getImageLibrary().getScaleFactor();
        this.getGUI().restoreSavedSize(this, 200 + (int)(scale * 850.0f), 200 + (int)(scale * 525.0f));
    }

    public void initialize() {
        this.reportPanel.removeAll();
        this.reportPanel.doLayout();
    }

    private Border createBorder() {
        return new EmptyBorder(20, 20, 20, 20);
    }

    protected JLabel createUnitTypeLabel(AbstractUnit au) {
        UnitType unitType = au.getType(this.getSpecification());
        String roleId = au.getRoleId();
        int count = au.getNumber();
        ImageIcon unitIcon = new ImageIcon(this.getImageLibrary().getSmallUnitImage(unitType, roleId, count == 0));
        JLabel unitLabel = new JLabel(unitIcon);
        unitLabel.setText(String.valueOf(count));
        if (count == 0) {
            unitLabel.setForeground(Color.GRAY);
        }
        unitLabel.setToolTipText(au.getDescription());
        return unitLabel;
    }

    protected String getLocationLabelFor(Unit unit) {
        if (unit.getDestination() instanceof Map) {
            return Messages.message("sailingToAmerica");
        }
        if (unit.getDestination() instanceof Europe) {
            return Messages.message("sailingToEurope");
        }
        return Messages.message(unit.getLocation().getLocationLabelFor(unit.getOwner()));
    }

    protected void setMainComponent(Component main) {
        this.remove(this.scrollPane);
        this.add(main, "cell 0 1, height 100%, width 100%");
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        if ("OK".equals(command)) {
            this.getGUI().removeFromCanvas(this);
        } else {
            FreeColGameObject fco = this.getGame().getFreeColGameObject(command);
            if (fco != null) {
                this.getGUI().displayObject(fco);
            } else {
                this.getGUI().showColopediaPanel(command);
            }
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.removeAll();
        this.scrollPane = null;
    }
}

