/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ServerInfo {
    private String name;
    private String address;
    private int port;
    private int currentlyPlaying;
    private int slotsAvailable;
    private boolean isGameStarted;
    private String version;
    private int gameState;

    protected ServerInfo() {
    }

    public ServerInfo(String name, String address, int port, int slotsAvailable, int currentlyPlaying, boolean isGameStarted, String version, int gameState) {
        this.update(name, address, port, slotsAvailable, currentlyPlaying, isGameStarted, version, gameState);
    }

    public ServerInfo(Element element) {
        this.readFromXMLElement(element);
    }

    public void update(String name, String address, int port, int slotsAvailable, int currentlyPlaying, boolean isGameStarted, String version, int gameState) {
        this.name = name;
        this.address = address;
        this.port = port;
        this.slotsAvailable = slotsAvailable;
        this.currentlyPlaying = currentlyPlaying;
        this.isGameStarted = isGameStarted;
        this.version = version;
        this.gameState = gameState;
    }

    public final void update(Element element) {
        this.update(element.getAttribute("name"), element.getAttribute("address"), Integer.parseInt(element.getAttribute("port")), Integer.parseInt(element.getAttribute("slotsAvailable")), Integer.parseInt(element.getAttribute("currentlyPlaying")), Boolean.parseBoolean(element.getAttribute("slotsAvailable")), element.getAttribute("version"), Integer.parseInt(element.getAttribute("gameState")));
    }

    public String getName() {
        return this.name;
    }

    public String getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    public int getCurrentlyPlaying() {
        return this.currentlyPlaying;
    }

    public int getSlotsAvailable() {
        return this.slotsAvailable;
    }

    public String getVersion() {
        return this.version;
    }

    public int getGameState() {
        return this.gameState;
    }

    public Element toXMLElement(Document document) {
        Element element = document.createElement(ServerInfo.getXMLElementTagName());
        element.setAttribute("name", this.name);
        element.setAttribute("address", this.address);
        element.setAttribute("port", Integer.toString(this.port));
        element.setAttribute("slotsAvailable", Integer.toString(this.slotsAvailable));
        element.setAttribute("currentlyPlaying", Integer.toString(this.currentlyPlaying));
        element.setAttribute("isGameStarted", Boolean.toString(this.isGameStarted));
        element.setAttribute("version", this.version);
        element.setAttribute("gameState", Integer.toString(this.gameState));
        return element;
    }

    public void readFromXMLElement(Element element) {
        this.update(element);
    }

    public static String getXMLElementTagName() {
        return "serverInfo";
    }

    public String toString() {
        return this.name + "(" + this.address + ":" + this.port + ") " + this.currentlyPlaying + ", " + this.slotsAvailable + ", " + this.isGameStarted + ", " + this.version + ", " + this.gameState;
    }
}

