/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import net.sf.freecol.common.model.Ability;
import net.sf.freecol.common.model.Feature;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.util.CollectionUtils;

public final class FeatureContainer {
    private static final Logger logger = Logger.getLogger(FeatureContainer.class.getName());
    private final Object abilitiesLock = new Object();
    private final Object modifiersLock = new Object();
    private Map<String, Set<Ability>> abilities = null;
    private Map<String, Set<Modifier>> modifiers = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean abilitiesPresent() {
        Object object = this.abilitiesLock;
        synchronized (object) {
            return this.abilities != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requireAbilities() {
        Object object = this.abilitiesLock;
        synchronized (object) {
            if (this.abilities == null) {
                this.abilities = new HashMap<String, Set<Ability>>();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean modifiersPresent() {
        Object object = this.modifiersLock;
        synchronized (object) {
            return this.modifiers != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void requireModifiers() {
        Object object = this.modifiersLock;
        synchronized (object) {
            if (this.modifiers == null) {
                this.modifiers = new HashMap<String, Set<Modifier>>();
            }
        }
    }

    public static boolean hasAbility(Set<Ability> abilitySet) {
        return abilitySet == null || abilitySet.isEmpty() ? false : CollectionUtils.all(abilitySet, Ability::getValue);
    }

    public boolean hasAbility(String id, FreeColGameObjectType fcgot, Turn turn) {
        return FeatureContainer.hasAbility(this.getAbilities(id, fcgot, turn));
    }

    public boolean containsAbilityKey(String key) {
        return !this.getAbilities(key, null, null).isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Ability> getAbilities(String id, FreeColGameObjectType fcgot, Turn turn) {
        HashSet<Ability> result = new HashSet<Ability>();
        if (this.abilitiesPresent()) {
            Object object = this.abilitiesLock;
            synchronized (object) {
                if (id == null) {
                    for (Set<Ability> aset : this.abilities.values()) {
                        result.addAll(aset);
                    }
                } else {
                    Set<Ability> aset = this.abilities.get(id);
                    if (aset != null) {
                        result.addAll(aset);
                    }
                }
            }
            Iterator it = result.iterator();
            while (it.hasNext()) {
                Ability a = (Ability)it.next();
                if (a.appliesTo(fcgot, turn)) continue;
                it.remove();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAbility(Ability ability) {
        if (ability == null) {
            return false;
        }
        this.requireAbilities();
        Object object = this.abilitiesLock;
        synchronized (object) {
            Set<Ability> abilitySet = this.abilities.get(ability.getId());
            if (abilitySet == null) {
                abilitySet = new HashSet<Ability>();
                this.abilities.put(ability.getId(), abilitySet);
            }
            return abilitySet.add(ability);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ability removeAbility(Ability ability) {
        if (ability == null || !this.abilitiesPresent()) {
            return null;
        }
        Object object = this.abilitiesLock;
        synchronized (object) {
            Set<Ability> abilitySet = this.abilities.get(ability.getId());
            return abilitySet == null || !abilitySet.remove(ability) ? null : ability;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAbilities(String id) {
        if (!this.abilitiesPresent()) {
            return;
        }
        Object object = this.abilitiesLock;
        synchronized (object) {
            this.abilities.remove(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Modifier> getModifiers(String id, FreeColGameObjectType fcgot, Turn turn) {
        HashSet<Modifier> result = new HashSet<Modifier>();
        if (this.modifiersPresent()) {
            Object object = this.modifiersLock;
            synchronized (object) {
                if (id == null) {
                    for (Set<Modifier> mset : this.modifiers.values()) {
                        result.addAll(mset);
                    }
                } else {
                    Set<Modifier> mset = this.modifiers.get(id);
                    if (mset != null) {
                        result.addAll(mset);
                    }
                }
            }
            Iterator it = result.iterator();
            while (it.hasNext()) {
                Modifier m = (Modifier)it.next();
                if (m.appliesTo(fcgot, turn)) continue;
                it.remove();
            }
        }
        return result;
    }

    public final float applyModifiers(float number, Turn turn, String id, FreeColGameObjectType fcgot) {
        return FeatureContainer.applyModifiers(number, turn, this.getModifiers(id, fcgot, turn));
    }

    public static float applyModifiers(float number, Turn turn, Collection<Modifier> mods) {
        if (mods == null || mods.isEmpty()) {
            return number;
        }
        ArrayList<Modifier> modifiers = new ArrayList<Modifier>(mods);
        Collections.sort(modifiers);
        float result = number;
        for (Modifier m : modifiers) {
            float value = m.getValue(turn);
            if (value == Float.MIN_VALUE) {
                return value;
            }
            result = m.apply(result, value);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addModifier(Modifier modifier) {
        if (modifier == null) {
            return false;
        }
        this.requireModifiers();
        Object object = this.modifiersLock;
        synchronized (object) {
            Set<Modifier> modifierSet = this.modifiers.get(modifier.getId());
            if (modifierSet == null) {
                modifierSet = new HashSet<Modifier>();
                this.modifiers.put(modifier.getId(), modifierSet);
            }
            return modifierSet.add(modifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Modifier removeModifier(Modifier modifier) {
        if (modifier == null || !this.modifiersPresent()) {
            return null;
        }
        Object object = this.modifiersLock;
        synchronized (object) {
            Set<Modifier> modifierSet = this.modifiers.get(modifier.getId());
            return modifierSet == null || !modifierSet.remove(modifier) ? null : modifier;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModifiers(String id) {
        if (!this.modifiersPresent()) {
            return;
        }
        Object object = this.modifiersLock;
        synchronized (object) {
            this.modifiers.remove(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFeatures(FreeColObject fco) {
        Object object;
        FeatureContainer c = fco.getFeatureContainer();
        if (c == null) {
            return;
        }
        if (c.abilitiesPresent()) {
            HashMap<String, Set<Ability>> ca;
            this.requireAbilities();
            object = c.abilitiesLock;
            synchronized (object) {
                ca = new HashMap<String, Set<Ability>>(c.abilities);
            }
            object = this.abilitiesLock;
            synchronized (object) {
                for (Map.Entry<String, Set<Feature>> entry : ca.entrySet()) {
                    Set<Ability> abilitySet = this.abilities.get(entry.getKey());
                    if (abilitySet == null) {
                        abilitySet = new HashSet<Ability>();
                        this.abilities.put(entry.getKey(), abilitySet);
                    }
                    abilitySet.addAll((Collection<Ability>)entry.getValue());
                }
            }
        }
        if (c.modifiersPresent()) {
            HashMap<String, Set<Modifier>> cm;
            this.requireModifiers();
            object = c.modifiersLock;
            synchronized (object) {
                cm = new HashMap<String, Set<Modifier>>(c.modifiers);
            }
            object = this.modifiersLock;
            synchronized (object) {
                for (Map.Entry<String, Set<Feature>> entry : cm.entrySet()) {
                    Set<Modifier> modifierSet = this.modifiers.get(entry.getKey());
                    if (modifierSet == null) {
                        modifierSet = new HashSet<Modifier>();
                        this.modifiers.put(entry.getKey(), modifierSet);
                    }
                    modifierSet.addAll((Collection<Modifier>)entry.getValue());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFeatures(FreeColObject fco) {
        Object object;
        FeatureContainer c = fco.getFeatureContainer();
        if (c == null) {
            return;
        }
        if (this.abilitiesPresent() && c.abilitiesPresent()) {
            HashSet<String> ca = new HashSet<String>();
            object = c.abilitiesLock;
            synchronized (object) {
                ca.addAll(c.abilities.keySet());
            }
            object = this.abilitiesLock;
            synchronized (object) {
                for (String key : ca) {
                    Set<Ability> abilitySet = this.abilities.get(key);
                    if (abilitySet == null) continue;
                    for (Ability a : new HashSet<Ability>(abilitySet)) {
                        if (a.getSource() != fco) continue;
                        abilitySet.remove(a);
                    }
                }
            }
        }
        if (this.modifiersPresent() && c.modifiersPresent()) {
            HashSet<String> cm = new HashSet<String>();
            object = c.modifiersLock;
            synchronized (object) {
                cm.addAll(c.modifiers.keySet());
            }
            object = this.modifiersLock;
            synchronized (object) {
                for (String key : cm) {
                    Set<Modifier> modifierSet = this.modifiers.get(key);
                    if (modifierSet == null) continue;
                    for (Modifier m : new HashSet<Modifier>(modifierSet)) {
                        if (m.getSource() != fco) continue;
                        modifierSet.remove(m);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object;
        if (this.abilitiesPresent()) {
            object = this.abilitiesLock;
            synchronized (object) {
                this.abilities.clear();
            }
        }
        if (this.modifiersPresent()) {
            object = this.modifiersLock;
            synchronized (object) {
                this.modifiers.clear();
            }
        }
    }

    public void replaceSource(FreeColGameObjectType oldSource, FreeColGameObjectType newSource) {
        for (Ability ability : this.getAbilities(null, null, null)) {
            if (oldSource != null && ability.getSource() != oldSource) continue;
            this.removeAbility(ability);
            Ability newAbility = new Ability(ability);
            newAbility.setSource(newSource);
            this.addAbility(newAbility);
        }
        for (Modifier modifier : this.getModifiers(null, null, null)) {
            if (oldSource != null && modifier.getSource() != oldSource) continue;
            this.removeModifier(modifier);
            Modifier newModifier = new Modifier(modifier);
            newModifier.setSource(newSource);
            this.addModifier(newModifier);
        }
    }

    public String toString() {
        Set<Modifier> modifiers;
        StringBuilder sb = new StringBuilder(256);
        sb.append("[FeatureContainer");
        Set<Ability> abilities = this.getAbilities(null, null, null);
        if (!abilities.isEmpty()) {
            sb.append(" [abilities");
            for (Ability ability : this.getAbilities(null, null, null)) {
                sb.append(" ").append(ability);
            }
            sb.append("]");
        }
        if (!(modifiers = this.getModifiers(null, null, null)).isEmpty()) {
            sb.append(" [modifiers");
            for (Modifier modifier : this.getModifiers(null, null, null)) {
                sb.append(" ").append(modifier);
            }
            sb.append("]");
        }
        sb.append("]");
        return sb.toString();
    }
}

