/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.resources;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.net.URI;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.freecol.common.resources.Resource;

public class FontResource
extends Resource {
    private static final Logger logger = Logger.getLogger(FontResource.class.getName());
    public static final String SCHEME = "font:";
    private Font font;

    public FontResource(Font font) {
        this.font = font;
    }

    public FontResource(URI resourceLocator) throws Exception {
        super(resourceLocator);
        this.font = null;
        try {
            if (resourceLocator.getPath() != null && resourceLocator.getPath().endsWith(".ttf")) {
                URL url = resourceLocator.toURL();
                this.font = Font.createFont(0, url.openStream());
            } else {
                String name = resourceLocator.getSchemeSpecificPart();
                this.font = Font.decode(name.substring(SCHEME.length()));
            }
            if (this.font != null) {
                GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont(this.font);
            }
            logger.info("Loaded font: " + this.font.getFontName() + " from: " + resourceLocator);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed loading font from: " + resourceLocator, e);
            throw e;
        }
    }

    public Font getFont() {
        if (this.font == null) {
            this.font = FontResource.getEmergencyFont();
            logger.warning("Font is null");
        }
        return this.font;
    }

    public static Font getEmergencyFont() {
        logger.warning("Using emergency font");
        return Font.decode(null);
    }
}

