/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.sf.freecol.common.util.Utils;

public class CollectionUtils {
    public static final BinaryOperator<Integer> integerAccumulator = (i1, i2) -> i1 + i2;
    public static final BinaryOperator<Double> doubleAccumulator = (d1, d2) -> d1 + d2;
    public static final Comparator<Integer> ascendingIntegerComparator = Comparator.comparingInt(i -> i);
    public static final Comparator<Integer> descendingIntegerComparator = ascendingIntegerComparator.reversed();
    public static final Comparator<Double> ascendingDoubleComparator = Comparator.comparingDouble(d -> d);
    public static final Comparator<Double> descendingDoubleComparator = ascendingDoubleComparator.reversed();
    public static final Comparator<List<?>> ascendingListLengthComparator = Comparator.comparingInt(l -> l.size());
    public static final Comparator<List<?>> descendingListLengthComparator = ascendingListLengthComparator.reversed();

    @SafeVarargs
    public static <T> Set<T> makeUnmodifiableSet(T ... members) {
        HashSet<T> tmp = new HashSet<T>();
        for (T t : members) {
            tmp.add(t);
        }
        return Collections.unmodifiableSet(tmp);
    }

    @SafeVarargs
    public static <T> List<T> makeUnmodifiableList(T ... members) {
        ArrayList<T> tmp = new ArrayList<T>();
        for (T t : members) {
            tmp.add(t);
        }
        return Collections.unmodifiableList(tmp);
    }

    public static <T, K> void appendToMapList(Map<K, List<T>> map, K key, T value) {
        List<T> l = map.get(key);
        if (l == null) {
            l = new ArrayList<T>();
            l.add(value);
            map.put(key, l);
        } else if (!l.contains(value)) {
            l.add(value);
        }
    }

    public static <K, V> void accumulateToMap(Map<K, V> map, K key, V value, BinaryOperator<V> accumulator) {
        if (map.containsKey(key)) {
            map.put(key, accumulator.apply(map.get(key), value));
        } else {
            map.put(key, value);
        }
    }

    public static <K, V> void accumulateMap(Map<K, V> map1, Map<K, V> map2, BinaryOperator<V> accumulator) {
        for (Map.Entry<K, V> e : map2.entrySet()) {
            CollectionUtils.accumulateToMap(map1, e.getKey(), e.getValue(), accumulator);
        }
    }

    public static <K> int incrementMapCount(Map<K, Integer> map, K key) {
        int count = map.containsKey(key) ? map.get(key) : 0;
        map.put(key, count + 1);
        return count + 1;
    }

    public static <T> Iterable<List<T>> getPermutations(final List<T> l) {
        if (l == null) {
            return null;
        }
        return new Iterable<List<T>>(){

            @Override
            public Iterator<List<T>> iterator() {
                return new Iterator<List<T>>(){
                    private final List<T> original;
                    private final int n;
                    private final int np;
                    private int index;
                    {
                        this.original = new ArrayList(l);
                        this.n = l.size();
                        this.np = this.factorial(this.n);
                        this.index = 0;
                    }

                    private int factorial(int n) {
                        int total = n;
                        while (--n > 1) {
                            total *= n;
                        }
                        return total;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.index < this.np;
                    }

                    @Override
                    public List<T> next() {
                        ArrayList pick = new ArrayList(this.original);
                        ArrayList result = new ArrayList();
                        int current = this.index++;
                        int divisor = this.np;
                        for (int i = this.n; i > 0; --i) {
                            int j = current / (divisor /= i);
                            result.add(pick.remove(j));
                            current -= j * divisor;
                        }
                        return result;
                    }

                    @Override
                    public void remove() {
                        throw new RuntimeException("remove() not implemented");
                    }
                };
            }
        };
    }

    public static <T> boolean allSame(Collection<T> collection) {
        Object datum = null;
        boolean first = true;
        for (T t : collection) {
            if (first) {
                datum = t;
            } else if (t != datum) {
                return false;
            }
            first = false;
        }
        return true;
    }

    public static <T> void rotate(List<T> list, int n) {
        int len = list.size();
        if (len <= 0 || n == 0) {
            return;
        }
        if ((n %= len) > 0) {
            while (n > 0) {
                T t = list.remove(0);
                list.add(t);
                --n;
            }
        } else {
            while (n < 0) {
                T t = list.remove(n - 1);
                list.add(0, t);
                ++n;
            }
        }
    }

    public static <T> void reverse(List<T> list) {
        int len = list.size();
        if (len <= 0) {
            return;
        }
        int i = 0;
        for (int j = len - 1; i < j; ++i, --j) {
            T t = list.get(i);
            list.set(i, list.get(j));
            list.set(j, t);
        }
    }

    public static <T> boolean listEquals(List<T> one, List<T> two) {
        block3: {
            if (one == null) {
                return two == null;
            }
            if (two == null) {
                return false;
            }
            Iterator<T> oneI = one.iterator();
            Iterator<T> twoI = two.iterator();
            while (oneI.hasNext()) {
                if (twoI.hasNext() && Utils.equals(oneI.next(), twoI.next())) continue;
                break block3;
            }
            return !twoI.hasNext();
        }
        return false;
    }

    public static <K extends Comparable<? super K>, V> List<Map.Entry<K, V>> mapEntriesByKey(Map<K, V> map) {
        return map.entrySet().stream().sorted((e1, e2) -> ((Comparable)e1.getKey()).compareTo(e2.getKey())).collect(Collectors.toList());
    }

    public static <K, V> List<Map.Entry<K, V>> mapEntriesByKey(Map<K, V> map, Comparator<K> comparator) {
        return map.entrySet().stream().sorted((e1, e2) -> comparator.compare(e1.getKey(), e2.getKey())).collect(Collectors.toList());
    }

    public static <K, V extends Comparable<? super V>> List<Map.Entry<K, V>> mapEntriesByValue(Map<K, V> map) {
        return map.entrySet().stream().sorted((e1, e2) -> ((Comparable)e1.getValue()).compareTo(e2.getValue())).collect(Collectors.toList());
    }

    public static <K, V> List<Map.Entry<K, V>> mapEntriesByValue(Map<K, V> map, Comparator<V> comparator) {
        return map.entrySet().stream().sorted((e1, e2) -> comparator.compare(e1.getValue(), e2.getValue())).collect(Collectors.toList());
    }

    public static <T> boolean all(T[] array, Predicate<T> predicate) {
        return CollectionUtils.all(Arrays.stream(array), predicate);
    }

    public static <T> boolean any(T[] array, Predicate<T> predicate) {
        return CollectionUtils.any(Arrays.stream(array), predicate);
    }

    public static <T> boolean none(T[] array, Predicate<T> predicate) {
        return CollectionUtils.none(Arrays.stream(array), predicate);
    }

    public static <T> boolean all(Collection<T> collection, Predicate<T> predicate) {
        return CollectionUtils.all(collection.stream(), predicate);
    }

    public static <T> boolean any(Collection<T> collection, Predicate<T> predicate) {
        return CollectionUtils.any(collection.stream(), predicate);
    }

    public static <T> boolean none(Collection<T> collection, Predicate<T> predicate) {
        return CollectionUtils.none(collection.stream(), predicate);
    }

    public static <T> boolean all(Stream<T> stream, Predicate<T> predicate) {
        return stream.allMatch(predicate);
    }

    public static <T> boolean any(Stream<T> stream, Predicate<T> predicate) {
        return stream.anyMatch(predicate);
    }

    public static <T> boolean none(Stream<T> stream, Predicate<T> predicate) {
        return stream.noneMatch(predicate);
    }

    public static <T> boolean contains(Collection<T> collection, Predicate<T> predicate) {
        return collection.stream().filter(predicate).findFirst().isPresent();
    }

    public static <T> T find(T[] array, Predicate<T> predicate, T fail) {
        return CollectionUtils.find(Arrays.stream(array), predicate, fail);
    }

    public static <T> T find(Collection<T> collection, Predicate<T> predicate) {
        return CollectionUtils.find(collection, predicate, null);
    }

    public static <T> T find(Collection<T> collection, Predicate<T> predicate, T fail) {
        return CollectionUtils.find(collection.stream(), predicate, fail);
    }

    public static <T> T find(Stream<T> stream, Predicate<T> predicate) {
        return CollectionUtils.find(stream, predicate, null);
    }

    public static <T> T find(Stream<T> stream, Predicate<T> predicate, T fail) {
        return stream.filter(predicate).findFirst().orElse(fail);
    }

    public static <T, R> Stream<R> map(T[] array, Function<? super T, ? extends R> mapper) {
        return Arrays.stream(array).map(mapper);
    }

    public static <T, R> Stream<R> map(Collection<T> collection, Function<? super T, ? extends R> mapper) {
        return collection.stream().map(mapper);
    }
}

