/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.util.Comparator;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIObject;
import org.w3c.dom.Element;

public abstract class ValuedAIObject
extends AIObject {
    public static final Comparator<ValuedAIObject> valuedComparator = Comparator.comparingInt(ValuedAIObject::getValue).reversed();
    private int value;

    public ValuedAIObject(AIMain aiMain) {
        super(aiMain);
    }

    public ValuedAIObject(AIMain aiMain, String id) {
        super(aiMain, id);
        this.value = 0;
    }

    public ValuedAIObject(AIMain aiMain, Element element) {
        super(aiMain, element);
    }

    public ValuedAIObject(AIMain aiMain, FreeColXMLReader xr) throws XMLStreamException {
        super(aiMain, xr);
    }

    public final int getValue() {
        return this.value;
    }

    public final void setValue(int newValue) {
        this.value = newValue;
    }

    @Override
    public int compareTo(FreeColObject other) {
        int cmp = 0;
        if (other instanceof ValuedAIObject) {
            ValuedAIObject vao = (ValuedAIObject)other;
            cmp = vao.value - this.value;
        }
        if (cmp == 0) {
            cmp = super.compareTo(other);
        }
        return cmp;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute("value", this.value);
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.setValue(xr.getAttribute("value", -1));
    }
}

