/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.model;

import java.util.List;
import java.util.Random;
import java.util.logging.Logger;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.ProductionInfo;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.server.control.ChangeSet;
import net.sf.freecol.server.model.ServerModelObject;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.model.ServerUnit;

public class ServerBuilding
extends Building
implements ServerModelObject {
    private static final Logger logger = Logger.getLogger(ServerBuilding.class.getName());

    public ServerBuilding(Game game, String id) {
        super(game, id);
    }

    public ServerBuilding(Game game, Colony colony, BuildingType type) {
        super(game, colony, type);
    }

    @Override
    public void csNewTurn(Random random, LogBuilder lb, ChangeSet cs) {
        BuildingType type = this.getType();
        if (this.canTeach()) {
            this.csTeach(cs);
        }
        if (type.hasAbility("model.ability.repairUnits")) {
            this.csRepairUnits(cs);
        }
    }

    private void csTeach(ChangeSet cs) {
        ServerPlayer owner = (ServerPlayer)this.getColony().getOwner();
        for (Unit teacher : this.getUnitList()) {
            Unit student = teacher.getStudent();
            if (student != null && student.getTeacher() != teacher) {
                logger.warning("Bogus teacher/student assignment.");
                teacher.setStudent(null);
                student = null;
            }
            if (student == null && this.csAssignStudent(teacher, cs)) {
                student = teacher.getStudent();
            }
            teacher.setTurnsOfTraining(student == null ? 0 : teacher.getTurnsOfTraining() + 1);
            cs.add(ChangeSet.See.only(owner), teacher);
        }
    }

    public boolean csCheckTeach(Unit teacher, ChangeSet cs) {
        ServerPlayer owner = (ServerPlayer)this.getColony().getOwner();
        Unit student = teacher.getStudent();
        if (student != null && teacher.getTurnsOfTraining() >= teacher.getNeededTurnsOfTraining()) {
            this.csTrainStudent(teacher, student, cs);
            cs.add(ChangeSet.See.only(owner), student);
            if (teacher.getStudent() == null) {
                this.csAssignStudent(teacher, cs);
            }
            return true;
        }
        return false;
    }

    private boolean csTrainStudent(Unit teacher, Unit student, ChangeSet cs) {
        boolean ret;
        ServerPlayer owner = (ServerPlayer)this.getColony().getOwner();
        StringTemplate oldName = student.getLabel();
        UnitType teach = teacher.getType().getSkillTaught();
        UnitType skill = Unit.getUnitTypeTeaching(teach, student.getType());
        boolean bl = ret = skill != null;
        if (skill == null) {
            logger.warning("Student " + student.getId() + " can not learn from " + teacher.getId());
        } else {
            student.changeType(skill);
            StringTemplate newName = student.getLabel();
            cs.addMessage(ChangeSet.See.only(owner), new ModelMessage(ModelMessage.MessageType.UNIT_IMPROVED, "model.building.unitEducated", this.getColony(), (FreeColObject)this).addStringTemplate("%oldName%", oldName).addStringTemplate("%unit%", newName).addName("%colony%", this.getColony().getName()));
        }
        student.setTurnsOfTraining(0);
        student.setMovesLeft(0);
        teacher.setTurnsOfTraining(0);
        teacher.setMovesLeft(0);
        if (!student.canBeStudent(teacher)) {
            student.setTeacher(null);
            teacher.setStudent(null);
        }
        return ret;
    }

    private boolean csAssignStudent(Unit teacher, ChangeSet cs) {
        Colony colony = this.getColony();
        ServerPlayer owner = (ServerPlayer)colony.getOwner();
        Unit student = colony.findStudent(teacher);
        if (student == null) {
            cs.addMessage(ChangeSet.See.only(owner), new ModelMessage(ModelMessage.MessageType.WARNING, "model.building.noStudent", colony, (FreeColObject)teacher).addStringTemplate("%teacher%", teacher.getLabel()).addName("%colony%", colony.getName()));
            return false;
        }
        teacher.setStudent(student);
        teacher.changeWorkType(null);
        student.setTeacher(teacher);
        cs.add(ChangeSet.See.only(owner), student);
        return true;
    }

    private void csRepairUnits(ChangeSet cs) {
        for (Unit unit : this.getTile().getUnitList()) {
            if (!unit.isDamaged() || !this.getType().hasAbility("model.ability.repairUnits", unit.getType())) continue;
            ((ServerUnit)unit).csRepairUnit(cs);
        }
    }

    public void csCheckMissingInput(ProductionInfo pi, ChangeSet cs) {
        List<AbstractGoods> inputs = this.getInputs();
        if (!inputs.isEmpty() && !this.isEmpty() && !this.canAutoProduce() && pi.getProduction().isEmpty()) {
            for (AbstractGoods goods : inputs) {
                cs.addMessage(ChangeSet.See.only((ServerPlayer)this.getOwner()), new ModelMessage(ModelMessage.MessageType.MISSING_GOODS, "model.building.notEnoughInput", this, goods.getType()).addNamed("%inputGoods%", goods.getType()).addNamed("%building%", this).addName("%colony%", this.getColony().getName()));
            }
        }
    }

    @Override
    public String getServerXMLElementTagName() {
        return "serverBuilding";
    }
}

