/*
 * Decompiled with CFR 0.152.
 */
package freemind.extensions;

import freemind.controller.actions.generated.instance.Plugin;
import freemind.controller.actions.generated.instance.PluginAction;
import freemind.controller.actions.generated.instance.PluginMenu;
import freemind.controller.actions.generated.instance.PluginMode;
import freemind.controller.actions.generated.instance.PluginProperty;
import freemind.extensions.HookDescriptorBase;
import freemind.extensions.HookInstanciationMethod;
import freemind.main.FreeMindMain;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;

public class HookDescriptorPluginAction
extends HookDescriptorBase {
    private Properties properties;
    public Vector menuPositions;
    private Vector modes;
    private PluginAction pluginAction;

    public HookDescriptorPluginAction(FreeMindMain frame, String xmlPluginFile, Plugin pluginBase, PluginAction pluginAction) {
        super(pluginBase, frame, xmlPluginFile);
        this.pluginAction = pluginAction;
        if (pluginAction.getName() == null) {
            pluginAction.setName(pluginAction.getLabel());
        }
        this.menuPositions = new Vector();
        this.properties = new Properties();
        this.modes = new Vector();
        for (Object obj : pluginAction.getListChoiceList()) {
            if (obj instanceof PluginMenu) {
                PluginMenu menu = (PluginMenu)obj;
                this.menuPositions.add(menu.getLocation());
            }
            if (obj instanceof PluginProperty) {
                PluginProperty property = (PluginProperty)obj;
                this.properties.put(property.getName(), property.getValue());
            }
            if (!(obj instanceof PluginMode)) continue;
            PluginMode mode = (PluginMode)obj;
            this.modes.add(mode.getClassName());
        }
    }

    public String toString() {
        return "[HookDescriptor props=" + this.properties + ", menu positions=" + this.menuPositions + "]";
    }

    public HookInstanciationMethod getInstanciationMethod() {
        if (this.pluginAction.getInstanciation() != null) {
            HashMap allInstMethods = HookInstanciationMethod.getAllInstanciationMethods();
            for (String name : allInstMethods.keySet()) {
                if (!this.pluginAction.getInstanciation().equalsIgnoreCase(name)) continue;
                return (HookInstanciationMethod)allInstMethods.get(name);
            }
        }
        return HookInstanciationMethod.Other;
    }

    public Vector getModes() {
        return this.modes;
    }

    public String getBaseClass() {
        return this.pluginAction.getBase();
    }

    public String getName() {
        return this.getFromResourceIfNecessary(this.pluginAction.getName());
    }

    public String getClassName() {
        return this.pluginAction.getClassName();
    }

    public String getDocumentation() {
        return this.getFromResourceIfNecessary(this.pluginAction.getDocumentation());
    }

    public String getIconPath() {
        return this.pluginAction.getIconPath();
    }

    public String getKeyStroke() {
        return this.getFromPropertiesIfNecessary(this.pluginAction.getKeyStroke());
    }

    public Properties getProperties() {
        return this.properties;
    }

    public boolean isSelectable() {
        return this.pluginAction.getIsSelectable();
    }
}

