#
# Copyright 2012,2014 Free Software Foundation, Inc.
#
# This file is part of GNU Radio
#
# GNU Radio is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3, or (at your option)
# any later version.
#
# GNU Radio is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with GNU Radio; see the file COPYING.  If not, write to
# the Free Software Foundation, Inc., 51 Franklin Street,
# Boston, MA 02110-1301, USA.
#

'''
Blocks for forward error correction.
'''

from __future__ import absolute_import
from __future__ import unicode_literals

try:
    from .fec_swig import *
except ImportError:
    import os
    dirname, filename = os.path.split(os.path.abspath(__file__))
    __path__.append(os.path.join(dirname, "..", "..", "swig"))
    from .fec_swig import *

from .bitflip import *
from .extended_encoder import extended_encoder
from .extended_decoder import extended_decoder
from .threaded_encoder import threaded_encoder
from .threaded_decoder import threaded_decoder
from .capillary_threaded_decoder import capillary_threaded_decoder
from .capillary_threaded_encoder import capillary_threaded_encoder
from .extended_async_encoder import extended_async_encoder
from .extended_tagged_encoder import extended_tagged_encoder
from .extended_tagged_decoder import extended_tagged_decoder


from .fec_test import fec_test
from .bercurve_generator import bercurve_generator
