/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.estimate.jama;

import tim.prune.function.estimate.jama.Maths;
import tim.prune.function.estimate.jama.Matrix;

public class QRDecomposition {
    private double[][] _QR;
    private int _m;
    private int _n;
    private double[] _Rdiag;

    public QRDecomposition(Matrix matrix) {
        this._QR = matrix.getArrayCopy();
        this._m = matrix.getNumRows();
        this._n = matrix.getNumColumns();
        this._Rdiag = new double[this._n];
        int n = 0;
        while (n < this._n) {
            double d = 0.0;
            int n2 = n;
            while (n2 < this._m) {
                d = Maths.pythag(d, this._QR[n2][n]);
                ++n2;
            }
            if (d != 0.0) {
                if (this._QR[n][n] < 0.0) {
                    d = -d;
                }
                n2 = n;
                while (n2 < this._m) {
                    double[] dArray = this._QR[n2];
                    int n3 = n;
                    dArray[n3] = dArray[n3] / d;
                    ++n2;
                }
                double[] dArray = this._QR[n];
                int n4 = n;
                dArray[n4] = dArray[n4] + 1.0;
                n2 = n + 1;
                while (n2 < this._n) {
                    double d2 = 0.0;
                    int n5 = n;
                    while (n5 < this._m) {
                        d2 += this._QR[n5][n] * this._QR[n5][n2];
                        ++n5;
                    }
                    d2 = -d2 / this._QR[n][n];
                    n5 = n;
                    while (n5 < this._m) {
                        double[] dArray2 = this._QR[n5];
                        int n6 = n2;
                        dArray2[n6] = dArray2[n6] + d2 * this._QR[n5][n];
                        ++n5;
                    }
                    ++n2;
                }
            }
            this._Rdiag[n] = -d;
            ++n;
        }
    }

    public boolean isFullRank() {
        int n = 0;
        while (n < this._n) {
            if (this._Rdiag[n] == 0.0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public Matrix solve(Matrix matrix) {
        int n;
        if (matrix.getNumRows() != this._m) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.isFullRank()) {
            throw new RuntimeException("Matrix is rank deficient.");
        }
        int n2 = matrix.getNumColumns();
        double[][] dArray = matrix.getArrayCopy();
        int n3 = 0;
        while (n3 < this._n) {
            n = 0;
            while (n < n2) {
                double d = 0.0;
                int n4 = n3;
                while (n4 < this._m) {
                    d += this._QR[n4][n3] * dArray[n4][n];
                    ++n4;
                }
                d = -d / this._QR[n3][n3];
                n4 = n3;
                while (n4 < this._m) {
                    double[] dArray2 = dArray[n4];
                    int n5 = n;
                    dArray2[n5] = dArray2[n5] + d * this._QR[n4][n3];
                    ++n4;
                }
                ++n;
            }
            ++n3;
        }
        n3 = this._n - 1;
        while (n3 >= 0) {
            n = 0;
            while (n < n2) {
                double[] dArray3 = dArray[n3];
                int n6 = n++;
                dArray3[n6] = dArray3[n6] / this._Rdiag[n3];
            }
            n = 0;
            while (n < n3) {
                int n7 = 0;
                while (n7 < n2) {
                    double[] dArray4 = dArray[n];
                    int n8 = n7;
                    dArray4[n8] = dArray4[n8] - dArray[n3][n7] * this._QR[n][n3];
                    ++n7;
                }
                ++n;
            }
            --n3;
        }
        return new Matrix(dArray, this._n, n2).getMatrix(0, this._n - 1, 0, n2 - 1);
    }
}

