/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.io.scan;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.io.scan.AnnotatedTypeInfoVisitor;
import io.micronaut.core.io.scan.AnnotationClassReader;
import io.micronaut.core.io.scan.AnnotationScanner;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarFile;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class ClassPathAnnotationScanner
implements AnnotationScanner {
    private static final Logger LOG = LoggerFactory.getLogger(ClassPathAnnotationScanner.class);
    private final ClassLoader classLoader;
    private boolean includeJars;

    public ClassPathAnnotationScanner(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.includeJars = true;
    }

    public ClassPathAnnotationScanner() {
        this(ClassPathAnnotationScanner.class.getClassLoader());
    }

    protected ClassPathAnnotationScanner includeJars(boolean includeJars) {
        this.includeJars = includeJars;
        return this;
    }

    @Override
    public Stream<Class> scan(String annotation, String pkg) {
        if (pkg == null) {
            return Stream.empty();
        }
        List<Class> classes = this.doScan(annotation, pkg);
        return classes.stream();
    }

    protected List<Class> doScan(String annotation, String pkg) {
        try {
            String packagePath = pkg.replace('.', '/').concat("/");
            ArrayList<Class> classes = new ArrayList<Class>();
            Enumeration<URL> resources = this.classLoader.getResources(packagePath);
            if (!resources.hasMoreElements() && LOG.isDebugEnabled()) {
                LOG.debug("No resources found under package path: {}", (Object)packagePath);
            }
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                String protocol = url.getProtocol();
                if ("file".equals(protocol)) {
                    try {
                        File file = new File(url.toURI());
                        this.traverseFile(annotation, classes, file);
                    }
                    catch (URISyntaxException e) {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("Ignoring file [" + url + "] due to URI error: " + e.getMessage(), (Throwable)e);
                    }
                    continue;
                }
                if (!this.includeJars || !Arrays.asList("jar", "zip", "war").contains(protocol)) continue;
                URLConnection con = url.openConnection();
                if (con instanceof JarURLConnection) {
                    JarURLConnection jarCon = (JarURLConnection)con;
                    JarFile jarFile = jarCon.getJarFile();
                    jarFile.stream().filter(entry -> {
                        String name = entry.getName();
                        return name.startsWith(packagePath) && name.endsWith(".class") && name.indexOf(36) == -1;
                    }).forEach(entry -> {
                        block16: {
                            try (InputStream inputStream = jarFile.getInputStream((ZipEntry)entry);){
                                this.scanInputStream(annotation, inputStream, classes);
                            }
                            catch (IOException e) {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("Ignoring JAR entry [" + entry.getName() + "] due to I/O error: " + e.getMessage(), (Throwable)e);
                                }
                            }
                            catch (ClassNotFoundException e) {
                                if (!LOG.isDebugEnabled()) break block16;
                                LOG.debug("Ignoring JAR entry [" + entry.getName() + "]. Class not found: " + e.getMessage(), (Throwable)e);
                            }
                        }
                    });
                    continue;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Ignoring JAR URI entry [" + url + "]. No JarURLConnection found.");
            }
            return classes;
        }
        catch (IOException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Ignoring I/O Exception scanning package: " + pkg, (Throwable)e);
            }
            return Collections.emptyList();
        }
    }

    protected void traverseFile(String annotation, List<Class> classes, File file) {
        block16: {
            if (file.isDirectory()) {
                try (DirectoryStream<Path> dirs = Files.newDirectoryStream(file.toPath());){
                    dirs.forEach(path -> {
                        File f = path.toFile();
                        if (f.isDirectory()) {
                            this.traverseFile(annotation, classes, f);
                        } else {
                            this.scanFile(annotation, f, classes);
                        }
                    });
                    break block16;
                }
                catch (IOException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Ignoring directory [" + file + "] due to I/O error: " + e.getMessage(), (Throwable)e);
                    }
                    break block16;
                }
            }
            this.scanFile(annotation, file, classes);
        }
    }

    protected void scanFile(String annotation, File file, List<Class> classes) {
        block17: {
            String fileName = file.getName();
            if (fileName.endsWith(".class") && fileName.indexOf(36) == -1) {
                try (InputStream inputStream = Files.newInputStream(file.toPath(), new OpenOption[0]);){
                    this.scanInputStream(annotation, inputStream, classes);
                }
                catch (IOException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Ignoring file [" + file.getName() + "] due to I/O error: " + e.getMessage(), (Throwable)e);
                    }
                }
                catch (ClassNotFoundException e) {
                    if (!LOG.isDebugEnabled()) break block17;
                    LOG.debug("Ignoring file [" + file.getName() + "]. Class not found: " + e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private void scanInputStream(String annotation, InputStream inputStream, List<Class> classes) throws IOException, ClassNotFoundException {
        AnnotationClassReader annotationClassReader = new AnnotationClassReader(inputStream);
        AnnotatedTypeInfoVisitor classVisitor = new AnnotatedTypeInfoVisitor();
        annotationClassReader.accept(classVisitor, 2);
        if (classVisitor.hasAnnotation(annotation)) {
            classes.add(this.classLoader.loadClass(classVisitor.getTypeName()));
        }
    }
}

