/*
 * Decompiled with CFR 0.152.
 */
package org.grails.encoder;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.grails.charsequences.CharSequences;
import org.grails.encoder.ChainedEncoder;
import org.grails.encoder.ChainedEncoders;
import org.grails.encoder.DefaultEncodingStateRegistry;
import org.grails.encoder.Encoder;
import org.grails.encoder.EncodesToWriter;
import org.grails.encoder.EncodingState;
import org.grails.encoder.EncodingStateImpl;
import org.grails.encoder.StreamingEncoder;
import org.grails.encoder.WriterEncodedAppender;

public class EncodesToWriterAdapter
implements EncodesToWriter {
    private final StreamingEncoder encoder;
    private boolean ignoreEncodingState;

    public EncodesToWriterAdapter(StreamingEncoder encoder) {
        this(encoder, false);
    }

    public EncodesToWriterAdapter(StreamingEncoder encoder, boolean ignoreEncodingState) {
        this.encoder = encoder;
        this.ignoreEncodingState = ignoreEncodingState;
    }

    @Override
    public void encodeToWriter(CharSequence str, int off, int len, Writer writer, EncodingState encodingState) throws IOException {
        if (this.shouldEncodeWith(this.encoder, encodingState)) {
            this.encoder.encodeToStream(this.encoder, str, off, len, new WriterEncodedAppender(writer), this.createNewEncodingState(this.encoder, encodingState));
        } else {
            CharSequences.writeCharSequence(writer, str, off, len);
        }
    }

    @Override
    public void encodeToWriter(char[] buf, int off, int len, Writer writer, EncodingState encodingState) throws IOException {
        if (this.shouldEncodeWith(this.encoder, encodingState)) {
            this.encoder.encodeToStream(this.encoder, CharSequences.createCharSequence(buf, off, len), 0, len, new WriterEncodedAppender(writer), this.createNewEncodingState(this.encoder, encodingState));
        } else {
            writer.write(buf, off, len);
        }
    }

    protected EncodingState createNewEncodingState(Encoder encoder, EncodingState encodingState) {
        if (encodingState == null) {
            return new EncodingStateImpl(encoder, null);
        }
        return encodingState.appendEncoder(encoder);
    }

    protected boolean shouldEncodeWith(Encoder encoderToApply, EncodingState encodingState) {
        return this.ignoreEncodingState || encodingState == null || DefaultEncodingStateRegistry.shouldEncodeWith(encoderToApply, encodingState);
    }

    public StreamingEncoder getStreamingEncoder() {
        return this.encoder;
    }

    public boolean isIgnoreEncodingState() {
        return this.ignoreEncodingState;
    }

    public void setIgnoreEncodingState(boolean ignoreEncodingState) {
        this.ignoreEncodingState = ignoreEncodingState;
    }

    @Override
    public EncodesToWriter createChainingEncodesToWriter(List<StreamingEncoder> additionalEncoders, boolean applyAdditionalFirst) {
        EncodesToWriterAdapter chained = EncodesToWriterAdapter.createChainingEncodesToWriter(this.getStreamingEncoder(), additionalEncoders, applyAdditionalFirst);
        chained.setIgnoreEncodingState(this.isIgnoreEncodingState());
        return chained;
    }

    public static EncodesToWriterAdapter createChainingEncodesToWriter(StreamingEncoder baseEncoder, List<StreamingEncoder> additionalEncoders, boolean applyAdditionalFirst) {
        boolean baseEncoderShouldBeApplied = ChainedEncoders.shouldApplyEncoder(baseEncoder);
        ArrayList<StreamingEncoder> allEncoders = new ArrayList<StreamingEncoder>(additionalEncoders.size() + 1);
        if (!applyAdditionalFirst && baseEncoderShouldBeApplied) {
            allEncoders.add(baseEncoder);
        }
        for (StreamingEncoder additional : additionalEncoders) {
            if (!ChainedEncoders.shouldApplyEncoder(additional)) continue;
            allEncoders.add(additional);
        }
        if (applyAdditionalFirst && baseEncoderShouldBeApplied) {
            allEncoders.add(baseEncoder);
        }
        return new EncodesToWriterAdapter(ChainedEncoder.createFor(allEncoders));
    }
}

