/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.connector.basic;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.aether.spi.log.Logger;

final class PartialFile
implements Closeable {
    static final String EXT_PART = ".part";
    static final String EXT_LOCK = ".lock";
    private final File partFile;
    private final LockFile lockFile;
    private final long threshold;
    private final Logger logger;

    private PartialFile(File partFile, Logger logger) {
        this(partFile, null, 0L, logger);
    }

    private PartialFile(File partFile, LockFile lockFile, long threshold, Logger logger) {
        this.partFile = partFile;
        this.lockFile = lockFile;
        this.threshold = threshold;
        this.logger = logger;
    }

    public File getFile() {
        return this.partFile;
    }

    public boolean isResume() {
        return this.lockFile != null && this.partFile.length() >= this.threshold;
    }

    @Override
    public void close() throws IOException {
        if (this.partFile.exists() && !this.isResume() && !this.partFile.delete() && this.partFile.exists()) {
            this.logger.debug("Could not delete temorary file " + this.partFile);
        }
        if (this.lockFile != null) {
            this.lockFile.close();
        }
    }

    public String toString() {
        return String.valueOf(this.getFile());
    }

    static class Factory {
        private final boolean resume;
        private final long resumeThreshold;
        private final int requestTimeout;
        private final Logger logger;

        Factory(boolean resume, long resumeThreshold, int requestTimeout, Logger logger) {
            this.resume = resume;
            this.resumeThreshold = resumeThreshold;
            this.requestTimeout = requestTimeout;
            this.logger = logger;
        }

        public PartialFile newInstance(File dstFile, RemoteAccessChecker checker) throws Exception {
            if (this.resume) {
                File partFile = new File(dstFile.getPath() + PartialFile.EXT_PART);
                long reqTimestamp = System.currentTimeMillis();
                LockFile lockFile = new LockFile(partFile, this.requestTimeout, checker, this.logger);
                if (lockFile.isConcurrent() && dstFile.lastModified() >= reqTimestamp - 100L) {
                    lockFile.close();
                    return null;
                }
                try {
                    if (!partFile.createNewFile() && !partFile.isFile()) {
                        throw new IOException(partFile.exists() ? "Path exists but is not a file" : "Unknown error");
                    }
                    return new PartialFile(partFile, lockFile, this.resumeThreshold, this.logger);
                }
                catch (IOException e) {
                    lockFile.close();
                    this.logger.debug("Cannot create resumable file " + partFile.getAbsolutePath() + ": " + e);
                }
            }
            File tempFile = File.createTempFile(dstFile.getName() + '-' + UUID.randomUUID().toString().replace("-", ""), ".tmp", dstFile.getParentFile());
            return new PartialFile(tempFile, this.logger);
        }
    }

    static class LockFile {
        private final File lockFile;
        private final FileLock lock;
        private final AtomicBoolean concurrent;

        LockFile(File partFile, int requestTimeout, RemoteAccessChecker checker, Logger logger) throws Exception {
            this.lockFile = new File(partFile.getPath() + PartialFile.EXT_LOCK);
            this.concurrent = new AtomicBoolean(false);
            this.lock = LockFile.lock(this.lockFile, partFile, requestTimeout, checker, logger, this.concurrent);
        }

        private static FileLock lock(File lockFile, File partFile, int requestTimeout, RemoteAccessChecker checker, Logger logger, AtomicBoolean concurrent) throws Exception {
            boolean interrupted = false;
            try {
                long lastLength = -1L;
                long lastTime = 0L;
                while (true) {
                    FileLock lock;
                    if ((lock = LockFile.tryLock(lockFile)) != null) {
                        FileLock fileLock = lock;
                        return fileLock;
                    }
                    long currentLength = partFile.length();
                    long currentTime = System.currentTimeMillis();
                    if (currentLength != lastLength) {
                        if (lastLength < 0L) {
                            concurrent.set(true);
                            checker.checkRemoteAccess();
                            logger.debug("Concurrent download of " + partFile + " in progress, awaiting completion");
                        }
                        lastLength = currentLength;
                        lastTime = currentTime;
                    } else if (requestTimeout > 0 && currentTime - lastTime > (long)Math.max(requestTimeout, 3000)) {
                        throw new IOException("Timeout while waiting for concurrent download of " + partFile + " to progress");
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                    }
                }
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        private static FileLock tryLock(File lockFile) throws IOException {
            RandomAccessFile raf = null;
            FileLock lock = null;
            try {
                raf = new RandomAccessFile(lockFile, "rw");
                lock = raf.getChannel().tryLock(0L, 1L, false);
                if (lock == null) {
                    raf.close();
                    raf = null;
                }
            }
            catch (OverlappingFileLockException e) {
                LockFile.close(raf);
                raf = null;
                lock = null;
            }
            catch (RuntimeException e) {
                LockFile.close(raf);
                raf = null;
                if (!lockFile.delete()) {
                    lockFile.deleteOnExit();
                }
                throw e;
            }
            catch (IOException e) {
                LockFile.close(raf);
                raf = null;
                if (!lockFile.delete()) {
                    lockFile.deleteOnExit();
                }
                throw e;
            }
            finally {
                try {
                    if (lock == null && raf != null) {
                        raf.close();
                    }
                }
                catch (IOException e) {}
            }
            return lock;
        }

        private static void close(Closeable file) {
            try {
                if (file != null) {
                    file.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public boolean isConcurrent() {
            return this.concurrent.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            FileChannel channel = null;
            try {
                channel = this.lock.channel();
                this.lock.release();
                channel.close();
                channel = null;
            }
            finally {
                try {
                    if (channel != null) {
                        channel.close();
                    }
                }
                catch (IOException iOException) {
                }
                finally {
                    if (!this.lockFile.delete()) {
                        this.lockFile.deleteOnExit();
                    }
                }
            }
        }

        public String toString() {
            return this.lockFile + " - " + this.lock.isValid();
        }
    }

    static interface RemoteAccessChecker {
        public void checkRemoteAccess() throws Exception;
    }
}

