/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.reflect;

import java.beans.Introspector;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.codehaus.groovy.runtime.MetaClassHelper;

public class NameUtils {
    private static final String PROPERTY_SET_PREFIX = "set";
    private static final String PROPERTY_GET_PREFIX = "get";
    private static final String PROPERTY_IS_PREFIX = "is";
    private static final Set<String> CONFIGURATIONAL_PROPERTIES;
    public static final String DOLLAR_SEPARATOR = "$";

    public static boolean isConfigurational(String name) {
        return CONFIGURATIONAL_PROPERTIES.contains(name);
    }

    public static boolean isNotConfigurational(String name) {
        return !NameUtils.isConfigurational(name);
    }

    public static String getSetterName(String propertyName) {
        return PROPERTY_SET_PREFIX + NameUtils.capitalize(propertyName);
    }

    public static String getGetterName(String propertyName) {
        return NameUtils.getGetterName(propertyName, false);
    }

    public static String getGetterName(String propertyName, boolean useBooleanPrefix) {
        String prefix = useBooleanPrefix ? PROPERTY_IS_PREFIX : PROPERTY_GET_PREFIX;
        return prefix + NameUtils.capitalize(propertyName);
    }

    public static String getClassName(Class clazz) {
        String sn = clazz.getSimpleName();
        if (sn.contains(DOLLAR_SEPARATOR)) {
            return clazz.getSuperclass().getName();
        }
        return clazz.getName();
    }

    public static String getPropertyNameForGetterOrSetter(String getterOrSetterName) {
        if (getterOrSetterName == null || getterOrSetterName.length() == 0) {
            return null;
        }
        if (getterOrSetterName.startsWith(PROPERTY_GET_PREFIX) || getterOrSetterName.startsWith(PROPERTY_SET_PREFIX)) {
            return NameUtils.decapitalize(getterOrSetterName.substring(3));
        }
        if (getterOrSetterName.startsWith(PROPERTY_IS_PREFIX)) {
            return NameUtils.decapitalize(getterOrSetterName.substring(2));
        }
        return null;
    }

    public static String decapitalize(String name) {
        return Introspector.decapitalize(name);
    }

    public static String decapitalizeFirstChar(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    public static String capitalize(String name) {
        return MetaClassHelper.capitalize((String)name);
    }

    static {
        HashSet<String> configurational = new HashSet<String>(Arrays.asList("metaClass", "class", "transients", "attached", "dirty", "dirtyPropertyNames", "hasMany", "constraints", "mapWith", "mappedBy", "belongsTo", "errors", "transactionManager", "dataSource", "sessionFactory", "messageSource", "applicationContext", "properties"));
        CONFIGURATIONAL_PROPERTIES = Collections.unmodifiableSet(configurational);
    }
}

