/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.services;

import groovy.transform.Internal;
import java.util.Optional;
import java.util.ServiceConfigurationError;
import java.util.function.Supplier;
import org.grails.datastore.mapping.services.ServiceDefinition;

@Internal
class DefaultServiceDefinition<S>
implements ServiceDefinition<S> {
    private final String name;
    private final Optional<Class<S>> loadedClass;

    DefaultServiceDefinition(String name, Optional<Class<S>> loadedClass) {
        this.name = name;
        this.loadedClass = loadedClass;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<S> getType() {
        return this.loadedClass.orElseThrow(() -> new ServiceConfigurationError("Call to load() when class '" + this.name + "' is not present"));
    }

    @Override
    public boolean isPresent() {
        return this.loadedClass.isPresent();
    }

    @Override
    public <X extends Throwable> S orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        Class<S> type = this.loadedClass.orElseThrow(exceptionSupplier);
        try {
            return type.newInstance();
        }
        catch (Throwable e) {
            throw (Throwable)exceptionSupplier.get();
        }
    }

    @Override
    public S load() {
        return (S)this.loadedClass.map(aClass -> {
            try {
                return aClass.newInstance();
            }
            catch (Throwable e) {
                throw new ServiceConfigurationError("Error loading service [" + aClass.getName() + "]: " + e.getMessage(), e);
            }
        }).orElseThrow(() -> new ServiceConfigurationError("Call to load() when class '" + this.name + "' is not present"));
    }
}

