/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.validation;

import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.validation.ValidatorRegistry;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.support.StaticMessageSource;
import org.springframework.validation.Validator;

public class BeanFactoryValidatorRegistry
implements ValidatorRegistry {
    private final BeanFactory beanFactory;

    public BeanFactoryValidatorRegistry(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Override
    public Validator getValidator(PersistentEntity entity) {
        String validatorName = entity.getName() + "Validator";
        if (this.beanFactory.containsBean(validatorName)) {
            return (Validator)this.beanFactory.getBean(validatorName, Validator.class);
        }
        return null;
    }

    @Override
    public MessageSource getMessageSource() {
        if (this.beanFactory instanceof MessageSource) {
            return (MessageSource)this.beanFactory;
        }
        return new StaticMessageSource();
    }
}

