/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bsf.engines.xslt;

import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.Vector;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.bsf.BSFDeclaredBean;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.apache.bsf.engines.xslt.XSLTResultNode;
import org.apache.bsf.util.BSFEngineImpl;
import org.apache.bsf.util.BSFFunctions;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.Node;

public class XSLTEngine
extends BSFEngineImpl {
    TransformerFactory tFactory;
    Transformer transformer;
    Log logger = LogFactory.getLog((String)this.getClass().getName());

    public Object call(Object object, String method, Object[] args) throws BSFException {
        throw new BSFException(499, "BSF:XSLTEngine can't call methods");
    }

    public void declareBean(BSFDeclaredBean bean) throws BSFException {
        this.transformer.setParameter(bean.name, new XObject(bean.bean));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object eval(String source, int lineNo, int columnNo, Object oscript) throws BSFException {
        Source xis;
        block16: {
            block17: {
                Object sbObj = this.mgr.lookupBean("xslt:styleBaseURI");
                String styleBaseURI = sbObj == null ? "." : sbObj.toString();
                StreamSource styleSource = new StreamSource(new StringReader(oscript.toString()));
                styleSource.setSystemId(styleBaseURI);
                try {
                    this.transformer = this.tFactory.newTransformer(styleSource);
                }
                catch (Exception e) {
                    this.logger.error((Object)"Exception from Xerces XSLT:", (Throwable)e);
                    throw new BSFException(100, "Exception from Xerces XSLT: " + e, e);
                }
                Object srcObj = this.mgr.lookupBean("xslt:src");
                xis = null;
                if (srcObj == null) break block17;
                if (srcObj instanceof Node) {
                    xis = new DOMSource((Node)srcObj);
                    break block16;
                } else {
                    try {
                        String mesg = "as anything";
                        if (srcObj instanceof Reader) {
                            xis = new StreamSource((Reader)srcObj);
                            mesg = "as a Reader";
                        } else if (srcObj instanceof File) {
                            xis = new StreamSource((File)srcObj);
                            mesg = "as a file";
                        } else {
                            String srcObjstr = srcObj.toString();
                            xis = new StreamSource(new StringReader(srcObjstr));
                            if (srcObj instanceof URL) {
                                mesg = "as a URL";
                            } else {
                                ((StreamSource)xis).setPublicId(srcObjstr);
                                mesg = "as an XML string";
                            }
                        }
                        if (xis == null) {
                            throw new Exception("Unable to get input from '" + srcObj + "' " + mesg);
                        }
                        break block16;
                    }
                    catch (Exception e) {
                        throw new BSFException(100, "BSF:XSLTEngine: unable to get input from '" + srcObj + "' as XML", e);
                    }
                }
            }
            xis = new StreamSource();
        }
        for (int i = 0; i < this.declaredBeans.size(); ++i) {
            BSFDeclaredBean b = (BSFDeclaredBean)this.declaredBeans.elementAt(i);
            this.transformer.setParameter(b.name, new XObject(b.bean));
        }
        this.transformer.setParameter("bsf", new XObject((Object)new BSFFunctions(this.mgr, this)));
        try {
            DOMResult result = new DOMResult();
            this.transformer.transform((StreamSource)xis, result);
            return new XSLTResultNode(result.getNode());
        }
        catch (Exception e) {
            throw new BSFException(100, "exception while eval'ing XSLT script" + e, e);
        }
    }

    public void initialize(BSFManager mgr, String lang, Vector declaredBeans) throws BSFException {
        super.initialize(mgr, lang, declaredBeans);
        this.tFactory = TransformerFactory.newInstance();
    }

    public void undeclareBean(BSFDeclaredBean bean) throws BSFException {
        if (this.transformer.getParameter(bean.name) != null) {
            this.transformer.setParameter(bean.name, null);
        }
    }
}

