"use strict";
/* IMPORT */
Object.defineProperty(exports, "__esModule", { value: true });
var types_1 = require("../types");
var hex_1 = require("./hex");
var keyword_1 = require("./keyword");
var rgb_1 = require("./rgb");
var hsl_1 = require("./hsl");
/* COLOR */
var Color = {
    /* VARIABLES */
    format: {
        keyword: keyword_1.default,
        hex: hex_1.default,
        rgb: rgb_1.default,
        rgba: rgb_1.default,
        hsl: hsl_1.default,
        hsla: hsl_1.default
    },
    /* CONVERSION API */
    toKeyword: function (color) {
        return keyword_1.default.stringify(Color.parse(color));
    },
    toHex: function (color) {
        return hex_1.default.stringify(Color.parse(color));
    },
    toRgba: function (color) {
        return rgb_1.default.stringify(Color.parse(color));
    },
    toHsla: function (color) {
        return hsl_1.default.stringify(Color.parse(color));
    },
    /* API */
    parse: function (color) {
        if (typeof color !== 'string')
            return color;
        var channels = hex_1.default.parse(color) || rgb_1.default.parse(color) || hsl_1.default.parse(color) || keyword_1.default.parse(color); // Color providers ordered with performance in mind
        if (channels)
            return channels;
        throw new Error("Unsupported color format: \"" + color + "\"");
    },
    stringify: function (channels) {
        // SASS returns a keyword if possible, but we avoid doing that as it's slower and doesn't really add any value
        if (!channels.changed && channels.color)
            return channels.color;
        if (channels.type.is(types_1.TYPE.HSL) || channels.data.r === undefined) {
            return hsl_1.default.stringify(channels);
        }
        else if (channels.a < 1 || !Number.isInteger(channels.r) || !Number.isInteger(channels.g) || !Number.isInteger(channels.b)) {
            return rgb_1.default.stringify(channels);
        }
        else {
            return hex_1.default.stringify(channels);
        }
    }
};
/* EXPORT */
exports.default = Color;
