"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _writableTrackingBuffer = _interopRequireDefault(require("./tracking-buffer/writable-tracking-buffer"));

var _allHeaders = require("./all-headers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
  s2.2.6.6
 */
class SqlBatchPayload {
  constructor(sqlText, txnDescriptor, options) {
    this.sqlText = void 0;
    this.txnDescriptor = void 0;
    this.options = void 0;
    this.sqlText = sqlText;
    this.txnDescriptor = txnDescriptor;
    this.options = options;
  }

  getData(cb) {
    const buffer = new _writableTrackingBuffer.default(100 + 2 * this.sqlText.length, 'ucs2');

    if (this.options.tdsVersion >= '7_2') {
      const outstandingRequestCount = 1;
      (0, _allHeaders.writeToTrackingBuffer)(buffer, this.txnDescriptor, outstandingRequestCount);
    }

    buffer.writeString(this.sqlText, 'ucs2');
    cb(buffer.data);
  }

  toString(indent = '') {
    return indent + ('SQL Batch - ' + this.sqlText);
  }

}

var _default = SqlBatchPayload;
exports.default = _default;
module.exports = SqlBatchPayload;