/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import org.gjt.sp.jedit.ActionSet;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.options.ToolBarOptionPane;
import org.gjt.sp.util.GenericGUIUtilities;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;

class ToolBarEditDialog
extends EnhancedDialog {
    private boolean isOK;
    private final JRadioButton separator;
    private final JRadioButton action;
    private final JComboBox<ActionSet> combo;
    private final JList<ToolBarOptionPane.Button> list;
    private final JRadioButton builtin;
    private final JComboBox<ToolBarOptionPane.IconListEntry> builtinCombo;
    private final JRadioButton file;
    private final JButton fileButton;
    private String fileIcon;

    ToolBarEditDialog(Component component, DefaultComboBoxModel<ToolBarOptionPane.IconListEntry> defaultComboBoxModel, ToolBarOptionPane.Button button) {
        super(GenericGUIUtilities.getParentDialog(component), jEdit.getProperty("options.toolbar.edit.title"), true);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setContentPane(jPanel);
        ButtonGroup buttonGroup = new ButtonGroup();
        JPanel jPanel2 = new JPanel(new GridLayout(3, 1, 6, 6));
        jPanel2.setBorder(new EmptyBorder(0, 0, 6, 0));
        jPanel2.add(new JLabel(jEdit.getProperty("options.toolbar.edit.caption")));
        this.separator = new JRadioButton(jEdit.getProperty("options.toolbar.edit.separator"));
        this.separator.addActionListener(actionEvent -> this.updateEnabled());
        buttonGroup.add(this.separator);
        jPanel2.add(this.separator);
        this.action = new JRadioButton(jEdit.getProperty("options.toolbar.edit.action"));
        this.action.addActionListener(actionEvent -> this.updateEnabled());
        buttonGroup.add(this.action);
        jPanel2.add(this.action);
        jPanel.add("North", jPanel2);
        JPanel jPanel3 = new JPanel(new BorderLayout(6, 6));
        ActionSet[] actionSetArray = jEdit.getActionSets();
        String string = jEdit.getProperty("options.toolbar.selectedActionSet");
        ActionSet actionSet3 = null;
        Vector<ActionSet> vector = new Vector<ActionSet>(actionSetArray.length);
        for (ActionSet object2 : actionSetArray) {
            if (object2.getActionCount() == 0) continue;
            vector.add(object2);
            if (!object2.getLabel().equals(string)) continue;
            actionSet3 = object2;
        }
        vector.sort((actionSet, actionSet2) -> StandardUtilities.compareStrings(actionSet.getLabel(), actionSet2.getLabel(), false));
        this.combo = new JComboBox(vector);
        if (actionSet3 != null) {
            this.combo.setSelectedItem(actionSet3);
        } else {
            jEdit.unsetProperty("options.toolbar.selectedActionSet");
        }
        this.combo.addActionListener(actionEvent -> this.updateList());
        jPanel3.add("North", this.combo);
        this.list = new JList();
        this.list.setVisibleRowCount(8);
        this.list.setSelectionMode(0);
        jPanel3.add("Center", new JScrollPane(this.list));
        JPanel jPanel4 = new JPanel(new BorderLayout(0, 3));
        JPanel jPanel5 = new JPanel(new GridLayout(2, 1));
        jPanel5.setBorder(new EmptyBorder(0, 0, 0, 12));
        JPanel jPanel6 = new JPanel(new GridLayout(2, 1));
        buttonGroup = new ButtonGroup();
        this.builtin = new JRadioButton(jEdit.getProperty("options.toolbar.edit.builtin"));
        jPanel5.add(this.builtin);
        this.builtin.addActionListener(actionEvent -> this.updateEnabled());
        buttonGroup.add(this.builtin);
        this.file = new JRadioButton(jEdit.getProperty("options.toolbar.edit.file"));
        jPanel5.add(this.file);
        buttonGroup.add(this.file);
        this.file.addActionListener(actionEvent -> this.updateEnabled());
        jPanel4.add("West", jPanel5);
        this.builtinCombo = new JComboBox<ToolBarOptionPane.IconListEntry>(defaultComboBoxModel);
        this.builtinCombo.setRenderer(new ToolBarOptionPane.IconCellRenderer());
        jPanel6.add(this.builtinCombo);
        this.fileButton = new JButton(jEdit.getProperty("options.toolbar.edit.no-icon"));
        this.fileButton.setMargin(new Insets(1, 1, 1, 1));
        this.fileButton.setIcon(GUIUtilities.loadIcon("Blank24.gif"));
        this.fileButton.setHorizontalAlignment(2);
        this.fileButton.addActionListener(actionEvent -> this.browseIcon());
        jPanel6.add(this.fileButton);
        jPanel4.add("Center", jPanel6);
        jPanel3.add("South", jPanel4);
        jPanel.add("Center", jPanel3);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BoxLayout(jPanel7, 0));
        jPanel7.setBorder(new EmptyBorder(17, 0, 0, 0));
        JButton jButton = new JButton(jEdit.getProperty("common.ok"));
        jButton.addActionListener(actionEvent -> this.ok());
        this.getRootPane().setDefaultButton(jButton);
        JButton jButton2 = new JButton(jEdit.getProperty("common.cancel"));
        jButton2.addActionListener(actionEvent -> this.cancel());
        GenericGUIUtilities.makeSameSize(jButton, jButton2);
        jPanel7.add(Box.createGlue());
        jPanel7.add(jButton);
        jPanel7.add(Box.createHorizontalStrut(6));
        jPanel7.add(jButton2);
        jPanel.add("South", jPanel7);
        if (button == null) {
            this.action.setSelected(true);
            this.builtin.setSelected(true);
            this.updateList();
        } else if ("-".equals(button.actionName)) {
            this.separator.setSelected(true);
            this.builtin.setSelected(true);
        } else {
            this.action.setSelected(true);
            ActionSet actionSet4 = jEdit.getActionSetForAction(button.actionName);
            this.combo.setSelectedItem(actionSet4);
            this.updateList();
            this.list.setSelectedValue(button, true);
            if (MiscUtilities.isURL(button.iconName)) {
                this.file.setSelected(true);
                this.fileIcon = button.iconName;
                try {
                    this.fileButton.setIcon(new ImageIcon(new URL(this.fileIcon)));
                }
                catch (MalformedURLException comboBoxModel) {
                    Log.log(9, this, comboBoxModel);
                }
                this.fileButton.setText(MiscUtilities.getFileName(this.fileIcon));
            } else {
                this.builtin.setSelected(true);
                ComboBoxModel<ToolBarOptionPane.IconListEntry> comboBoxModel = this.builtinCombo.getModel();
                for (int i = 0; i < comboBoxModel.getSize(); ++i) {
                    ToolBarOptionPane.IconListEntry iconListEntry = (ToolBarOptionPane.IconListEntry)comboBoxModel.getElementAt(i);
                    if (!iconListEntry.name.equals(button.iconName)) continue;
                    this.builtinCombo.setSelectedIndex(i);
                    break;
                }
            }
        }
        this.updateEnabled();
        this.pack();
        this.setLocationRelativeTo(GenericGUIUtilities.getParentDialog(component));
        this.setVisible(true);
    }

    @Override
    public void ok() {
        this.isOK = true;
        this.dispose();
    }

    @Override
    public void cancel() {
        this.dispose();
    }

    public ToolBarOptionPane.Button getSelection() {
        String string;
        Icon icon;
        Object object;
        if (!this.isOK) {
            return null;
        }
        if (this.separator.isSelected()) {
            return new ToolBarOptionPane.Button("-", null, null, "-");
        }
        if (this.builtin.isSelected()) {
            object = (ToolBarOptionPane.IconListEntry)this.builtinCombo.getSelectedItem();
            icon = ((ToolBarOptionPane.IconListEntry)object).icon;
            string = ((ToolBarOptionPane.IconListEntry)object).name;
        } else {
            icon = this.fileButton.getIcon();
            string = this.fileIcon;
            if (string == null) {
                string = "Blank24.gif";
            }
        }
        if (!this.action.isSelected()) {
            throw new InternalError();
        }
        ToolBarOptionPane.Button button = this.list.getSelectedValue();
        object = button.label;
        String string2 = button.actionName;
        return new ToolBarOptionPane.Button(string2, string, icon, (String)object);
    }

    private void updateEnabled() {
        this.combo.setEnabled(this.action.isSelected());
        this.list.setEnabled(this.action.isSelected());
        boolean bl = !this.separator.isSelected();
        this.builtin.setEnabled(bl);
        this.file.setEnabled(bl);
        this.builtinCombo.setEnabled(bl && this.builtin.isSelected());
        this.fileButton.setEnabled(bl && this.file.isSelected());
    }

    private void updateList() {
        ActionSet actionSet = (ActionSet)this.combo.getSelectedItem();
        String string = actionSet.getLabel();
        jEdit.setProperty("options.toolbar.selectedActionSet", string);
        EditAction[] editActionArray = actionSet.getActions();
        Vector<ToolBarOptionPane.Button> vector = new Vector<ToolBarOptionPane.Button>(editActionArray.length);
        for (EditAction editAction : editActionArray) {
            String string2 = editAction.getLabel();
            if (string2 == null) continue;
            vector.add(new ToolBarOptionPane.Button(editAction.getName(), null, null, string2));
        }
        vector.sort((button, button2) -> StandardUtilities.compareStrings(button.label, button2.label, true));
        this.list.setListData(vector);
    }

    private void browseIcon() {
        String string = this.fileIcon == null ? null : MiscUtilities.getParentOfPath(this.fileIcon);
        String[] stringArray = GUIUtilities.showVFSFileDialog(null, string, 0, false);
        if (stringArray.length == 0) {
            return;
        }
        this.fileIcon = "file:" + stringArray[0];
        try {
            this.fileButton.setIcon(new ImageIcon(new URL(this.fileIcon)));
        }
        catch (MalformedURLException malformedURLException) {
            Log.log(9, this, malformedURLException);
        }
        this.fileButton.setText(MiscUtilities.getFileName(this.fileIcon));
    }
}

