/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.search;

import java.awt.Component;
import java.io.IOException;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.search.BufferListSet;
import org.gjt.sp.util.StandardUtilities;

public class DirectoryListSet
extends BufferListSet {
    private String directory;
    private String glob;
    private boolean recurse;

    public DirectoryListSet(String string, String string2, boolean bl) {
        this.directory = string;
        this.glob = string2;
        this.recurse = bl;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String string) {
        this.directory = string;
        this.invalidateCachedList();
    }

    public String getFileFilter() {
        return this.glob;
    }

    public void setFileFilter(String string) {
        this.glob = string;
        this.invalidateCachedList();
    }

    public boolean isRecursive() {
        return this.recurse;
    }

    public void setRecursive(boolean bl) {
        this.recurse = bl;
        this.invalidateCachedList();
    }

    @Override
    public String getCode() {
        return "new DirectoryListSet(\"" + StandardUtilities.charsToEscapes(this.directory) + "\",\"" + StandardUtilities.charsToEscapes(this.glob) + "\"," + this.recurse + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String[] _getFiles(Component component) {
        String[] stringArray;
        boolean bl = jEdit.getBooleanProperty("search.skipBinary.toggle");
        boolean bl2 = jEdit.getBooleanProperty("search.skipHidden.toggle");
        VFS vFS = VFSManager.getVFSForPath(this.directory);
        Object object = vFS.createVFSSessionSafe(this.directory, component);
        try {
            stringArray = vFS._listDirectory(object, this.directory, this.glob, this.recurse, component, bl, bl2);
        }
        catch (Throwable throwable) {
            try {
                vFS._endVFSSession(object, component);
                throw throwable;
            }
            catch (IOException iOException) {
                VFSManager.error(component, this.directory, "ioerror", new String[]{iOException.toString()});
                return null;
            }
        }
        vFS._endVFSSession(object, component);
        return stringArray;
    }
}

