/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jnati;

import java.util.HashMap;
import java.util.Map;

public class SystemType {
    private static final Map<String, SystemType> MAP = new HashMap<String, SystemType>();
    public static final SystemType WINDOWS_X86 = SystemType.get("WINDOWS-X86");
    public static final SystemType WINDOWS_X86_64 = SystemType.get("WINDOWS-X86_64");
    public static final SystemType LINUX_X86 = SystemType.get("LINUX-X86");
    public static final SystemType LINUX_X86_64 = SystemType.get("LINUX-X86_64");
    public static final SystemType LINUX_AMD64 = SystemType.get("LINUX-AMD64");
    public static final SystemType MAC_X86 = SystemType.get("MAC-X86");
    public static final SystemType MAC_PPC = SystemType.get("MAC-PPC");
    public static final SystemType FREEBSD_AMD64 = SystemType.get("FREEBSD-AMD64");
    public static final SystemType UNKNOWN = SystemType.get("UNKNOWN");
    private final String name;

    private SystemType(String name) {
        this.name = name;
    }

    public boolean isWindows() {
        return this.name.startsWith("WINDOWS-");
    }

    public boolean isLinux() {
        return this.name.startsWith("LINUX-");
    }

    public boolean isMac() {
        return this.name.startsWith("MAC-");
    }

    public boolean isUnknown() {
        return UNKNOWN.equals(this);
    }

    public boolean isFreeBsd() {
        return this.name.startsWith("FREEBSD-");
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return 37 * this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof SystemType) {
            return this.name.equals(((SystemType)obj).name);
        }
        return false;
    }

    public String toString() {
        return this.name;
    }

    public static synchronized SystemType get(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null argument: name");
        }
        SystemType type = MAP.get(name);
        if (type == null) {
            type = new SystemType(name);
            MAP.put(name, type);
        }
        return type;
    }
}

