/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.cif;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.adapter.readers.cif.Cif2DataParser;
import org.jmol.adapter.readers.cif.CifReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.api.SymmetryInterface;
import org.jmol.util.Logger;

public class TopoCifParser
implements CifReader.Parser {
    private static double ERROR_TOLERANCE = 0.001;
    private CifReader reader;
    private Lst<TopoLink> links = new Lst();
    private String allowedTypes = "+v+hb+";
    private String bondlist = "";
    private static final String[] topolFields = new String[]{"_topol_link_node_label_1", "_topol_link_node_label_2", "_topol_link_distance", "_topol_link_site_symmetry_symop_1", "_topol_link_site_symmetry_translation_1_x", "_topol_link_site_symmetry_translation_1_y", "_topol_link_site_symmetry_translation_1_z", "_topol_link_site_symmetry_symop_2", "_topol_link_site_symmetry_translation_2_x", "_topol_link_site_symmetry_translation_2_y", "_topol_link_site_symmetry_translation_2_z", "_topol_link_type", "_topol_link_multiplicity", "_topol_link_voronoi_solidangle", "_topol_link_site_symmetry_translation_1", "_topol_link_site_symmetry_translation_2"};
    private static final byte topol_link_node_label_1 = 0;
    private static final byte topol_link_node_label_2 = 1;
    private static final byte topol_link_distance = 2;
    private static final byte topol_link_site_symmetry_symop_1 = 3;
    private static final byte topol_link_site_symmetry_translation_1_x = 4;
    private static final byte topol_link_site_symmetry_translation_1_y = 5;
    private static final byte topol_link_site_symmetry_translation_1_z = 6;
    private static final byte topol_link_site_symmetry_symop_2 = 7;
    private static final byte topol_link_site_symmetry_translation_2_x = 8;
    private static final byte topol_link_site_symmetry_translation_2_y = 9;
    private static final byte topol_link_site_symmetry_translation_2_z = 10;
    private static final byte topol_link_type = 11;
    private static final byte topol_link_multiplicity = 12;
    private static final byte topol_link_voronoi_solidangle = 13;
    private static final byte topol_link_site_symmetry_translation_1 = 14;
    private static final byte topol_link_site_symmetry_translation_2 = 15;
    private int index;
    private boolean debugging = Logger.isActiveLevel(5);

    @Override
    public TopoCifParser setReader(CifReader reader) {
        if (reader.checkFilterKey("TOPOS_IGNORE")) {
            return this;
        }
        this.reader = reader;
        String types = reader.getFilter("TOPOS_TYPES");
        if (types != null && types.length() > 1) {
            types = "+" + types.substring(1).toLowerCase() + "+";
        }
        if (reader.doApplySymmetry) {
            reader.asc.setNoAutoBond();
        }
        return this;
    }

    @Override
    public void processBlock(String key) throws Exception {
        if (this.reader == null) {
            return;
        }
        if (this.reader.ucItems != null) {
            this.reader.allow_a_len_1 = true;
            for (int i = 0; i < 6; ++i) {
                this.reader.setUnitCellItem(i, this.reader.ucItems[i]);
            }
        }
        this.reader.parseLoopParameters(topolFields);
        while (this.reader.cifParser.getData()) {
            ++this.index;
            String name1 = null;
            String name2 = null;
            float d = 0.0f;
            int op1 = 1;
            int op2 = 1;
            int[] t1 = new int[3];
            int[] t2 = new int[3];
            String type = "v";
            float angle = 0.0f;
            type = this.reader.getField((byte)11);
            if (this.allowedTypes.indexOf("+" + type + "+") < 0) continue;
            Atom a1 = null;
            Atom a2 = null;
            name1 = this.reader.getField((byte)0);
            a1 = this.reader.asc.getAtomFromName(name1);
            if (a1 == null || (a2 = this.reader.asc.getAtomFromName(name2 = this.reader.getField((byte)1))) == null) {
                Logger.warn("TopoCifParser atom " + (a1 == null ? name1 : name2) + " could not be found");
                continue;
            }
            d = this.getFloat((byte)2);
            if (!(d > 0.0f)) {
                Logger.warn("TopoCifParser invalid distance");
                continue;
            }
            int multiplicity = this.getInt((byte)12);
            angle = this.getFloat((byte)13);
            op1 = this.getInt((byte)3);
            op2 = this.getInt((byte)7);
            String field = this.reader.getField((byte)14);
            if (field.length() > 1) {
                t1 = Cif2DataParser.getIntArrayFromStringList(field, 3);
            } else {
                t1[0] = this.getInt((byte)4);
                t1[1] = this.getInt((byte)5);
                t1[2] = this.getInt((byte)6);
            }
            field = this.reader.getField((byte)15);
            if (field.length() > 1) {
                t2 = Cif2DataParser.getIntArrayFromStringList(field, 3);
            } else {
                t2[0] = this.getInt((byte)8);
                t2[1] = this.getInt((byte)9);
                t2[2] = this.getInt((byte)10);
            }
            this.links.addLast(new TopoLink(this.index, a1, a2, d, op1, t1, op2, t2, multiplicity, type, angle));
        }
    }

    @Override
    public boolean finalizeReader() throws Exception {
        if (this.reader == null) {
            return false;
        }
        this.reader.applySymmetryAndSetTrajectory();
        return true;
    }

    @Override
    public void finalizeSymmetry(boolean haveSymmetry) throws Exception {
        if (this.reader == null || !haveSymmetry || !this.reader.doApplySymmetry) {
            return;
        }
        SymmetryInterface sym = this.reader.asc.getXSymmetry().getBaseSymmetry();
        int nOps = sym.getSpaceGroupOperationCount();
        M4[] operations = new M4[nOps];
        for (int i = 0; i < nOps; ++i) {
            operations[i] = sym.getSpaceGroupOperationRaw(i);
        }
        P3[] carts = new P3[this.reader.asc.ac];
        Atom[] atoms = this.reader.asc.atoms;
        int i = this.reader.asc.ac;
        while (--i >= 0) {
            carts[i] = P3.newP(atoms[i]);
            sym.toCartesian(carts[i], true);
        }
        int n = 0;
        BS bsConnected = new BS();
        int nLinks = this.links.size();
        for (int i2 = 0; i2 < nLinks; ++i2) {
            TopoLink link = (TopoLink)this.links.get(i2);
            link.setPrimitives(sym, operations);
            n += this.setBonds(i2, atoms, carts, link, sym, nOps, bsConnected);
        }
        if (bsConnected.cardinality() > 0) {
            this.reader.asc.bsAtoms = bsConnected;
        }
        this.reader.appendLoadNote("TopoCifParser read " + nLinks + " links; created " + n + " edges and " + bsConnected.cardinality() + " nodes");
        Lst<Map<String, Object>> info = new Lst<Map<String, Object>>();
        for (int i3 = 0; i3 < nLinks; ++i3) {
            info.addLast(((TopoLink)this.links.get(i3)).getInfo());
        }
        this.reader.asc.setCurrentModelInfo("topology", info);
    }

    private int setBonds(int index, Atom[] atoms, P3[] carts, TopoLink link, SymmetryInterface sym, int nOps, BS bsConnected) {
        int nbonds = 0;
        BS bs1 = new BS();
        BS bs2 = new BS();
        int i = this.reader.asc.ac;
        while (--i >= 0) {
            Atom a = atoms[i];
            if (a.atomSite == link.a1.atomSite) {
                bs1.set(i);
            }
            if (a.atomSite != link.a2.atomSite) continue;
            bs2.set(i);
        }
        P3 pa = new P3();
        BS bsym = new BS();
        int i1 = bs1.nextSetBit(0);
        while (i1 >= 0) {
            Atom at1 = atoms[i1];
            bsym.clearAll();
            for (int i2 = 0; i2 < nOps; ++i2) {
                TopoPrimitive prim = link.primitives[i2];
                if (prim == null) continue;
                pa.setT(at1);
                sym.unitize(pa);
                if (!TopoCifParser.isEqualD(pa, prim.p1u, 0.0)) continue;
                if (this.debugging) {
                    Logger.debug("TopoCifParser " + link.info() + " primitive: " + prim.info());
                }
                bsym.set(i2);
            }
            link.symops = bsym;
            int i2 = bs2.nextSetBit(0);
            while (i2 >= 0) {
                Atom at2 = atoms[i2];
                if (i1 != i2 && TopoCifParser.isEqualD(carts[i1], carts[i2], link.d)) {
                    V3 va12 = V3.newVsub(at2, at1);
                    int i3 = bsym.nextSetBit(0);
                    while (i3 >= 0) {
                        String key;
                        if (TopoCifParser.isEqualD(va12, link.primitives[i3].v12f, 0.0) && this.bondlist.indexOf(key = "," + at1.index + "," + at2.index + ",") < 0) {
                            this.bondlist = this.bondlist + key + at1.index + ",";
                            ++nbonds;
                            if (this.debugging) {
                                Logger.debug(nbonds + " " + at1 + " " + at2 + " " + at1.index + " " + at2.index);
                            }
                            this.reader.asc.addNewBondWithOrderA(at1, at2, link.order);
                            bsConnected.set(at1.index);
                            bsConnected.set(at2.index);
                        }
                        i3 = bsym.nextSetBit(i3 + 1);
                    }
                }
                i2 = bs2.nextSetBit(i2 + 1);
            }
            i1 = bs1.nextSetBit(i1 + 1);
        }
        return nbonds;
    }

    static boolean isEqualD(T3 p1, T3 p2, double d) {
        return Math.abs((double)p1.distance(p2) - d) < ERROR_TOLERANCE;
    }

    private int getInt(byte field) {
        return this.reader.parseIntStr(this.reader.getField(field));
    }

    private float getFloat(byte field) {
        return this.reader.parseFloatStr(this.reader.getField(field));
    }

    private class TopoPrimitive {
        P3 p1u;
        P3 p2u;
        V3 v12f;
        boolean isValid;
        int symop;

        TopoPrimitive(TopoLink link, int symop, SymmetryInterface sym, M4 op) {
            this.symop = symop;
            P3 p1 = new P3();
            P3 p2 = new P3();
            p1.setT(link.p1f);
            p2.setT(link.p2f);
            op.rotTrans(p1);
            op.rotTrans(p2);
            this.p1u = P3.newP(p1);
            sym.unitize(this.p1u);
            this.p2u = P3.newP(p2);
            this.p2u.add(V3.newVsub(this.p1u, p1));
            this.v12f = V3.newVsub(this.p2u, this.p1u);
            p1.setT(this.p1u);
            p2.setT(this.p2u);
            sym.toCartesian(p1, true);
            sym.toCartesian(p2, true);
            this.isValid = TopoCifParser.isEqualD(p1, p2, link.d);
        }

        public String info() {
            return "op=" + this.symop + " pt=" + this.p1u + " v=" + this.v12f;
        }

        public String toString() {
            return this.info();
        }
    }

    private class TopoLink {
        int idx;
        Atom a1;
        Atom a2;
        int op1;
        int op2;
        P3 t1;
        P3 t2;
        P3 dt;
        String type;
        float voronoiAngle;
        int multiplicity;
        M4 m1;
        M4 m2;
        P3 p1f;
        P3 p2f;
        float d;
        int order;
        TopoPrimitive[] primitives;
        public BS symops;

        TopoLink(int index, Atom a1, Atom a2, float d, int op1, int[] t1, int op2, int[] t2, int multiplicity, String type, float vAngle) {
            this.idx = index;
            this.a1 = a1;
            this.a2 = a2;
            this.d = d;
            this.op1 = op1 - 1;
            this.op2 = op2 - 1;
            this.type = type;
            this.order = "vw".equals(type) ? 33 : ("hb".equals(type) ? 2048 : 1);
            this.t1 = P3.new3(t1[0], t1[1], t1[2]);
            this.t2 = P3.new3(t2[0], t2[1], t2[2]);
            this.dt = P3.new3(t2[0] - t1[0], t2[1] - t1[1], t2[2] - t1[2]);
            this.multiplicity = multiplicity;
            this.voronoiAngle = vAngle;
        }

        Map<String, Object> getInfo() {
            Hashtable<String, Object> info = new Hashtable<String, Object>();
            info.put("label1", this.a1.atomName);
            info.put("label2", this.a2.atomName);
            info.put("distance", Float.valueOf(this.d));
            info.put("symop1", this.op1 + 1);
            info.put("symop2", this.op2 + 1);
            info.put("t1", this.t1);
            info.put("t2", this.t2);
            info.put("multiplicity", this.multiplicity);
            info.put("type", this.type);
            info.put("voronoiSolidAngle", Float.valueOf(this.voronoiAngle));
            info.put("atomIndex1", this.a1.index);
            info.put("atomIndex2", this.a2.index);
            info.put("index", this.idx);
            info.put("op1", this.m1);
            info.put("op2", this.m2);
            info.put("dt", this.dt);
            info.put("primitive1", this.p1f);
            info.put("primitive2", this.p2f);
            int[] ops = new int[this.symops.cardinality()];
            int p = 0;
            int i = this.symops.nextSetBit(0);
            while (i >= 0) {
                ops[p++] = i + 1;
                i = this.symops.nextSetBit(i + 1);
            }
            info.put("primitiveSymops", ops);
            info.put("order", this.order);
            return info;
        }

        void setPrimitives(SymmetryInterface sym, M4[] operations) {
            int nOps = operations.length;
            this.p1f = P3.new3(this.a1.x, this.a1.y, this.a1.z);
            this.p2f = P3.new3(this.a2.x, this.a2.y, this.a2.z);
            this.m1 = operations[this.op1];
            this.m1.rotTrans(this.p1f);
            this.m2 = operations[this.op2];
            this.m2.rotTrans(this.p2f);
            this.p2f.add(this.dt);
            this.primitives = new TopoPrimitive[nOps];
            for (int j = 0; j < nOps; ++j) {
                TopoPrimitive prim = new TopoPrimitive(this, j + 1, sym, operations[j]);
                if (!prim.isValid) continue;
                this.primitives[j] = prim;
            }
        }

        public String info() {
            return "[link " + this.idx + " " + this.a1.atomName + " " + this.a2.atomName + " " + this.d + " " + this.type + "]";
        }

        public String toString() {
            return this.info();
        }
    }
}

