/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapecgo;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.BS;
import javajs.util.CU;
import javajs.util.Lst;
import javajs.util.PT;
import javajs.util.T3;
import org.jmol.script.T;
import org.jmol.shapespecial.DrawMesh;
import org.jmol.util.C;
import org.jmol.util.Logger;
import org.jmol.util.Normix;
import org.jmol.viewer.Viewer;

public class CGOMesh
extends DrawMesh {
    public Lst<Object> cmds;
    public static final int GL_POINTS = 0;
    public static final int GL_LINES = 1;
    public static final int GL_LINE_LOOP = 2;
    public static final int GL_LINE_STRIP = 3;
    public static final int GL_TRIANGLES = 4;
    public static final int GL_TRIANGLE_STRIP = 5;
    public static final int GL_TRIANGLE_FAN = 6;
    public static final int STOP = 0;
    public static final int SIMPLE_LINE = 1;
    public static final int BEGIN = 2;
    public static final int END = 3;
    public static final int VERTEX = 4;
    public static final int NORMAL = 5;
    public static final int COLOR = 6;
    public static final int SPHERE = 7;
    public static final int TRICOLOR_TRIANGLE = 8;
    public static final int CYLINDER = 9;
    public static final int LINEWIDTH = 10;
    public static final int WIDTHSCALE = 11;
    public static final int ENABLE = 12;
    public static final int DISABLE = 13;
    public static final int SAUSAGE = 14;
    public static final int CUSTOM_CYLINDER = 15;
    public static final int DOTWIDTH = 16;
    public static final int ALPHA_TRIANGLE = 17;
    public static final int ELLIPSOID = 18;
    public static final int FONT = 19;
    public static final int FONT_SCALE = 20;
    public static final int FONT_VERTEX = 21;
    public static final int FONT_AXES = 22;
    public static final int CHAR = 23;
    public static final int INDENT = 24;
    public static final int ALPHA = 25;
    public static final int QUADRIC = 26;
    public static final int CONE = 27;
    public static final int RESET_NORMAL = 28;
    public static final int PICK_COLOR = 29;
    private static final int[] sizes = new int[]{0, 8, 1, 0, 3, 3, 3, 4, 27, 13, 1, 1, 1, 1, 13, 15, 1, 35, 13, 3, 2, 3, 9, 1, 2, 1, 14, 16, 1, 2};
    private static final int[] sizes2D = new int[]{0, 6, 1, 0, 2, 3, 3, 4, 24, 13, 1, 1, 1, 1, 11, 15, 1, 35, 13, 3, 2, 3, 9, 1, 2, 1, 14, 16, 1, 2};
    public static final int JMOL_DIAMETER = -100;
    public static final int JMOL_SCREEN = -101;
    public static final int JMOL_UVMAP = -102;
    public static final int JMOL_PS = -103;
    public static final int PS_NEWPATH = -104;
    public static final int PS_CLOSEPATH = -105;
    public static final int PS_STROKE = -106;
    public static final int PS_SETLINEWIDTH = -107;
    public static final int PS_SCALE = -108;
    public static final int PS_MOVETO = -109;
    public static final int PS_LINETO = -110;
    public static final int PS_SHOWPAGE = -111;
    private static final String KEY_LIST = "BEGIN:2 END:3 STOP:0 POINT:0 POINTS:0 LINES:1 LINE_LOOP:2 LINE_STRIP:3 TRIANGLES:4 TRIANGLE_STRIP:5 TRIANGLE_FAN:6 LINE:1 VERTEX:4 NORMAL:5 COLOR:6 LINEWIDTH:10 SAUSAGE:14 DIAMETER:-100 SCREEN:-101 UVMAP:-102 PS:-103 NEWPATH:-104 CLOSEPATH:-105 STROKE:-106 SETLINEWIDTH:-107 SCALE:-108 MOVETO:-109 LINETO:-110 SHOWPAGE:-111";
    private static Map<String, Integer> keyMap;
    public Lst<Short> nList = new Lst();
    public Lst<Short> cList = new Lst();

    CGOMesh(Viewer vwr, String thisID, short colix, int index) {
        super(vwr, thisID, colix, index);
    }

    public static int getSize(int i, boolean is2D) {
        switch (i) {
            case -103: {
                return 13;
            }
            case -102: {
                return 15;
            }
            case -110: 
            case -109: 
            case -108: {
                return 2;
            }
            case -107: 
            case -101: 
            case -100: {
                return 1;
            }
            case -111: 
            case -106: 
            case -105: 
            case -104: {
                return 0;
            }
        }
        return i >= 0 && i < sizes.length ? (is2D ? sizes2D : sizes)[i] : -1;
    }

    public static Map<String, Integer> getKeyMap() {
        Hashtable<String, Integer> keyMap = new Hashtable<String, Integer>();
        String[] tokens = PT.getTokens(KEY_LIST);
        int i = tokens.length;
        while (--i >= 0) {
            int pt = tokens[i].indexOf(":");
            keyMap.put(tokens[i].substring(0, pt), Integer.parseInt(tokens[i].substring(pt + 1)));
        }
        return keyMap;
    }

    static boolean getData(Object[] d) {
        if (keyMap == null) {
            keyMap = CGOMesh.getKeyMap();
        }
        T[] st = (T[])d[0];
        int[] ai = (int[])d[1];
        Lst data = (Lst)d[2];
        Viewer vwr = (Viewer)d[3];
        int i = ai[0];
        int slen = ai[1];
        int tok = st[i].tok;
        int n = i = tok == 0x10000040 ? i + 1 : i + 2;
        if (i >= slen) {
            return false;
        }
        String s = st[i].value.toString().toUpperCase();
        int type = ";PS;BEGIN;SCREEN;UVMAP;".indexOf(";" + s + ";");
        i = CGOMesh.addItems(i, st, slen, data, vwr);
        if (type == 0) {
            if (i + 5 >= slen || st[i + 1].tok != 134221834) {
                return false;
            }
            if (!CGOMesh.parseEPSData(st[i + 3].value.toString(), data)) {
                return false;
            }
            i += 5;
        }
        ai[0] = i;
        return true;
    }

    private static boolean parseEPSData(String eps, Lst<Object> data) {
        int pt = eps.indexOf("%%BoundingBox:");
        if (pt < 0) {
            return false;
        }
        Lst<Float> stack = new Lst<Float>();
        int[] next = new int[]{pt + 14};
        for (int i = 0; i < 4; ++i) {
            data.addLast(Float.valueOf(PT.parseFloatNext(eps, next)));
        }
        pt = eps.indexOf("%%EndProlog");
        if (pt < 0) {
            return false;
        }
        next[0] = pt + 11;
        int len = eps.length();
        while (true) {
            float f = PT.parseFloatChecked(eps, len, next, false);
            if (next[0] >= len) break;
            if (Float.isNaN(f)) {
                String s = PT.parseTokenChecked(eps, len, next);
                if (s.startsWith("%%")) continue;
                if (!CGOMesh.addKey(data, s)) {
                    return false;
                }
                if (stack.size() <= 0) continue;
                int n = stack.size();
                for (int k = 0; k < n; ++k) {
                    data.addLast(stack.get(k));
                }
                stack.clear();
                continue;
            }
            stack.addLast(Float.valueOf(f));
        }
        return true;
    }

    private static int addItems(int i, T[] st, int slen, Lst<Object> data, Viewer vwr) {
        block6: for (int j = i; j < slen; ++j) {
            T t = st[j];
            int tok = t.tok;
            switch (tok) {
                case 0x10000041: {
                    i = j;
                    j = slen;
                    continue block6;
                }
                case 2: {
                    data.addLast(Float.valueOf(t.intValue));
                    continue block6;
                }
                case 3: {
                    data.addLast(t.value);
                    continue block6;
                }
                case 8: 
                case 10: {
                    T3 pt = tok == 8 ? (T3)t.value : vwr.ms.getAtomSetCenter((BS)t.value);
                    data.addLast(Float.valueOf(pt.x));
                    data.addLast(Float.valueOf(pt.y));
                    data.addLast(Float.valueOf(pt.z));
                    continue block6;
                }
                default: {
                    if (CGOMesh.addKey(data, st[j].value.toString())) continue block6;
                    Logger.error("CGO unknown: " + st[j].value);
                    i = j = slen;
                }
            }
        }
        return i;
    }

    private static boolean addKey(Lst<Object> data, String key) {
        Integer ii = keyMap.get((key = key.toUpperCase()).toUpperCase());
        if (ii == null) {
            return false;
        }
        data.addLast(ii);
        return true;
    }

    @Override
    public void clear(String meshType) {
        super.clear(meshType);
        this.useColix = false;
    }

    boolean set(Lst<Object> list) {
        this.width = 200.0f;
        this.diameter = 0;
        this.useColix = true;
        this.bsTemp = new BS();
        try {
            if (list.get(0) instanceof Number) {
                this.cmds = list;
            } else {
                this.cmds = (Lst)list.get(1);
                if (this.cmds == null) {
                    this.cmds = (Lst)list.get(0);
                }
                this.cmds = (Lst)this.cmds.get(1);
            }
            int n = this.cmds.size();
            boolean is2D = false;
            for (int i = 0; i < n; ++i) {
                int type = ((Number)this.cmds.get(i)).intValue();
                int len = CGOMesh.getSize(type, is2D);
                if (len < 0) {
                    Logger.error("CGO unknown type: " + type);
                    return false;
                }
                switch (type) {
                    case -102: 
                    case -101: {
                        is2D = true;
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 0: {
                        return true;
                    }
                    case 5: {
                        this.addNormix(i + 1);
                        break;
                    }
                    case 6: {
                        this.addColix(i + 1);
                        this.useColix = false;
                        break;
                    }
                    case 14: {
                        this.addColix(i + 8);
                        this.addColix(i + 11);
                        break;
                    }
                    case 8: {
                        this.addNormix(i + 10);
                        this.addNormix(i + 13);
                        this.addNormix(i + 16);
                        this.addColix(i + 19);
                        this.addColix(i + 22);
                        this.addColix(i + 25);
                    }
                }
                i += len;
            }
            return true;
        }
        catch (Exception e) {
            Logger.error("CGOMesh error: " + e);
            this.cmds = null;
            return false;
        }
    }

    private void addColix(int i) {
        this.getPoint(i, this.vTemp);
        this.cList.addLast(C.getColix(CU.colorPtToFFRGB(this.vTemp)));
    }

    private void addNormix(int i) {
        this.getPoint(i, this.vTemp);
        this.nList.addLast(Normix.get2SidedNormix(this.vTemp, this.bsTemp));
    }

    public void getPoint(int i, T3 pt) {
        pt.set(this.getFloat(i++), this.getFloat(i++), this.getFloat(i));
    }

    public int getInt(int i) {
        return ((Number)this.cmds.get(i)).intValue();
    }

    public float getFloat(int i) {
        return ((Number)this.cmds.get(i)).floatValue();
    }
}

