/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.V3;
import org.jmol.api.SymmetryInterface;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Model;
import org.jmol.modelset.ModelSet;
import org.jmol.modelsetbio.BioModel;
import org.jmol.viewer.Viewer;

public class Trajectory {
    private Viewer vwr;
    ModelSet ms;
    Lst<P3[]> steps;
    boolean isFractional = true;

    Trajectory set(Viewer vwr, ModelSet ms, Lst<P3[]> steps) {
        this.vwr = vwr;
        this.ms = ms;
        this.steps = steps;
        return this;
    }

    void setUnitCell(int imodel) {
        SymmetryInterface c = this.ms.getUnitCell(imodel);
        if (c != null && c.getCoordinatesAreFractional() && c.isSupercell()) {
            P3[] list = (P3[])this.ms.trajectory.steps.get(imodel);
            int i = list.length;
            while (--i >= 0) {
                if (list[i] == null) continue;
                c.toSupercell(list[i]);
            }
        }
    }

    void setModel(int modelIndex) {
        Model[] am = this.ms.am;
        int baseModelIndex = am[modelIndex].trajectoryBaseIndex;
        am[baseModelIndex].selectedTrajectory = modelIndex;
        this.isFractional = !this.ms.getMSInfoB("ignoreUnitCell");
        this.setAtomPositions(baseModelIndex, modelIndex, (P3[])this.steps.get(modelIndex), null, 0.0f, this.ms.vibrationSteps == null ? null : (V3[])this.ms.vibrationSteps.get(modelIndex), this.isFractional);
        int currentModelIndex = this.vwr.am.cmi;
        if (currentModelIndex >= 0 && currentModelIndex != modelIndex && am[currentModelIndex].fileIndex == am[modelIndex].fileIndex) {
            this.vwr.setCurrentModelIndexClear(modelIndex, false);
        }
    }

    private void setAtomPositions(int baseModelIndex, int modelIndex, P3[] t1, P3[] t2, float f, V3[] vibs, boolean isFractional) {
        BS bs = new BS();
        V3 vib = new V3();
        Model[] am = this.ms.am;
        Atom[] at = this.ms.at;
        int iFirst = am[baseModelIndex].firstAtomIndex;
        int iMax = iFirst + this.ms.getAtomCountInModel(baseModelIndex);
        if (f == 0.0f) {
            int pt = 0;
            for (int i = iFirst; i < iMax && pt < t1.length; ++i, ++pt) {
                at[i].mi = (short)modelIndex;
                if (t1[pt] == null) continue;
                if (isFractional) {
                    at[i].setFractionalCoordTo(t1[pt], true);
                } else {
                    at[i].setT(t1[pt]);
                }
                if (this.ms.vibrationSteps != null) {
                    if (vibs != null && vibs[pt] != null) {
                        vib = vibs[pt];
                    }
                    this.ms.setVibrationVector(i, vib);
                }
                bs.set(i);
            }
        } else {
            P3 p = new P3();
            int n = Math.min(t1.length, t2.length);
            int pt = 0;
            for (int i = iFirst; i < iMax && pt < n; ++i, ++pt) {
                at[i].mi = (short)modelIndex;
                if (t1[pt] == null || t2[pt] == null) continue;
                p.sub2(t2[pt], t1[pt]);
                p.scaleAdd2(f, p, t1[pt]);
                if (isFractional) {
                    at[i].setFractionalCoordTo(p, true);
                } else {
                    at[i].setT(p);
                }
                bs.set(i);
            }
        }
        this.ms.initializeBspf();
        this.ms.validateBspfForModel(baseModelIndex, false);
        this.ms.recalculateLeadMidpointsAndWingVectors(baseModelIndex);
        this.ms.sm.notifyAtomPositionsChanged(baseModelIndex, bs, null);
        if (am[baseModelIndex].hasRasmolHBonds) {
            ((BioModel)am[baseModelIndex]).resetRasmolBonds(bs, 2);
        }
    }

    BS getModelsSelected() {
        BS bsModels = new BS();
        int i = this.ms.mc;
        while (--i >= 0) {
            int t = this.ms.am[i].selectedTrajectory;
            if (t < 0) continue;
            bsModels.set(t);
            i = this.ms.am[i].trajectoryBaseIndex;
        }
        return bsModels;
    }

    void morph(int m1, int m2, float f) {
        if (f == 0.0f) {
            this.ms.setTrajectory(m1);
            return;
        }
        if (f == 1.0f) {
            this.ms.setTrajectory(m2);
            return;
        }
        int baseModelIndex = this.ms.am[m1].trajectoryBaseIndex;
        this.ms.am[baseModelIndex].selectedTrajectory = m1;
        this.setAtomPositions(baseModelIndex, m1, (P3[])this.steps.get(m1), (P3[])this.steps.get(m2), f, this.ms.vibrationSteps == null ? null : (V3[])this.ms.vibrationSteps.get(m1), true);
        int m = this.vwr.am.cmi;
        if (m >= 0 && m != m1 && this.ms.am[m].fileIndex == this.ms.am[m1].fileIndex) {
            this.vwr.setCurrentModelIndexClear(m1, false);
        }
    }

    void fixAtom(Atom a) {
        short m = a.mi;
        boolean isFrac = this.ms.unitCells != null && this.ms.unitCells[m].getCoordinatesAreFractional();
        P3 pt = ((P3[])this.steps.get(m))[a.i - this.ms.am[m].firstAtomIndex];
        pt.set(a.x, a.y, a.z);
        if (isFrac) {
            this.ms.unitCells[m].toFractional(pt, true);
        }
    }

    public void getFractional(Atom a, P3 ptTemp) {
        a.setFractionalCoordPt(ptTemp, ((P3[])this.steps.get(a.mi))[a.i - this.ms.am[a.mi].firstAtomIndex], true);
    }

    public String getState() {
        String s = "";
        int i = this.ms.mc;
        while (--i >= 0) {
            int t = this.ms.am[i].selectedTrajectory;
            if (t < 0) continue;
            s = " or " + this.ms.getModelNumberDotted(t) + s;
            i = this.ms.am[i].trajectoryBaseIndex;
        }
        return s.length() > 0 ? (s = "set trajectory {" + s.substring(4) + "}") : "";
    }

    public boolean hasMeasure(int[] measure) {
        if (measure != null) {
            int count = measure[0];
            for (int i = 1; i <= count; ++i) {
                int atomIndex = measure[i];
                if (atomIndex < 0 || !this.ms.am[this.ms.at[atomIndex].mi].isTrajectory) continue;
                return true;
            }
        }
        return false;
    }

    public void selectDisplayed(BS bs) {
        int i = this.ms.mc;
        while (--i >= 0) {
            if (!this.ms.am[i].isTrajectory || this.ms.at[this.ms.am[i].firstAtomIndex].mi == i) continue;
            bs.clear(i);
        }
    }

    public void getModelBS(int modelIndex, BS bs) {
        int iBase = this.ms.am[modelIndex].trajectoryBaseIndex;
        int i = this.ms.mc;
        while (--i >= iBase) {
            if (this.ms.am[i].trajectoryBaseIndex != iBase) continue;
            bs.set(i);
        }
    }

    public void setBaseModels(BS bsModels) {
        int i = this.ms.mc;
        while (--i >= 0) {
            if (!bsModels.get(i) || !this.ms.am[i].isTrajectory) continue;
            bsModels.set(this.ms.am[i].trajectoryBaseIndex);
        }
    }
}

