/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.io;

import com.android.dx.io.EncodedValue;
import com.android.dx.util.ByteInput;
import com.android.dx.util.Leb128Utils;

public class EncodedValueReader {
    public static final int ENCODED_BYTE = 0;
    public static final int ENCODED_SHORT = 2;
    public static final int ENCODED_CHAR = 3;
    public static final int ENCODED_INT = 4;
    public static final int ENCODED_LONG = 6;
    public static final int ENCODED_FLOAT = 16;
    public static final int ENCODED_DOUBLE = 17;
    public static final int ENCODED_STRING = 23;
    public static final int ENCODED_TYPE = 24;
    public static final int ENCODED_FIELD = 25;
    public static final int ENCODED_ENUM = 27;
    public static final int ENCODED_METHOD = 26;
    public static final int ENCODED_ARRAY = 28;
    public static final int ENCODED_ANNOTATION = 29;
    public static final int ENCODED_NULL = 30;
    public static final int ENCODED_BOOLEAN = 31;
    protected final ByteInput in;

    public EncodedValueReader(ByteInput in) {
        this.in = in;
    }

    public EncodedValueReader(EncodedValue in) {
        this(in.asByteInput());
    }

    public final void readArray() {
        int size = Leb128Utils.readUnsignedLeb128(this.in);
        this.visitArray(size);
        for (int i = 0; i < size; ++i) {
            this.readValue();
        }
    }

    public final void readAnnotation() {
        int typeIndex = Leb128Utils.readUnsignedLeb128(this.in);
        int size = Leb128Utils.readUnsignedLeb128(this.in);
        this.visitAnnotation(typeIndex, size);
        for (int i = 0; i < size; ++i) {
            this.visitAnnotationName(Leb128Utils.readUnsignedLeb128(this.in));
            this.readValue();
        }
    }

    public final void readValue() {
        int argAndType = this.in.readByte() & 0xFF;
        int type = argAndType & 0x1F;
        int arg = (argAndType & 0xE0) >> 5;
        int size = arg + 1;
        switch (type) {
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 16: 
            case 17: {
                this.visitPrimitive(argAndType, type, arg, size);
                break;
            }
            case 23: {
                this.visitString(type, this.readIndex(this.in, size));
                break;
            }
            case 24: {
                this.visitType(type, this.readIndex(this.in, size));
                break;
            }
            case 25: 
            case 27: {
                this.visitField(type, this.readIndex(this.in, size));
                break;
            }
            case 26: {
                this.visitMethod(type, this.readIndex(this.in, size));
                break;
            }
            case 28: {
                this.visitArrayValue(argAndType);
                this.readArray();
                break;
            }
            case 29: {
                this.visitAnnotationValue(argAndType);
                this.readAnnotation();
                break;
            }
            case 30: {
                this.visitEncodedNull(argAndType);
                break;
            }
            case 31: {
                this.visitEncodedBoolean(argAndType);
            }
        }
    }

    protected void visitArray(int size) {
    }

    protected void visitAnnotation(int typeIndex, int size) {
    }

    protected void visitAnnotationName(int nameIndex) {
    }

    protected void visitPrimitive(int argAndType, int type, int arg, int size) {
        for (int i = 0; i < size; ++i) {
            this.in.readByte();
        }
    }

    protected void visitString(int type, int index) {
    }

    protected void visitType(int type, int index) {
    }

    protected void visitField(int type, int index) {
    }

    protected void visitMethod(int type, int index) {
    }

    protected void visitArrayValue(int argAndType) {
    }

    protected void visitAnnotationValue(int argAndType) {
    }

    protected void visitEncodedBoolean(int argAndType) {
    }

    protected void visitEncodedNull(int argAndType) {
    }

    private int readIndex(ByteInput in, int byteCount) {
        int result = 0;
        int shift = 0;
        for (int i = 0; i < byteCount; ++i) {
            result += (in.readByte() & 0xFF) << shift;
            shift += 8;
        }
        return result;
    }
}

