/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.credential.system;

import org.mariadb.jdbc.HostAddress;
import org.mariadb.jdbc.credential.Credential;
import org.mariadb.jdbc.credential.CredentialPlugin;
import org.mariadb.jdbc.util.Options;

public class PropertiesCredentialPlugin
implements CredentialPlugin {
    private Options options;
    private String userName;

    @Override
    public String type() {
        return "PROPERTY";
    }

    @Override
    public String name() {
        return "Environment password";
    }

    @Override
    public CredentialPlugin initialize(Options options, String userName, HostAddress hostAddress) {
        this.options = options;
        this.userName = userName;
        return this;
    }

    @Override
    public Credential get() {
        String userKey = this.options.nonMappedOptions.getProperty("userKey");
        String pwdKey = this.options.nonMappedOptions.getProperty("pwdKey");
        String propUser = System.getProperty(userKey != null ? userKey : "mariadb.user");
        return new Credential(propUser == null ? this.userName : propUser, System.getProperty(pwdKey != null ? pwdKey : "mariadb.pwd"));
    }
}

