/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.neuralnetwork;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.rules.Rule;
import org.languagetool.rules.ScoredConfusionSet;
import org.languagetool.rules.ScoredConfusionSetLoader;
import org.languagetool.rules.neuralnetwork.NeuralNetworkRule;
import org.languagetool.rules.neuralnetwork.Word2VecModel;

public abstract class NeuralNetworkRuleCreator {
    private static final String CONFUSION_SET_FILENAME = "neuralnetwork/confusion_sets.txt";

    private NeuralNetworkRuleCreator() {
    }

    public static List<Rule> createRules(ResourceBundle messages, Language language, Word2VecModel word2vecModel) throws IOException {
        List<ScoredConfusionSet> confusionSets;
        try {
            FileInputStream confusionSetsStream = new FileInputStream(word2vecModel.getPath() + File.separator + CONFUSION_SET_FILENAME);
            Object object = null;
            try {
                confusionSets = ScoredConfusionSetLoader.loadConfusionSet(confusionSetsStream);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (confusionSetsStream != null) {
                    if (object != null) {
                        try {
                            ((InputStream)confusionSetsStream).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ((InputStream)confusionSetsStream).close();
                    }
                }
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("Warning: neuralnetwork/confusion_sets.txt not found for " + language.getShortCode());
            return new ArrayList<Rule>(0);
        }
        ArrayList<Rule> neuralNetworkRules = new ArrayList<Rule>();
        for (ScoredConfusionSet confusionSet : confusionSets) {
            neuralNetworkRules.add(new NeuralNetworkRule(messages, language, confusionSet, word2vecModel));
        }
        return neuralNetworkRules;
    }
}

