/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.corpus.io;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.corpus.io.ByteArrayStream;
import com.hankcs.hanlp.corpus.io.IOUtil;
import com.hankcs.hanlp.utility.Predefine;
import com.hankcs.hanlp.utility.TextUtility;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ByteArrayOtherStream
extends ByteArrayStream {
    InputStream is;

    public ByteArrayOtherStream(byte[] bytes, int bufferSize) {
        super(bytes, bufferSize);
    }

    public ByteArrayOtherStream(byte[] bytes, int bufferSize, InputStream is) {
        super(bytes, bufferSize);
        this.is = is;
    }

    public static ByteArrayOtherStream createByteArrayOtherStream(String path) {
        try {
            InputStream is = HanLP.Config.IOAdapter == null ? new FileInputStream(path) : HanLP.Config.IOAdapter.open(path);
            return ByteArrayOtherStream.createByteArrayOtherStream(is);
        }
        catch (Exception e) {
            Predefine.logger.warning(TextUtility.exceptionToString(e));
            return null;
        }
    }

    public static ByteArrayOtherStream createByteArrayOtherStream(InputStream is) throws IOException {
        if (is == null) {
            return null;
        }
        int size = is.available();
        int bufferSize = Math.min(0x100000, size = Math.max(102400, size));
        byte[] bytes = new byte[bufferSize];
        if (IOUtil.readBytesFromOtherInputStream(is, bytes) == 0) {
            throw new IOException("\u8bfb\u53d6\u4e86\u7a7a\u6587\u4ef6\uff0c\u6216\u53c2\u6570InputStream\u5df2\u7ecf\u5230\u4e86\u6587\u4ef6\u5c3e\u90e8");
        }
        return new ByteArrayOtherStream(bytes, bufferSize, is);
    }

    @Override
    protected void ensureAvailableBytes(int size) {
        if (this.offset + size > this.bufferSize) {
            try {
                int wantedBytes = this.offset + size - this.bufferSize;
                wantedBytes = Math.max(wantedBytes, this.is.available());
                wantedBytes = Math.min(wantedBytes, this.offset);
                byte[] bytes = new byte[wantedBytes];
                int readBytes = IOUtil.readBytesFromOtherInputStream(this.is, bytes);
                assert (readBytes > 0) : "\u5df2\u5230\u8fbe\u6587\u4ef6\u5c3e\u90e8\uff01";
                System.arraycopy(this.bytes, this.offset, this.bytes, this.offset - wantedBytes, this.bufferSize - this.offset);
                System.arraycopy(bytes, 0, this.bytes, this.bufferSize - wantedBytes, wantedBytes);
                this.offset -= wantedBytes;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void close() {
        super.close();
        if (this.is == null) {
            return;
        }
        try {
            this.is.close();
        }
        catch (IOException e) {
            Predefine.logger.warning(TextUtility.exceptionToString(e));
        }
    }
}

