/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.mining.word2vec;

import com.hankcs.hanlp.mining.word2vec.Corpus;
import com.hankcs.hanlp.mining.word2vec.TextFileCorpus;
import java.io.IOException;
import java.io.RandomAccessFile;

public class CacheCorpus
extends Corpus {
    private RandomAccessFile raf;

    public CacheCorpus(Corpus cloneSrc) throws IOException {
        super(cloneSrc);
        this.raf = new RandomAccessFile(((TextFileCorpus)cloneSrc).cacheFile, "r");
    }

    @Override
    public String nextWord() throws IOException {
        return null;
    }

    @Override
    public int readWordIndex() throws IOException {
        int id = this.nextId();
        while (id == -4) {
            id = this.nextId();
        }
        return id;
    }

    private int nextId() throws IOException {
        if (this.raf.length() - this.raf.getFilePointer() >= 4L) {
            int id = this.raf.readInt();
            return id < 0 ? id : this.table[id];
        }
        return -2;
    }

    @Override
    public void rewind(int numThreads, int id) throws IOException {
        super.rewind(numThreads, id);
        this.raf.seek(this.raf.length() / 4L / (long)numThreads * (long)id * 4L);
    }
}

