/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.maxent;

import opennlp.tools.ml.ArrayMath;
import opennlp.tools.ml.model.AbstractModel;
import opennlp.tools.ml.model.Context;
import opennlp.tools.ml.model.EvalParameters;
import opennlp.tools.ml.model.Prior;
import opennlp.tools.ml.model.UniformPrior;

public final class GISModel
extends AbstractModel {
    public GISModel(Context[] params, String[] predLabels, String[] outcomeNames) {
        this(params, predLabels, outcomeNames, new UniformPrior());
    }

    public GISModel(Context[] params, String[] predLabels, String[] outcomeNames, Prior prior) {
        super(params, predLabels, outcomeNames);
        this.prior = prior;
        prior.setLabels(outcomeNames, predLabels);
        this.modelType = AbstractModel.ModelType.Maxent;
    }

    @Override
    public final double[] eval(String[] context) {
        return this.eval(context, new double[this.evalParams.getNumOutcomes()]);
    }

    @Override
    public final double[] eval(String[] context, float[] values) {
        return this.eval(context, values, new double[this.evalParams.getNumOutcomes()]);
    }

    @Override
    public final double[] eval(String[] context, double[] outsums) {
        return this.eval(context, null, outsums);
    }

    public final double[] eval(String[] context, float[] values, double[] outsums) {
        Context[] scontexts = new Context[context.length];
        for (int i = 0; i < context.length; ++i) {
            scontexts[i] = (Context)this.pmap.get(context[i]);
        }
        this.prior.logPrior(outsums, scontexts, values);
        return GISModel.eval(scontexts, values, outsums, this.evalParams);
    }

    public static double[] eval(int[] context, double[] prior, EvalParameters model) {
        return GISModel.eval(context, null, prior, model);
    }

    static double[] eval(int[] context, float[] values, double[] prior, EvalParameters model) {
        Context[] scontexts = new Context[context.length];
        for (int i = 0; i < context.length; ++i) {
            scontexts[i] = model.getParams()[context[i]];
        }
        return GISModel.eval(scontexts, values, prior, model);
    }

    static double[] eval(Context[] context, float[] values, double[] prior, EvalParameters model) {
        int oid;
        ArrayMath.sumFeatures(context, values, prior);
        double normal = 0.0;
        for (oid = 0; oid < model.getNumOutcomes(); ++oid) {
            prior[oid] = Math.exp(prior[oid]);
            normal += prior[oid];
        }
        oid = 0;
        while (oid < model.getNumOutcomes()) {
            int n = oid++;
            prior[n] = prior[n] / normal;
        }
        return prior;
    }
}

