/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;

public class StringList
implements Iterable<String> {
    private String[] tokens;

    public StringList(String singleToken) {
        this.tokens = new String[]{singleToken.intern()};
    }

    public StringList(String ... tokens) {
        Objects.requireNonNull(tokens, "tokens must not be null");
        if (tokens.length == 0) {
            throw new IllegalArgumentException("tokens must not be empty");
        }
        this.tokens = new String[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            this.tokens[i] = tokens[i].intern();
        }
    }

    public String getToken(int index) {
        return this.tokens[index];
    }

    public int size() {
        return this.tokens.length;
    }

    @Override
    public Iterator<String> iterator() {
        return new Iterator<String>(){
            private int index;

            @Override
            public boolean hasNext() {
                return this.index < StringList.this.size();
            }

            @Override
            public String next() {
                if (this.hasNext()) {
                    return StringList.this.getToken(this.index++);
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public boolean compareToIgnoreCase(StringList tokens) {
        if (this.size() == tokens.size()) {
            for (int i = 0; i < this.size(); ++i) {
                if (this.getToken(i).compareToIgnoreCase(tokens.getToken(i)) == 0) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Arrays.hashCode(this.tokens);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof StringList) {
            StringList tokenList = (StringList)obj;
            return Arrays.equals(this.tokens, tokenList.tokens);
        }
        return false;
    }

    public String toString() {
        StringBuilder string = new StringBuilder();
        string.append('[');
        for (int i = 0; i < this.size(); ++i) {
            string.append(this.getToken(i));
            if (i >= this.size() - 1) continue;
            string.append(',');
        }
        string.append(']');
        return string.toString();
    }
}

