/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.session;

import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.session.SqlSessionException;

public enum AutoMappingUnknownColumnBehavior {
    NONE{

        @Override
        public void doAction(MappedStatement mappedStatement, String columnName, String property, Class<?> propertyType) {
        }
    }
    ,
    WARNING{

        @Override
        public void doAction(MappedStatement mappedStatement, String columnName, String property, Class<?> propertyType) {
            LogHolder.log.warn(AutoMappingUnknownColumnBehavior.buildMessage(mappedStatement, columnName, property, propertyType));
        }
    }
    ,
    FAILING{

        @Override
        public void doAction(MappedStatement mappedStatement, String columnName, String property, Class<?> propertyType) {
            throw new SqlSessionException(AutoMappingUnknownColumnBehavior.buildMessage(mappedStatement, columnName, property, propertyType));
        }
    };


    public abstract void doAction(MappedStatement var1, String var2, String var3, Class<?> var4);

    private static String buildMessage(MappedStatement mappedStatement, String columnName, String property, Class<?> propertyType) {
        return "Unknown column is detected on '" + mappedStatement.getId() + "' auto-mapping. Mapping parameters are " + "[" + "columnName=" + columnName + "," + "propertyName=" + property + "," + "propertyType=" + (propertyType != null ? propertyType.getName() : null) + "]";
    }

    private static class LogHolder {
        private static final Log log = LogFactory.getLog(AutoMappingUnknownColumnBehavior.class);

        private LogHolder() {
        }
    }
}

